/*
 * Simple-EFS driver: header file
 *
 * Author:
 *   Dietmar Maurer (dm@vlsivie.tuwien.ac.at)
 *
 *
 */

#ifndef _EFS_FSYS_H_
#define _EFS_FSYS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <config.h>
#include <glib.h>
#include <sys/types.h>

#ifdef HAVE_DIRENT_H
# include <dirent.h>
#else /* not HAVE_DIRENT_H */
# define dirent direct
# ifdef HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif /* HAVE_SYS_NDIR_H */
# ifdef HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif /* HAVE_SYS_DIR_H */
# ifdef HAVE_NDIR_H
#  include <ndir.h>
# endif /* HAVE_NDIR_H */
#endif /* HAVE_DIRENT_H */

#include "vefs.h"


typedef struct {
	EFSFile      file;
        gint         fd;
} FSYSFile;

typedef struct {
	EFSDir       dir;
        DIR         *d;
	gchar       *path;
	EFSDirEntry  de;
} FSYSDir;

extern EFSSuperOps super_ops_fsys;
extern EFSINodeOps inode_ops_fsys;
extern EFSFileOps  file_ops_fsys;

#ifdef __cplusplus
}
#endif

#endif /* _EFS_FSYS_H_ */


