/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
#ifndef _BONOBO_UI_ITEM_H_
#define _BONOBO_UI_ITEM_H_

#include <bonobo/bonobo-object.h>

BEGIN_GNOME_DECLS

#define BONOBO_UI_ITEM_TYPE        (bonobo_ui_item_get_type ())
#define BONOBO_UI_ITEM(o)          (GTK_CHECK_CAST ((o), BONOBO_UI_ITEM_TYPE, BonoboUIItem))
#define BONOBO_UI_ITEM_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), BONOBO_UI_ITEM_TYPE, BonoboUIItemClass))
#define BONOBO_IS_UI_ITEM(o)       (GTK_CHECK_TYPE ((o), BONOBO_UI_ITEM_TYPE))
#define BONOBO_IS_UI_ITEM_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), BONOBO_UI_ITEM_TYPE))

typedef struct _BonoboUIItem BonoboUIItem;

/*
 * FIXME: the toolbar container should emit a
 * signal that sets the GtkToolbarOption
 */
struct _BonoboUIItem {
	GtkBin            bin;

	GtkWidget        *widget;
	GtkWidget        *label;
	GtkWidget        *pixmap;

	gpointer          dummy;
};

typedef struct {
	GtkBinClass       bin_class;

	void            (*set_style)    (BonoboUIItem  *item,
					 GtkReliefStyle  relief,
					 GtkToolbarStyle look);

	void            (*set_state)    (BonoboUIItem  *item,
					 const char     *state);

	/*
	 *   This signal notifies that the state changed, and shows
	 * what it changed to.
	 */
	void           (*state_altered) (BonoboUIItem  *item,
					 const char     *new_state);

	/*
	 *   This signal signifies that the item has been activated
	 * most usualy by clicking the button.
	 */
	void           (*activate)      (BonoboUIItem  *item);

	gpointer          dummy;
} BonoboUIItemClass;

GtkType    bonobo_ui_item_get_type      (void);

GtkWidget *bonobo_ui_item_new_item      (const char       *label,
					  GtkWidget        *pixmap);

GtkWidget *bonobo_ui_item_new_toggle    (const char       *label,
					  GtkWidget        *pixmap);

GtkWidget *bonobo_ui_item_new_separator (void);

GtkWidget *bonobo_ui_item_new_control   (Bonobo_Unknown control);

void       bonobo_ui_item_set_state     (BonoboUIItem  *item,
					  const char     *state);

void       bonobo_ui_item_set_style     (BonoboUIItem  *item,
					  GtkReliefStyle  relief,
					  GtkToolbarStyle look);

void       bonobo_ui_item_set_tooltip   (BonoboUIItem  *item,
					  GtkTooltips    *tooltips,
					  const char     *descr);

END_GNOME_DECLS

#endif /* _BONOBO_UI_ITEM_H_ */

