/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * bonobo-property-listener.c: Property listener implementation.
 *
 * Author:
 *	Mike Kestner (mkestner@ameritech.net)
 */
#include <config.h>
#include <gtk/gtksignal.h>

#include <bonobo/bonobo-exception.h>
#include <bonobo/bonobo-property-listener.h>

POA_Bonobo_PropertyListener__vepv bonobo_property_listener_vepv;

#define CLASS(o) BONOBO_PROPERTY_LISTENER_CLASS (GTK_OBJECT (o)->klass)

enum SIGNALS {
	PROP_CHANGED,
	LAST_SIGNAL
};
static guint signals [LAST_SIGNAL] = { 0 };

static inline BonoboPropertyListener *
bonobo_property_listener_from_servant (PortableServer_Servant servant)
{
	return BONOBO_PROPERTY_LISTENER (bonobo_object_from_servant (servant));
}

static void
impl_event (PortableServer_Servant servant, const CORBA_char *name,
	    const BonoboArg *value, CORBA_Environment *ev)
{
	BonoboPropertyListener *listener = bonobo_property_listener_from_servant (servant);

	gtk_signal_emit (GTK_OBJECT (listener), signals [PROP_CHANGED], name, value);
}

/**
 * bonobo_property_listener_get_epv:
 */
POA_Bonobo_PropertyListener__epv *
bonobo_property_listener_get_epv (void)
{
	POA_Bonobo_PropertyListener__epv *epv;

	epv = g_new0 (POA_Bonobo_PropertyListener__epv, 1);

	epv->event = impl_event;

	return epv;
}

static void
init_property_listener_corba_class (void)
{
	/* The VEPV */
	bonobo_property_listener_vepv.Bonobo_Unknown_epv = bonobo_object_get_epv ();
	bonobo_property_listener_vepv.Bonobo_PropertyListener_epv = bonobo_property_listener_get_epv ();
}

static void
bonobo_property_listener_class_init (BonoboPropertyListenerClass *klass)
{
	GtkObjectClass *oclass = (GtkObjectClass *)klass;

	signals [PROP_CHANGED] = gtk_signal_new (
		"prop_changed", GTK_RUN_LAST, oclass->type,
		GTK_SIGNAL_OFFSET (BonoboPropertyListenerClass, prop_changed),
		gtk_marshal_NONE__POINTER_POINTER, GTK_TYPE_NONE, 2,
		GTK_TYPE_STRING, GTK_TYPE_POINTER);

	gtk_object_class_add_signals (oclass, signals, LAST_SIGNAL);

	init_property_listener_corba_class ();
}

/**
 * bonobo_property_listener_get_type:
 *
 * Returns: the GtkType for a BonoboPropertyListener.
 */
GtkType
bonobo_property_listener_get_type (void)
{
	static GtkType type = 0;

	if (!type) {
		GtkTypeInfo info = {
			"BonoboPropertyListener",
			sizeof (BonoboPropertyListener),
			sizeof (BonoboPropertyListenerClass),
			(GtkClassInitFunc) bonobo_property_listener_class_init,
			(GtkObjectInitFunc) NULL,
			NULL, /* reserved 1 */
			NULL, /* reserved 2 */
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (bonobo_object_get_type (), &info);
	}

	return type;
}

static Bonobo_PropertyListener
bonobo_property_listener_corba_object_create (BonoboObject *object)
{
	POA_Bonobo_PropertyListener *servant;
	CORBA_Environment ev;

	servant = (POA_Bonobo_PropertyListener *) g_new0 (BonoboObjectServant, 1);
	servant->vepv = &bonobo_property_listener_vepv;

	CORBA_exception_init (&ev);

	POA_Bonobo_PropertyListener__init ((PortableServer_Servant) servant, &ev);
	if (BONOBO_EX (&ev)) {
                g_free (servant);
		CORBA_exception_free (&ev);
                return CORBA_OBJECT_NIL;
        }

	CORBA_exception_free (&ev);

	return bonobo_object_activate_servant (object, servant);
}

/**
 * bonobo_property_listener_new:
 *
 * Creates a Property listener.  The listener emits an "event_notify" signal when
 * notified of an event.  The signal callback should be of the form:
 *
 *	void some_callback (GtkObject *, gchar *name, BonoboArg *event_data, gpointer some_data);
 *
 * Returns: A BonoboPropertyListener object.
 */
BonoboPropertyListener*
bonobo_property_listener_new ()
{
	BonoboPropertyListener *listener;
	Bonobo_PropertyListener corba_listener;

	listener = gtk_type_new (BONOBO_PROPERTY_LISTENER_TYPE);

	corba_listener = bonobo_property_listener_corba_object_create (
		BONOBO_OBJECT (listener));

	if (corba_listener == CORBA_OBJECT_NIL) {
		bonobo_object_unref (BONOBO_OBJECT (listener));
		return NULL;
	}
	
	bonobo_object_construct (BONOBO_OBJECT (listener), corba_listener);

	return listener;
}

