
#ifndef _BONOBO_VIEW_H_
#define _BONOBO_VIEW_H_

#include <libgnome/gnome-defs.h>
#include <gtk/gtkobject.h>
#include <gtk/gtkwindow.h>
#include <bonobo/bonobo-object.h>

BEGIN_GNOME_DECLS
 
#define BONOBO_DESKTOP_WINDOW_TYPE        (bonobo_desktop_window_get_type ())
#define BONOBO_DESKTOP_WINDOW(o)          (GTK_CHECK_CAST ((o), BONOBO_DESKTOP_WINDOW_TYPE, BonoboDesktopWindow))
#define BONOBO_DESKTOP_WINDOW_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), BONOBO_DESKTOP_WINDOW_TYPE, BonoboDesktopWindowClass))
#define BONOBO_IS_DESKTOP_WINDOW(o)       (GTK_CHECK_TYPE ((o), BONOBO_DESKTOP_WINDOW_TYPE))
#define BONOBO_IS_DESKTOP_WINDOW_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), BONOBO_DESKTOP_WINDOW_TYPE))

typedef struct _BonoboDesktopWindow BonoboDesktopWindow;
typedef struct _BonoboDesktopWindowPrivate BonoboDesktopWindowPrivate;
typedef struct _BonoboDesktopWindowClass BonoboDesktopWindowClass;

struct _BonoboDesktopWindow {
	BonoboObject base;
	GtkWindow   *window;
	BonoboDesktopWindowPrivate *priv;
};

struct _BonoboDesktopWindowClass {
	BonoboObjectClass parent_class;
};

GtkType             bonobo_desktop_window_get_type  (void);
BonoboDesktopWindow *bonobo_desktop_window_construct (BonoboDesktopWindow *desktop_window,
						    Bonobo_Desktop_Window corba_desktop_window,
						    GtkWindow *toplevel);
BonoboDesktopWindow *bonobo_desktop_window_new       (GtkWindow *toplevel);
void                bonobo_desktop_window_control   (BonoboObject *object,
						    GtkWindow *win);
Bonobo_Desktop_Window bonobo_desktop_window_corba_object_create (BonoboObject *object);

POA_Bonobo_Desktop_Window__epv *bonobo_desktop_window_get_epv   (void);

END_GNOME_DECLS

#endif /* _BONOBO_DESKTOP_WINDOW_H_ */
