/*
 * Simple-EFS driver: header file
 *
 * Author:
 *   Dietmar Maurer (dm@vlsivie.tuwien.ac.at)
 *
 *
 */

#ifndef _EFS_SIMPLE_H_
#define _EFS_SIMPLE_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <config.h>
#include <glib.h>

#include "vefs.h"

#define SIMPLE_NAME_LEN 248
#define SIMPLE_N_BLOCKS 16

#define NODEP(ce,inode) ((SimpleINode *)(ce->data+(inode%4)*128))

typedef struct {
	EFSFile      file;
        guint32      inode;
	guint32      pos;
} SimpleFile;

typedef struct {
	EFSDir       dir;
        guint32      inode;
	guint32      pos;
	EFSDirEntry  de;
} SimpleDir;


typedef struct {
	guint32 inode;
	guint16 rec_len;
	guint8  name_len;
	guint8  type;
	gchar   name[SIMPLE_NAME_LEN];
} SimpleDirEntry ;

typedef struct {
        guint32 num;
	guint32 size;
	guint32 blocks;
	guint32 block[SIMPLE_N_BLOCKS];
	guint32 mod_time;
	gchar   data[48];
} SimpleINode;

typedef struct {
	guint32  mbc;
	gboolean modified;
	guint32 *data[512]; /* max 512*512*8 blocks = 1GB */
	guint32  fbc[512];
} SimpleBitmap;

typedef struct {
	guint32 inode_ind;
	guint32 block[2];
} SimpleIMapEntry;

typedef struct {
	guint32          max;
	guint32          count;
	gboolean         modified;
	SimpleIMapEntry *data;
} SimpleIMap;

typedef struct {
	EFSHeader head;
	guint32   block_count;
	guint32   cb;             /* commited blocks */
	guint32   version;
	guint32   imap_start;
	guint32   imap_length;
	guint32   bmap_start;
	guint32   bmap_length;
	guint32   csum;

	gchar buf[512];
} SimpleHeader;

typedef struct {
	SimpleHeader  head;
	SimpleBitmap  bmap;
	SimpleIMap    imap;
} SimpleEFS;

extern EFSSuperOps super_ops_simple;
extern EFSINodeOps inode_ops_simple;
extern EFSFileOps  file_ops_simple;

gint           simple_write_imap     (EFS *efs);
gint           simple_write_bmap     (EFS *efs);
gint           simple_inode_clone    (EFS *efs, guint32 inode);

guint32        simple_block_alloc    (EFS *efs);
void           simple_block_free     (EFS *efs, guint32 block);

void           simple_print_fat      (EFS *efs);

#ifdef __cplusplus
}
#endif

#endif /* _EFS_SIMPLE_H_ */


