/* -*-mode:c; c-style:k&r; c-basic-offset:4; -*- */
/* Balsa E-Mail Client
 * Copyright (C) 1997-2000 Stuart Parmenter and others,
 *                         See the file AUTHORS for a list.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option) 
 * any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef __MAIN_WINDOW_H__
#define __MAIN_WINDOW_H__

#define BALSA_TYPE_WINDOW		       (balsa_window_get_type ())
#define BALSA_WINDOW(obj)		       (GTK_CHECK_CAST (obj, BALSA_TYPE_WINDOW, BalsaWindow))
#define BALSA_WINDOW_CLASS(klass)	       (GTK_CHECK_CLASS_CAST (klass, BALSA_TYPE_WINDOW, BalsaWindowClass))
#define BALSA_IS_WINDOW(obj)		       (GTK_CHECK_TYPE (obj, BALSA_TYPE_WINDOW))
#define BALSA_IS_WINDOW_CLASS(klass)	       (GTK_CHECK_CLASS_TYPE (klass, BALSA_TYPE_WINDOW))


typedef struct _BalsaWindow BalsaWindow;
typedef struct _BalsaWindowClass BalsaWindowClass;

struct _BalsaWindow {
    GnomeApp window;

    GtkWidget *progress_bar;
    GtkWidget *mblist;
    GtkWidget *notebook;
    GtkWidget *preview;		/* message is child */
};

struct _BalsaWindowClass {
    GnomeAppClass parent_class;

    void (*open_mailbox) (BalsaWindow * window, LibBalsaMailbox * mailbox);
    void (*close_mailbox) (BalsaWindow * window,
			   LibBalsaMailbox * mailbox);
};

GtkType balsa_window_get_type(void);
GtkWidget *balsa_window_new(void);
GtkWidget *balsa_window_find_current_index(BalsaWindow * window);
void balsa_window_refresh(BalsaWindow * window);
void balsa_window_open_mailbox();
void balsa_window_close_mailbox();
void balsa_window_enable_continue(void);
gboolean mail_progress_notify_cb(void);
gboolean send_progress_notify_cb(void);
gint check_new_messages_auto_cb(gpointer data);
void check_new_messages_cb(GtkWidget *, gpointer data);

#if defined(__FILE__) && defined(__LINE__)
# ifdef __FUNCTION__
#  define BALSA_DEBUG_MSG(message)  if (balsa_app.debug)  fprintf(stderr, "[%lu] %12s | %4d | %30s: %s\n", (unsigned long) time(NULL), __FILE__, __LINE__, __FUNCTION__, message)
#  define BALSA_DEBUG() if (balsa_app.debug) fprintf (stderr, "[%lu] %12s | %4d | %30s\n", (unsigned long) time(NULL), __FILE__, __LINE__, __FUNCTION__)
# else
#  define BALSA_DEBUG_MSG(message)  if (balsa_app.debug)  fprintf(stderr, "[%lu] %12s | %4d: %s\n", (unsigned long) time(NULL), __FILE__, __LINE__, message)
#  define BALSA_DEBUG() if (balsa_app.debug)  fprintf(stderr, "[%lu] %12s | %4d\n", (unsigned long) time(NULL), __FILE__, __LINE__)
# endif
#endif

#endif				/* __MAIN_WINDOW_H__ */
