/* -*-mode:c; c-style:k&r; c-basic-offset:4; -*- */
/* Balsa E-Mail Client
 *
 * Copyright (C) 1997-2000 Stuart Parmenter and others,
 *                         See the file AUTHORS for a list.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option) 
 * any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef __LIBBALSA_IMAPDIR_H__
#define __LIBBALSA_IMAPDIR_H__


struct _ImapDir {
    gchar *name;
    gchar *path;
    gchar *user;
    gchar *passwd;
    gchar *host;
    gint port;
    GNode *file_tree;		/* GNode structure representing the IMAP directory */
    int ignore_hidden:1;
};

ImapDir *imapdir_new(void);
void imapdir_destroy(ImapDir * imap_dir);
const gchar *imapdir_scan(ImapDir * id);

#endif				/* __LIBBALSA_IMAPDIR_H__ */
