dnl aclocal.m4 generated automatically by aclocal 1.4-p4

dnl Copyright (C) 1994, 1995-8, 1999 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN(AM_INIT_AUTOMAKE,
[AC_REQUIRE([AC_PROG_INSTALL])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE", [Name of package])
AC_DEFINE_UNQUOTED(VERSION, "$VERSION", [Version number of package]))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
AC_REQUIRE([AC_PROG_MAKE_SET])])

#
# Check to make sure that the build environment is sane.
#

AC_DEFUN(AM_SANITY_CHECK,
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftestfile
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftestfile 2> /dev/null`
   if test "[$]*" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftestfile`
   fi
   if test "[$]*" != "X $srcdir/configure conftestfile" \
      && test "[$]*" != "X conftestfile $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "[$]2" = conftestfile
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
rm -f conftest*
AC_MSG_RESULT(yes)])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN(AM_MISSING_PROG,
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])

#serial 1
# This test replaces the one in autoconf.
# Currently this macro should have the same name as the autoconf macro
# because gettext's gettext.m4 (distributed in the automake package)
# still uses it.  Otherwise, the use in gettext.m4 makes autoheader
# give these diagnostics:
#   configure.in:556: AC_TRY_COMPILE was called before AC_ISC_POSIX
#   configure.in:556: AC_TRY_RUN was called before AC_ISC_POSIX

undefine([AC_ISC_POSIX])

AC_DEFUN([AC_ISC_POSIX],
  [
    dnl This test replaces the obsolescent AC_ISC_POSIX kludge.
    AC_CHECK_LIB(cposix, strerror, [LIBS="$LIBS -lcposix"])
  ]
)

# aclocal-include.m4
# 
# This macro adds the name macrodir to the set of directories
# that `aclocal' searches for macros.  

# serial 1

dnl AM_ACLOCAL_INCLUDE(macrodir)
AC_DEFUN([AM_ACLOCAL_INCLUDE],
[
	AM_CONDITIONAL(INSIDE_GNOME_COMMON, test x = y)

	test -n "$ACLOCAL_FLAGS" && ACLOCAL="$ACLOCAL $ACLOCAL_FLAGS"

	for k in $1 ; do ACLOCAL="$ACLOCAL -I $k" ; done
])

# Define a conditional.

AC_DEFUN(AM_CONDITIONAL,
[AC_SUBST($1_TRUE)
AC_SUBST($1_FALSE)
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi])

# Copyright (C) 2001 Sam Tobin-Hochstadt
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.
#
# The above license applies to THIS FILE ONLY, the abiword code
# itself may be copied and distributed under the terms of the GNU
# GPL, see COPYING for more details
#
# This file detects which of the AbiWord platforms we are currently
# building on.  The detection logic in question is mostly by Jeff
# Hostetler, and is taken from the original AbiWord build system.  
#
# Usage: ABI_DETECT_PLATFORM
# The platform is then available in the PLATFORM variable.
# 
# TODO Rewrite this to use $host, which is likely to be more accurate
# and actually maintained.

AC_DEFUN([ABI_DETECT_PLATFORM], [

# OS_NAME is the output of uname -s minus any forward slashes
# (so we don't imply another level of depth).  This is to solve
# a problem with BSD/OS.  In fact, it might be good to do this
# to all uname results, so that one doesn't see "sun4/m" as an
# architecture.  The substitutions are taken from the Linux
# kernel Makefile.  The result of this is that even if you have
# a Pentium Pro, you will see your bins in a "...i386" directory.
# This doesn't mean it didn't use your optimizations.

# this makes HP-UX look like "HP" (sed turns "HP-UX" into "HP" with the -.* pattern)
OS_NAME=`uname -s | sed "s/\//-/" | sed "s/_/-/" | sed "s/-.*//g"`
OS_RELEASE=`uname -r | sed "s/\//-/" | sed "s/[() ].*//g"`


if test "$OS_NAME" = "CYGWIN32"; then
	OS_NAME="WIN32"
fi

if test "$OS_NAME" = "CYGWIN"; then
	OS_NAME="WIN32"
fi

if test "$OS_NAME" = "WIN32"; then
	CYGWIN_MAJOR_VERSION=`echo $(OS_RELEASE) | cut -d . -f 1`
	CYGWIN_MINOR_VERSION=`echo $(OS_RELEASE) | cut -d . -f 2`
	CYGWIN_REVISION=`echo $(OS_RELEASE) | cut -d . -f 3`
fi


if test "$OS_NAME" = "Darwin"; then
	OS_NAME=MACOSX
fi

# At this point, we now have the following info:
# OS_NAME = something like 'Linux'
# OS_RELEASE = something like '2.4.1'
# Additionally, there may be info about Cygwin versions.

# huge nasty case statement to actually pick the platform

case "$OS_NAME" in 
	WIN32) PLATFORM="win" ;;
	Linux|AIX|*BSD|IRIX*|HP|OSF1|SunOS) PLATFORM="unix" ;;
	QNX|procnto) PLATFORM="qnx" ;;
	MACOSX) PLATFORM="mac" ;;
	BeOS) PLATFORM="beos" ;;
esac

AC_SUBST(PLATFORM)
AC_SUBST(OS_NAME)

])


# On unix, Check for glib and gtk libraries.  Ensure that the version
# number of glib is >= 1.2.0 and the version number of gtk is >= 1.2.2

# Usage: 
# ABI_GLIB_GTK
#

AC_DEFUN([ABI_GLIB_GTK], [

if test "$OS_NAME" = "FreeBSD"; then
	GLIB_CONFIG=glib12-config
	GTK_CONFIG=gtk12-config
else
	GLIB_CONFIG=glib-config
	GTK_CONFIG=gtk-config
fi

if test "$PLATFORM" = "unix"; then
        dnl ******************************
        dnl glib checking
        dnl ******************************
        AC_MSG_CHECKING(for glib >= 1.2.0)
        if $GLIB_CONFIG --version > /dev/null 2>&1; then 
            dnl We need the "%d" in order not to get e-notation on hpux.
            vers=`$GLIB_CONFIG --version | awk 'BEGIN { FS = "."; } { printf "%d", ($[1] * 1000 + $[2]) * 1000 + $[3];}'`
            if test "$vers" -ge 1002000; then
                AC_MSG_RESULT(found)
            else
	        AC_MSG_ERROR(You need at least glib 1.2.0 for this version of AbiWord)
            fi
        else
            AC_MSG_ERROR(Did not find glib installed)
        fi

        dnl AM_PATH_GLIB(1.2.0)
        GMODULE_CFLAGS=`$GLIB_CONFIG --cflags gmodule`
        GMODULE_LIBS=`$GLIB_CONFIG --libs gmodule`

        dnl ******************************
        dnl gtk+ checking
        dnl ******************************
        AC_MSG_CHECKING(for GTK >= 1.2.2)
        if $GTK_CONFIG --version > /dev/null 2>&1; then 
            dnl We need the "%d" in order not to get e-notation on hpux.
            vers=`$GTK_CONFIG --version | awk 'BEGIN { FS = "."; } { printf "%d", ($[1] * 1000 + $[2]) * 1000 + $[3];}'`
            if test "$vers" -ge 1002002; then
                AC_MSG_RESULT(found)
            else
                AC_MSG_ERROR(You need at least GTK+ 1.2.2 for this version of AbiWord)
            fi
        else
            AC_MSG_ERROR(Did not find GTK+ installed)
        fi

        GTK_CFLAGS=`$GTK_CONFIG --cflags`
        GTK_LIBS=`$GTK_CONFIG --libs`

        AC_SUBST(GTK_CFLAGS)
        AC_SUBST(GTK_LIBS)
        AC_SUBST(GMODULE_CFLAGS)
        AC_SUBST(GMODULE_LIBS)
fi

])

# Configure paths for GLIB
# Owen Taylor     97-11-3

dnl AM_PATH_GLIB([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, MODULES]]]])
dnl Test for GLIB, and define GLIB_CFLAGS and GLIB_LIBS, if "gmodule" or 
dnl gthread is specified in MODULES, pass to glib-config
dnl
AC_DEFUN(AM_PATH_GLIB,
[dnl 
dnl Get the cflags and libraries from the glib-config script
dnl
AC_ARG_WITH(glib-prefix,[  --with-glib-prefix=PFX   Prefix where GLIB is installed (optional)],
            glib_config_prefix="$withval", glib_config_prefix="")
AC_ARG_WITH(glib-exec-prefix,[  --with-glib-exec-prefix=PFX Exec prefix where GLIB is installed (optional)],
            glib_config_exec_prefix="$withval", glib_config_exec_prefix="")
AC_ARG_ENABLE(glibtest, [  --disable-glibtest       Do not try to compile and run a test GLIB program],
		    , enable_glibtest=yes)

  if test x$glib_config_exec_prefix != x ; then
     glib_config_args="$glib_config_args --exec-prefix=$glib_config_exec_prefix"
     if test x${GLIB_CONFIG+set} != xset ; then
        GLIB_CONFIG=$glib_config_exec_prefix/bin/glib-config
     fi
  fi
  if test x$glib_config_prefix != x ; then
     glib_config_args="$glib_config_args --prefix=$glib_config_prefix"
     if test x${GLIB_CONFIG+set} != xset ; then
        GLIB_CONFIG=$glib_config_prefix/bin/glib-config
     fi
  fi

  for module in . $4
  do
      case "$module" in
         gmodule) 
             glib_config_args="$glib_config_args gmodule"
         ;;
         gthread) 
             glib_config_args="$glib_config_args gthread"
         ;;
      esac
  done

  AC_PATH_PROG(GLIB_CONFIG, glib-config, no)
  min_glib_version=ifelse([$1], ,0.99.7,$1)
  AC_MSG_CHECKING(for GLIB - version >= $min_glib_version)
  no_glib=""
  if test "$GLIB_CONFIG" = "no" ; then
    no_glib=yes
  else
    GLIB_CFLAGS=`$GLIB_CONFIG $glib_config_args --cflags`
    GLIB_LIBS=`$GLIB_CONFIG $glib_config_args --libs`
    glib_config_major_version=`$GLIB_CONFIG $glib_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    glib_config_minor_version=`$GLIB_CONFIG $glib_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    glib_config_micro_version=`$GLIB_CONFIG $glib_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_glibtest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $GLIB_CFLAGS"
      LIBS="$GLIB_LIBS $LIBS"
dnl
dnl Now check if the installed GLIB is sufficiently new. (Also sanity
dnl checks the results of glib-config to some extent
dnl
      rm -f conf.glibtest
      AC_TRY_RUN([
#include <glib.h>
#include <stdio.h>
#include <stdlib.h>

int 
main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.glibtest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = g_strdup("$min_glib_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_glib_version");
     exit(1);
   }

  if ((glib_major_version != $glib_config_major_version) ||
      (glib_minor_version != $glib_config_minor_version) ||
      (glib_micro_version != $glib_config_micro_version))
    {
      printf("\n*** 'glib-config --version' returned %d.%d.%d, but GLIB (%d.%d.%d)\n", 
             $glib_config_major_version, $glib_config_minor_version, $glib_config_micro_version,
             glib_major_version, glib_minor_version, glib_micro_version);
      printf ("*** was found! If glib-config was correct, then it is best\n");
      printf ("*** to remove the old version of GLIB. You may also be able to fix the error\n");
      printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf("*** required on your system.\n");
      printf("*** If glib-config was wrong, set the environment variable GLIB_CONFIG\n");
      printf("*** to point to the correct copy of glib-config, and remove the file config.cache\n");
      printf("*** before re-running configure\n");
    } 
  else if ((glib_major_version != GLIB_MAJOR_VERSION) ||
	   (glib_minor_version != GLIB_MINOR_VERSION) ||
           (glib_micro_version != GLIB_MICRO_VERSION))
    {
      printf("*** GLIB header files (version %d.%d.%d) do not match\n",
	     GLIB_MAJOR_VERSION, GLIB_MINOR_VERSION, GLIB_MICRO_VERSION);
      printf("*** library (version %d.%d.%d)\n",
	     glib_major_version, glib_minor_version, glib_micro_version);
    }
  else
    {
      if ((glib_major_version > major) ||
        ((glib_major_version == major) && (glib_minor_version > minor)) ||
        ((glib_major_version == major) && (glib_minor_version == minor) && (glib_micro_version >= micro)))
      {
        return 0;
       }
     else
      {
        printf("\n*** An old version of GLIB (%d.%d.%d) was found.\n",
               glib_major_version, glib_minor_version, glib_micro_version);
        printf("*** You need a version of GLIB newer than %d.%d.%d. The latest version of\n",
	       major, minor, micro);
        printf("*** GLIB is always available from ftp://ftp.gtk.org.\n");
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the glib-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of GLIB, but you can also set the GLIB_CONFIG environment to point to the\n");
        printf("*** correct copy of glib-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
      }
    }
  return 1;
}
],, no_glib=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_glib" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$GLIB_CONFIG" = "no" ; then
       echo "*** The glib-config script installed by GLIB could not be found"
       echo "*** If GLIB was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the GLIB_CONFIG environment variable to the"
       echo "*** full path to glib-config."
     else
       if test -f conf.glibtest ; then
        :
       else
          echo "*** Could not run GLIB test program, checking why..."
          CFLAGS="$CFLAGS $GLIB_CFLAGS"
          LIBS="$LIBS $GLIB_LIBS"
          AC_TRY_LINK([
#include <glib.h>
#include <stdio.h>
],      [ return ((glib_major_version) || (glib_minor_version) || (glib_micro_version)); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding GLIB or finding the wrong"
          echo "*** version of GLIB. If it is not finding GLIB, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"
          echo "***"
          echo "*** If you have a RedHat 5.0 system, you should remove the GTK package that"
          echo "*** came with the system with the command"
          echo "***"
          echo "***    rpm --erase --nodeps gtk gtk-devel" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means GLIB was incorrectly installed"
          echo "*** or that you have moved GLIB since it was installed. In the latter case, you"
          echo "*** may want to edit the glib-config script: $GLIB_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     GLIB_CFLAGS=""
     GLIB_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(GLIB_CFLAGS)
  AC_SUBST(GLIB_LIBS)
  rm -f conf.glibtest
])

# Copyright (C) 1998-2000 Joe Orton, Sam Tobin-Hochstadt
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.

# The above license applies to THIS FILE ONLY, the abiword code
# itself may be copied and distributed under the terms of the GNU
# GPL, see COPYING for more details

# Check for XML parser.
# Supports:
#  *  libxml2
#  *  expat in -lexpat
#  *  expat in -lxmlparse and -lxmltok (as formerly packaged by Debian/Red Hat)
#  *  Bundled expat if a directory name argument is passed
#
# This has been hacked, and all the names have been changed.  
#
# Usage: 
#  ABI_XML_PARSER()
# or
#  ABI_XML_PARSER(expat-dir)

AC_DEFUN([ABI_XML_PARSER], [

if test "$ABI_NEED_XML_PARSER" = "yes"; then

abi_found_parser="no"

AC_ARG_WITH([libxml2],
 	[  --with-libxml2         force use of libxml2 ],
 	[abi_force_libxml2=$witheval],
 	[abi_force_libxml2=no])

AC_ARG_WITH([expat],
 	[  --with-expat         force use of expat ],
 	[abi_force_expat=$withval],
 	[abi_force_expat=no])

# check for expat

if test "$abi_found_parser" = "no"; then
	echo "checking for expat"
	AC_CHECK_LIB(expat, XML_Parse,
		abi_expat_libs="-lexpat" abi_found_parser="expat",
		abi_found_parser="no"
		)
fi

# changed from the original neon test to detect libxml2, not libxml1.  

if test "$abi_found_parser" = "no" -a "$abi_force_expat" = "no" ; then
	#Have we got libxml2 or later?
	AC_CHECK_PROG(XML_CONFIG, xml2-config, xml2-config)
	if test "$XML_CONFIG" != ""; then
		#Check for recent library
		XML_LIBS="`$XML_CONFIG --libs`"
		XML_CFLAGS="`$XML_CONFIG --cflags` -DHAVE_LIBXML2"
		AC_CHECK_LIB(xml2, xmlCreatePushParserCtxt,
			abi_found_parser="libxml2" abi_xml_parser_message="libxml2"
			AC_DEFINE(HAVE_LIBXML2, 1, [Define if you have libxml2])
			,
			XML_CFLAGS=""
			XML_LIBS=""
			AC_WARN([cannot use libxml1; libxml2 is required ]),
                        $XML_LIBS)
		
	fi
fi

if test "$abi_found_parser" = "expat"; then
	# This is crap. Maybe just use AC_CHECK_HEADERS and use the
	# right file by ifdef'ing is best
	AC_CHECK_HEADER(expat.h,
	[abi_expat_incs="" abi_found_expatincs="yes" abi_expat_new="yes"=],
	AC_CHECK_HEADER(xmlparse.h,
	[abi_expat_incs="" abi_found_expatincs="yes" abi_expat_new=""],
	AC_CHECK_HEADER(xmlparse/xmlparse.h,
	[abi_expat_incs="-I/usr/include/xmlparse" abi_found_expatincs="yes" abi_expat_new=""],
	)))
	if test "$abi_found_expatincs" = "yes"; then
		AC_DEFINE(HAVE_EXPAT, 1, [Define if you have expat])
		if test ! "$abi_expat_new"; then
			AC_DEFINE(HAVE_OLD_EXPAT, 1, [Define if you have the jclark expat])
		fi
		if test "$abi_expat_incs"; then
			XML_CFLAGS="$abi_expat_incs"
		fi	
		XML_LIBS="$abi_expat_libs"
		abi_xml_parser_message="expat in $abi_expat_libs"
	else
	       AC_MSG_WARN(["found expat library but could not find expat.h or xmlparse.h"])
		abi_found_parser="no"
	fi
fi

if test "$abi_found_parser" = "no" ; then
    if test "x$1" != "x" && test -d "$1"; then
	# Use the expat sources given as an argument
        abspath=`cd $1; pwd`
	XML_LIBS="${abspath}/lib/.libs/libexpat.a"
	XML_CFLAGS="-I ${abspath}/lib/"
	AC_MSG_RESULT(using supplied expat XML parser)	
	AC_DEFINE(HAVE_EXPAT, 1, [Define if you have expat] )
	abi_xml_parser_message="supplied expat in ${abspath}"
	EXPAT_PEERDIR=${abspath}
        PEERDIRS="${PEERDIRS} ${EXPAT_PEERDIR}"
	PEERS="${PEERS} `basename ${abspath}`"
    else
	AC_MSG_ERROR([no XML parser was found])
    fi

fi

fi

AC_SUBST(XML_CFLAGS)
AC_SUBST(XML_LIBS)
AC_SUBST(EXPAT_PEERDIR)

])

# Copyright (C) 2001 Sam Tobin-Hochstadt
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.

# The above license applies to THIS FILE ONLY, the abiword code
# itself may be copied and distributed under the terms of the GNU
# GPL, see COPYING for more details

# Check for Psiconv library.
# Supports:
#  *  psiconv in -lpsiconv
#  *  Bundled psiconv if a directory name argument is passed
#
# Hacked from the abi-xml-parser.m4 code
#
# Usage: 
#  ABI_PSICONV
# or
#  ABI_PSICONV(psiconv-dir)

AC_DEFUN([ABI_PSICONV], [

if test "$ABI_NEED_PSICONV" = "yes"; then

abi_found_psiconv="no"

# check for a shared install

if test "$abi_found_psiconv" = "no"; then
	echo "checking for psiconv"
	AC_CHECK_LIB(psiconv, psiconv_write,
		PSICONV_LIBS="-lpsiconv" abi_found_psiconv="yes"
		)
fi

# check for the header file

if test "$abi_found_psiconv" = "yes"; then
	AC_CHECK_HEADER(psiconv/data.h, 
	[abi_found_psiconvincs="yes"])
	if test "$abi_found_psiconvincs" = "yes"; then
		PSICONV_CFLAGS=""
		abi_psiconv_message="psiconv in $abi_psiconv_libs"
	else 
		#AC_MSG_WARN([psiconv library found but header file missing])
		abi_found_psiconv="no"
		PSICONV_LIBS=""
	fi
fi


# otherwise, use the sources given as an argument.  [ this means the
# peer dir for abi ]

if test "$abi_found_psiconv" = "no"; then
    if test "x$1" != "x" && test -d "$1"; then
	abspath=`cd $1; pwd`
	PSICONV_LIBS="${abspath}/psiconv/.libs/libpsiconv.a"
	PSICONV_CFLAGS="-I${abspath}/"
	AC_MSG_RESULT(using supplied psiconv library)	
	AC_DEFINE(HAVE_PSICONV, 1, [ Define if you have psiconv ])
	abi_psiconv_message="supplied psiconv in ${abspath}"
	PSICONV_PEERDIR=${abspath}
        PEERDIRS="${PEERDIRS} ${PSICONV_PEERDIR}"
	PEERS="${PEERS} `basename ${abspath}`"
    else
	AC_MSG_ERROR([ psiconv was not found ])
    fi

fi

fi

AM_CONDITIONAL(LOCAL_PSICONV, test "$local_psiconv" = "true")
AC_SUBST(PSICONV_CFLAGS)
AC_SUBST(PSICONV_LIBS)
AC_SUBST(PSICONV_PEERDIR)

])

# Copyright (C) 2001 Sam Tobin-Hochstadt
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.

# The above license applies to THIS FILE ONLY, the abiword code
# itself may be copied and distributed under the terms of the GNU
# GPL, see COPYING for more details

# Check for Wv library.
# Supports:
#  *  wv in -lwv
#  *  Bundled wv if a directory name argument is passed
#
# Hacked from the abi-xml-parser.m4 code
#
# Usage: 
#  ABI_WV
# or
#  ABI_WV(wv-dir)

AC_DEFUN([ABI_WV], [

if test "$ABI_NEED_WV" = "yes"; then

abi_found_wv="no"

# check for a shared install

if test "$abi_found_wv" = "no"; then
	echo "checking for wv"
	AC_CHECK_LIB(wv, wvInitParser,
		WV_LIBS="-lwv" abi_found_wv="yes"
		)
fi

# check for the header file

if test "$abi_found_wv" = "yes"; then
	AC_CHECK_HEADER(wv.h, 
	[abi_found_wvincs="yes"])
	if test "$abi_found_wvincs" = "yes"; then
		WV_CFLAGS=""
		abi_wv_message="wv in $abi_wv_libs"
	else 
		#AC_MSG_WARN([wv library found but header file missing])
		abi_found_wv="no"
		WV_LIBS=""
	fi
fi


# otherwise, use the sources given as an argument.  [ this means the
# peer dir for abi ]

if test "$abi_found_wv" = "no"; then
    if test "x$1" != "x" && test -d "$1"; then
	abspath=`cd $1; pwd`
	WV_LIBS="${abspath}/libwv.a"
	WV_CFLAGS="-I${abspath}/"
	AC_MSG_RESULT(using supplied wv library)	
	AC_DEFINE(HAVE_WV, 1, [ Define if you have wv ])
	abi_wv_message="supplied wv in ${abspath}"
	WV_PEERDIR=${abspath}
        PEERDIRS="${PEERDIRS} ${WV_PEERDIR}"
	PEERS="${PEERS} `basename ${abspath}`"
    else
	AC_MSG_ERROR([ wv was not found ])
    fi

fi

fi

AM_CONDITIONAL(LOCAL_WV, test "$local_wv" = "true")
AC_SUBST(WV_CFLAGS)
AC_SUBST(WV_LIBS)
AC_SUBST(WV_PEERDIR)

])

# Copyright (C) 2001 Sam Tobin-Hochstadt
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.

# The above license applies to THIS FILE ONLY, the abiword code
# itself may be copied and distributed under the terms of the GNU
# GPL, see COPYING for more details

# Check for libpng
# Supports:
#  *  libpng in system library locations
#  *  Bundled libpng if a directory name argument is passed
#
# Hacked from the abi-xml-parser.m4 code
#
# Usage: 
#  ABI_LIBPNG
# or
#  ABI_LIBPNG(libpng-dir)

AC_DEFUN([ABI_LIBPNG], [

if test "$ABI_NEED_LIBPNG" = "yes"; then

abi_found_libpng="no"

AC_ARG_WITH(libpng-prefix, [  --with-libpng-prefix=PFX   Prefix where libpng is installed (optional)], libpng_prefix="$withval", libpng_prefix="")

# check for library file using prefix
if test "x$libpng_prefix" != "x"; then
    if test -f "$libpng_prefix/lib/libpng.a"; then
           good_libpng_prefix="yes"
       else
           good_libpng_prefix="no"
    fi
fi


# check for shared install, with or without prefix
if test "$good_libpng_prefix" = "yes"; then
    saved_ldflags="$LDFLAGS"
    LDFLAGS="-L$libpng_prefix/lib"
    AC_CHECK_LIB(png, png_create_info_struct,
        abi_libpng_libs="-L$libpng_prefix/lib -lpng -lm -lz" abi_found_libpng="yes",
	abi_found_libpng="no", -lm -lz)
    LDFLAGS="$saved_ldflags"
else
    if test "$abi_found_libpng" = "no"; then
	echo "checking for libpng"
	AC_CHECK_LIB(png, png_create_info_struct,
           abi_libpng_libs="-lpng -lm -lz" abi_found_libpng="yes",
           abi_found_libpng="no", -lm -lz)
    fi
fi

# check for header file
if test "$abi_found_libpng" = "yes"; then
    if test "$good_libpng_prefix" = "yes"; then
        if test -f "$libpng_prefix/include/png.h"; then
            abi_found_libpngincs="yes"
        else
            abi_found_libpngincs="no"
        fi
	if test "$abi_found_libpngincs" = "yes"; then
            LIBPNG_LIBS="$abi_libpng_libs"
            LIBPNG_CFLAGS="-I$libpng_prefix/include"
            abi_libpng_message="libpng in $abi_libpng_libs"
	fi
    else
       AC_CHECK_HEADER(png.h,abi_found_libpngincs="yes")
       if test "$abi_found_libpngincs" = "yes"; then
           LIBPNG_LIBS="$abi_libpng_libs"
           LIBPNG_CFLAGS=""
           abi_libpng_message="libpng in $abi_libpng_libs"
       fi
    fi   
fi

# otherwise, use the sources given as an argument.  
# [ this means the peer dir for abi ]
if test "$abi_found_libpng" = "no"; then
    if test "x$1" != "x" && test -d "$1"; then
	abspath=`cd $1; pwd`
	LIBPNG_LIBS="${abspath}/libpng.a"
	LIBPNG_CFLAGS="-I${abspath}/"
	AC_MSG_RESULT(using supplied png library)	
	AC_DEFINE(HAVE_LIBPNG, 1, [ Define if you have libpng ])
	abi_libpng_message="supplied libpng in ${abspath}"
	LIBPNG_PEERDIR=${abspath}
        PEERDIRS="${PEERDIRS} ${LIBPNG_PEERDIR}"
	PEERS="${PEERS} `basename ${abspath}`"
    else
	AC_MSG_ERROR([ libpng was not found ])
    fi

fi

fi

AM_CONDITIONAL(LOCAL_LIBPNG, test "$local_libpng" = "true")
AC_SUBST(LIBPNG_CFLAGS)
AC_SUBST(LIBPNG_LIBS)
AC_SUBST(LIBPNG_PEERDIR)

])

