/* This is -*- C -*- */
/* $Id: guppi-plot-toolkit.h,v 1.1 2000/02/28 04:55:18 trow Exp $ */

/*
 * guppi-plot-toolkit.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_PLOT_TOOLKIT_H
#define _INC_GUPPI_PLOT_TOOLKIT_H

#include <config.h>
#include <gnome.h>

#include "guppi-plot-tool.h"

typedef struct _GuppiPlotToolkit GuppiPlotToolkit;
typedef struct _GuppiPlotToolkitClass GuppiPlotToolkitClass;

struct _GuppiPlotToolkit {
  GtkObject parent;

  GuppiPlotTool* button_tool[3];
  GuppiPlotTool* shift_button_tool[3];
  GuppiPlotTool* ctrl_button_tool[3];
  GuppiPlotTool* ctrl_shift_button_tool[3];
};

struct _GuppiPlotToolkitClass {
  GtkObjectClass parent_class;
};

#define GUPPI_TYPE_PLOT_TOOLKIT (guppi_plot_toolkit_get_type())
#define GUPPI_PLOT_TOOLKIT(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_PLOT_TOOLKIT,GuppiPlotToolkit))
#define GUPPI_PLOT_TOOLKIT0(obj) ((obj) ? (GUPPI_PLOT_TOOLKIT(obj)) : NULL)
#define GUPPI_PLOT_TOOLKIT_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_PLOT_TOOLKIT,GuppiPlotToolkitClass))
#define GUPPI_IS_PLOT_TOOLKIT(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_PLOT_TOOLKIT))
#define GUPPI_IS_PLOT_TOOLKIT0(obj) (((obj) == NULL) || (GUPPI_IS_PLOT_TOOLKIT(obj)))
#define GUPPI_IS_PLOT_TOOLKIT_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_PLOT_TOOLKIT))

GtkType guppi_plot_toolkit_get_type(void);

GuppiPlotToolkit* guppi_plot_toolkit_new(void);

GuppiPlotToolkit* guppi_plot_toolkit_new(void);
GuppiPlotTool* guppi_plot_toolkit_get_button_tool(GuppiPlotToolkit*,
						  guint button,
						  guint state);
void guppi_plot_toolkit_set_button_tool(GuppiPlotToolkit*,
					guint button,
					guint state,
					GuppiPlotTool*);

void guppi_plot_toolkit_optimize_events(GuppiPlotToolkit*, GtkWidget*);



#endif /* _INC_GUPPI_PLOT_TOOLKIT_H */

/* $Id: guppi-plot-toolkit.h,v 1.1 2000/02/28 04:55:18 trow Exp $ */
