/* This is -*- C -*- */
/* $Id: guppi-seq-string-core-impl.c,v 1.2 2000/04/13 19:45:19 trow Exp $ */

/*
 * guppi-seq-string-core-impl.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-seq-string-core-impl.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_seq_string_core_impl_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_seq_string_core_impl_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_seq_string_core_impl_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_seq_string_core_impl_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

/*****************************************************************************/

static const gchar*
v_seq_string_get(const GuppiSeqStringImpl* impl, gint i)
{
  const GuppiSeqStringCoreImpl* core = GUPPI_SEQ_STRING_CORE_IMPL(impl);
  gchar** data;

  data = (gchar**)guppi_garray_data(core->garray);
  i -= core->index_basis;
  return data[i];
}

static void
v_seq_string_set(GuppiSeqStringImpl* impl, gint i, gchar* str)
{
  GuppiSeqStringCoreImpl* core = GUPPI_SEQ_STRING_CORE_IMPL(impl);
  gchar** data;

  data = (gchar**)guppi_garray_data(core->garray);
  i -= core->index_basis;
  if (data[i]) g_free(data[i]);
  data[i] = str;
}

static void
v_seq_string_insert(GuppiSeqStringImpl* impl, gint i, gchar* str)
{
  GuppiSeqStringCoreImpl* core = GUPPI_SEQ_STRING_CORE_IMPL(impl);
  gchar** data;
  gint j;

  i -= core->index_basis;

  if (guppi_garray_size(core->garray) <= core->size)
    guppi_garray_set_size(core->garray, MAX(20,2*core->size));

  data = (gchar**)guppi_garray_data(core->garray);  
  for(j=core->size-1; i<=j; --j)
    data[j+1] = data[j];
  data[i] = str;
  ++core->size;
}

static void
v_seq_size_hint(GuppiSeqImpl* impl, gsize n)
{
  GuppiSeqStringCoreImpl* core = GUPPI_SEQ_STRING_CORE_IMPL(impl);

  if (guppi_garray_size(core->garray) < n)
    guppi_garray_set_size(core->garray, n);
}

static void
v_seq_get_bounds(const GuppiSeqImpl* impl, gint* min, gint* max)
{
  const GuppiSeqStringCoreImpl* core = GUPPI_SEQ_STRING_CORE_IMPL(impl);

  if (min)
    *min = core->index_basis;

  if (max) 
    *max = core->index_basis - 1 + core->size;
}

static void
v_seq_shift_indices(GuppiSeqImpl* impl, gint delta)
{
  GuppiSeqStringCoreImpl* core = GUPPI_SEQ_STRING_CORE_IMPL(impl);
  core->index_basis += delta;
}

static gboolean
v_seq_validate(const GuppiSeqImpl* impl, const gchar* str,
	       gchar* error_msg, gsize errlen)
{
  return TRUE;
}

static void
v_seq_get(const GuppiSeqImpl* impl, gint i, gchar* buf, gsize len)
{
  const gchar* str;

  str = v_seq_string_get(GUPPI_SEQ_STRING_IMPL(impl), i);
  if (str)
    strncpy(buf, str, len);
  else
    buf[0] = '\0';
}

static void
v_seq_set(GuppiSeqImpl* impl, gint i, const gchar* buf)
{
  v_seq_string_set(GUPPI_SEQ_STRING_IMPL(impl), i, g_strdup(buf));;
}

static void
v_seq_insert(GuppiSeqImpl* impl, gint i, const gchar* buf)
{
  v_seq_string_insert(GUPPI_SEQ_STRING_IMPL(impl), i, g_strdup(buf));
}

static void
v_seq_delete_many(GuppiSeqImpl* impl, gint i, gsize N)
{
  GuppiSeqStringCoreImpl* core = GUPPI_SEQ_STRING_CORE_IMPL(impl);
  gchar** data;
  gint j;

  data = (gchar**)guppi_garray_data(core->garray);
  i -= core->index_basis;

  for (j=i; j+N<core->size; ++j) {
    g_free(data[j]);
    data[j] = data[j+N];
  }

  core->size -= N;
}

static GuppiDataImpl*
v_data_copy(GuppiDataImpl* impl)
{
  GuppiSeqStringCoreImpl* core = GUPPI_SEQ_STRING_CORE_IMPL(impl);
  GuppiSeqStringCoreImpl* copy;
  gint i;
  gchar** data;
  gchar** copy_data;

  copy = GUPPI_SEQ_STRING_CORE_IMPL(gtk_type_new(GUPPI_TYPE_SEQ_STRING_CORE_IMPL));

  copy->index_basis = core->index_basis;
  copy->size = core->size;
  copy->garray = guppi_garray_new(sizeof(gchar*));
  guppi_garray_set_size(copy->garray, copy->size);

  data = (gchar**)guppi_garray_data(core->garray);
  copy_data = (gchar**)guppi_garray_data(copy->garray);
  for (i=0; i<core->size; ++i)
    copy_data[i] = g_strdup(data[i]);

  return GUPPI_DATA_IMPL(copy);
}

static gint
v_data_size_in_bytes(GuppiDataImpl* impl)
{
  GuppiSeqStringCoreImpl* core = GUPPI_SEQ_STRING_CORE_IMPL(impl);
  gint i, sum=0;
  gchar** data = (gchar**)guppi_garray_data(core->garray);

  sum += sizeof(GuppiSeqStringCoreImpl);
  sum += core->size * sizeof(gchar*);

  for (i=0; i<core->size; ++i)
    if (data[i])
      sum += 1 + strlen(data[i]);
 
 return sum;
}

/*****************************************************************************/

static void
guppi_seq_string_core_impl_class_init(GuppiSeqStringCoreImplClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;
  GuppiDataImplClass* data_class = GUPPI_DATA_IMPL_CLASS(klass);
  GuppiSeqImplClass* seq_class = GUPPI_SEQ_IMPL_CLASS(klass);
  GuppiSeqStringImplClass* seq_string_class = GUPPI_SEQ_STRING_IMPL_CLASS(klass);

  parent_class = gtk_type_class(GUPPI_TYPE_SEQ_STRING_IMPL);

  object_class->get_arg = guppi_seq_string_core_impl_get_arg;
  object_class->set_arg = guppi_seq_string_core_impl_set_arg;
  object_class->destroy = guppi_seq_string_core_impl_destroy;
  object_class->finalize = guppi_seq_string_core_impl_finalize;
  
  data_class->impl_name = _("Core String Sequence");

  seq_string_class->get = v_seq_string_get;
  seq_string_class->set = v_seq_string_set;
  seq_string_class->insert = v_seq_string_insert;

  seq_class->size_hint = v_seq_size_hint;
  seq_class->get_bounds = v_seq_get_bounds;
  seq_class->shift_indices = v_seq_shift_indices;

  seq_class->validate = v_seq_validate;
  seq_class->get = v_seq_get;
  seq_class->set = v_seq_set;
  seq_class->insert  = v_seq_insert;
  seq_class->delete_many = v_seq_delete_many;

  data_class->copy = v_data_copy;
  data_class->get_size_in_bytes = v_data_size_in_bytes;

}

static void
guppi_seq_string_core_impl_init(GuppiSeqStringCoreImpl* obj)
{
  obj->index_basis = 0;
  obj->size = 0;
  obj->garray = guppi_garray_new(sizeof(gchar*));
}

GtkType
guppi_seq_string_core_impl_get_type(void)
{
  static GtkType guppi_seq_string_core_impl_type = 0;
  if (!guppi_seq_string_core_impl_type) {
    static const GtkTypeInfo guppi_seq_string_core_impl_info = {
      "GuppiSeqStringCoreImpl",
      sizeof(GuppiSeqStringCoreImpl),
      sizeof(GuppiSeqStringCoreImplClass),
      (GtkClassInitFunc)guppi_seq_string_core_impl_class_init,
      (GtkObjectInitFunc)guppi_seq_string_core_impl_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_seq_string_core_impl_type = gtk_type_unique(GUPPI_TYPE_SEQ_STRING_IMPL, &guppi_seq_string_core_impl_info);
  }
  return guppi_seq_string_core_impl_type;
}

GtkObject*
guppi_seq_string_core_impl_new(void)
{
  return GTK_OBJECT(gtk_type_new(guppi_seq_string_core_impl_get_type()));
}



/* $Id: guppi-seq-string-core-impl.c,v 1.2 2000/04/13 19:45:19 trow Exp $ */
