/* $Id: guppi-axis-calc.h,v 1.2 2000/04/13 19:45:16 trow Exp $ */

/*
 * guppi-axis-calc.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>.

 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_AXIS_CALC_H
#define _INC_GUPPI_AXIS_CALC_H

#include <config.h>
#include <gnome.h>

#include <guppi-alpha-template.h>

typedef struct _GuppiAxisLabel GuppiAxisLabel;
struct _GuppiAxisLabel {
  double pos;
  gchar* text;

  GnomeFont* font;
  double size;
  double rot;

  GuppiAlphaTemplate* atemp;
};

#define guppi_axis_type_horizontal(x) ((x) == AXIS_NORTH || (x) == AXIS_SOUTH)
#define guppi_axis_type_vertical(x) ((x) == AXIS_WEST || (x) == AXIS_EAST)

GList* optimal_guppi_axis_numerical_labels(double pos_min, double pos_max,
					   gint goal, gint base);

void guppi_axis_label_list_free(GList*);

void guppi_axis_label_render_labels(GList* new_list, GList* old_list);

#endif /* _INC_GUPPI_AXIS-CALC_H */

/* $Id: guppi-axis-calc.h,v 1.2 2000/04/13 19:45:16 trow Exp $ */
