/* $Id: demo.c,v 1.7 2000/04/13 19:45:20 trow Exp $ */

/*
 * demo.c
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <stdlib.h>
#include <math.h>
#include <gnome.h>
#include <gdk/gdkrgb.h>
#include "guppi-alpha-template.h"
#include <libgnomeprint/gnome-font.h>

#define N 20
GnomeCanvasItem* ci[N];
double x[N];
double y[N];
gint klock=0;
gint xdir=1;

gint
update(gpointer foo)
{
  gint i;
  const double size = 5;
  for (i=0; i<N; ++i)
    gnome_canvas_item_move(ci[i],
			   xdir*size,
			   0);
  ++klock;
  if (klock == 50) {
    klock = 0;
    xdir = -xdir;
  }
    
  return 1;
}

int
main(int argc, char* argv[])
{
  GtkWidget* win;
  GtkWidget* canvas;
  GnomeFont* font;
  gpointer thing;
  GnomeFontClass* klass;
  gint i;

  GtkType gnome_canvas_hacktext_get_type(void);


  gnome_init("demo", "0.0", argc, argv);

  gtk_widget_push_visual(gdk_rgb_get_visual());
  gtk_widget_push_colormap(gdk_rgb_get_cmap());
  canvas = gnome_canvas_new_aa();
  gtk_widget_pop_colormap();
  gtk_widget_pop_visual(); 
  
  font = gnome_font_new("Helvetica", 120);
  if (font == NULL)
    g_error("font lookup failed");

  gnome_canvas_item_new(gnome_canvas_root(GNOME_CANVAS(canvas)),
			gnome_canvas_rect_get_type(),
			"x1", 30.0, 
			"y1", 30.0,
			"x2", 110.0,
			"y2", 100.0,
			"fill_color_rgba", 0xffff00ff,
			"outline_color", "black",
			"width_units", 4.0,
			NULL);

  gnome_canvas_item_new(gnome_canvas_root(GNOME_CANVAS(canvas)),
			gnome_canvas_rect_get_type(),
			"x1", -20.0, 
			"y1", 40.0,
			"x2", 120.0,
			"y2", 70.0,
			"fill_color_rgba", 0x00ffff9f,
			"outline_color", "black",
			"width_units", 4.0,
			NULL);

  thing = (gpointer)gt1_load_font(font->fontmap_entry->pfb_fn);
  for (i=0; i<N; ++i) 
    ci[i] = gnome_canvas_item_new(gnome_canvas_root(GNOME_CANVAS(canvas)),
				  gnome_canvas_hacktext_get_type(),
				  "font", thing,
				  "size", 10.0,
				  "fill_color", "red",
				  "x", x[i]=200.0*(random()/(double)RAND_MAX)-100,
				  "y", y[i]=200.0*(random()/(double)RAND_MAX)-100,
				  "text", "This Kicks Ass!",
				  NULL);


  gnome_canvas_set_scroll_region(GNOME_CANVAS(canvas),-200,-300,300,200);

  win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize(GTK_WIDGET(win), 500, 500);
  gtk_container_add(GTK_CONTAINER(win), canvas);
  gtk_widget_show_all(win);

  gtk_idle_add(update, NULL);

  gtk_main();
    
  return 0;  
}




/* $Id: demo.c,v 1.7 2000/04/13 19:45:20 trow Exp $ */

