/* $Id: guppi-bonobo.c,v 1.1 2000/05/01 04:45:35 trow Exp $ */

/*
 * guppi-bonobo.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and Ji Yu <g.yu@mail.utexas.edu>.
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <guppi-useful.h>
#include "guppi-bonobo.h"

static BonoboEmbeddableFactory* factory;
static gint guppi_object_num = 0;

#if 0
static void
guppi_bonobo_destroy(BonoboEmbeddable* embeddable)
{
  g_assert(guppi_object_num > 0);
  
  /* Destroy the factory if there are no more instances */
  if ((--guppi_object_num) <= 0)
    if (factory) {
      bonobo_object_unref(BONOBO_OBJECT (factory));
      factory = NULL;
      guppi_exit();
    }   
}


static BonoboObject*
guppi_bonobo_factory(BonoboEmbeddableFactory* f, gpointer data)
{
  GuppiObject* obj;

  obj = guppi_object_construct(f, data);

  g_return_val_if_fail(obj != NULL, NULL);
  g_return_val_if_fail(obj->bonobo_embeddable != NULL, NULL);

  guppi_object_num++;

  /* Install destructor */
  gtk_signal_connect(GTK_OBJECT(obj->bonobo_embeddable), 
		     "destroy",
		     GTK_SIGNAL_FUNC(guppi_bonobo_destroy),
		     obj);

  return BONOBO_OBJECT(obj->bonobo_embeddable);
}
#endif

void
guppi_bonobo_init(void)
{
  if (!bonobo_init(CORBA_OBJECT_NIL, CORBA_OBJECT_NIL, CORBA_OBJECT_NIL)) 
    g_error(_("Couldn't initialize Bonobo"));

#if 0
  factory = bonobo_embeddable_factor_new("bonobo-object-factory:guppi",
					 guppi_bonobo_factory, NULL);
#endif
}




/* $Id: guppi-bonobo.c,v 1.1 2000/05/01 04:45:35 trow Exp $ */
