/* This is -*- C -*- */
/* $Id: guppi-scatter-style.h,v 1.2 2000/04/13 19:45:17 trow Exp $ */

/*
 * guppi-scatter-style.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SCATTER_STYLE_H
#define _INC_GUPPI_SCATTER_STYLE_H

#include <config.h>
#include <gnome.h>
#include "transform.h"
#include <guppi-seq-scalar.h>
#include <guppi-seq-boolean.h>
#include <guppi-alpha-template.h>

typedef enum _GuppiScatterMarker GuppiScatterMarker;
typedef struct _GuppiScatterMarkerInfo GuppiScatterMarkerInfo;

enum _GuppiScatterMarker {
  SCATTER_MARKER_NONE,
  SCATTER_MARKER_CIRCLE,
  SCATTER_MARKER_DIAMOND,
  SCATTER_MARKER_CROSS,
  SCATTER_MARKER_X,
  SCATTER_MARKER_SQUARE,
  SCATTER_MARKER_AST,
  SCATTER_MARKER_PIXEL,
  SCATTER_MARKER_DOT,
  SCATTER_MARKER_FILLED_CIRCLE,
  SCATTER_MARKER_FILLED_SQUARE,
  SCATTER_MARKER_FILLED_DIAMOND,
  SCATTER_MARKER_ALPHA_TEMPLATE,
  SCATTER_MARKER_LAST_MARKER
};

/* This information can be used to automate the construction of
   configuration dialogs, etc. */
struct _GuppiScatterMarkerInfo {
  GuppiScatterMarker marker;

  const gchar* name;
  const gchar* size1_desc;
  gdouble size1_min, size1_max, size1_default;
  const gchar* size2_desc;
  gdouble size2_min, size2_max, size2_default;
};

const GuppiScatterMarkerInfo guppi_scatter_marker_info[SCATTER_MARKER_LAST_MARKER];

GuppiScatterMarker string2scatter_marker(const gchar* s);

GuppiAlphaTemplate* guppi_scatter_marker_make_alpha_template(GuppiScatterMarker m,
							double sz1, double sz2,
							double scale_factor);

//////////////////////////////////////////////////////////////////////////////

typedef struct _GuppiScatterStyle GuppiScatterStyle;
typedef struct _GuppiScatterStyleClass GuppiScatterStyleClass;

struct _GuppiScatterStyle {
  GtkObject parent;

  GuppiScatterMarker marker;
  gdouble size1, size2;
  GuppiAlphaTemplate* alpha_template;
  guint32 color;

  const GuppiSeqScalar* gradient_data;
  gboolean reverse_color_gradient;
  guint32 color_low; /* "color" is used as the top of the color gradient */

  const GuppiSeqScalar* size1_data;
  gboolean reverse_size1_gradient;
  gdouble size1_high;

  const GuppiSeqScalar* size2_data;
  gboolean reverse_size2_gradient;
  gdouble size2_high;

  gboolean freeze_count;
  gboolean pending_change;

  /* Cache for recently used templates */
  GuppiAlphaTemplate* last_alpha_template;
  double last_scale;
};

struct _GuppiScatterStyleClass {
  GtkObjectClass parent_class;

  void (*changed)();
};

#define GUPPI_TYPE_SCATTER_STYLE (guppi_scatter_style_get_type())
#define GUPPI_SCATTER_STYLE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SCATTER_STYLE,GuppiScatterStyle))
#define GUPPI_SCATTER_STYLE_CLASS(klass) (GTK_CHECK_CLASS_CAST((obj),GUPPI_TYPE_SCATTER_STYLE,GuppiScatterStyleClass))
#define GUPPI_IS_SCATTER_STYLE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SCATTER_STYLE))
#define GUPPI_IS_SCATTER_STYLE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SCATTER_STYLE))

GtkType guppi_scatter_style_get_type(void);

GuppiScatterStyle* guppi_scatter_style_new(void);
GuppiScatterStyle* guppi_scatter_style_new_stock(gint i);

void guppi_scatter_style_freeze(GuppiScatterStyle*);
void guppi_scatter_style_thaw(GuppiScatterStyle*);

GuppiScatterMarker guppi_scatter_style_marker(const GuppiScatterStyle*);
void guppi_scatter_style_set_marker(GuppiScatterStyle*, GuppiScatterMarker);

void guppi_scatter_style_set_marker_size1(GuppiScatterStyle*, double);
void guppi_scatter_style_set_marker_size2(GuppiScatterStyle*, double);
void guppi_scatter_style_set_marker_sizes(GuppiScatterStyle*, double, double);
void guppi_scatter_style_set_marker_sizes_default(GuppiScatterStyle*);
void guppi_scatter_style_set_alpha_template(GuppiScatterStyle*,
					    GuppiAlphaTemplate*);
void guppi_scatter_style_set_color(GuppiScatterStyle*, guint32);
void guppi_scatter_style_set_gradient_data(GuppiScatterStyle*, GuppiSeqScalar*);
void guppi_scatter_style_set_color_low(GuppiScatterStyle*, guint32);

gboolean guppi_scatter_style_reverse_color_gradient(const GuppiScatterStyle*);
void guppi_scatter_style_set_reverse_color_gradient(GuppiScatterStyle*,
						    gboolean);

void guppi_scatter_style_set_size1_data(GuppiScatterStyle*, GuppiSeqScalar*);
void guppi_scatter_style_set_size1_high(GuppiScatterStyle*, double);

gboolean guppi_scatter_style_reverse_size1_gradient(const GuppiScatterStyle*);
void guppi_scatter_style_set_reverse_size1_gradient(GuppiScatterStyle*,
						    gboolean);


void guppi_scatter_style_set_size2_data(GuppiScatterStyle*, GuppiSeqScalar*);
void guppi_scatter_style_set_size2_high(GuppiScatterStyle*, double);

gboolean guppi_scatter_style_reverse_size2_gradient(const GuppiScatterStyle*);
void guppi_scatter_style_set_reverse_size2_gradient(GuppiScatterStyle*,
						    gboolean);


void guppi_scatter_style_paint(GuppiScatterStyle*,
			       guchar* rgb_buffer, gint row_stride,
			       gint w, gint h, gint adj_x, gint adj_y,
			       const Transform* x_transform,
			       const Transform* y_transform,
			       const GuppiSeqScalar* x_data,
			       const GuppiSeqScalar* y_data,
			       const GuppiSeqBoolean* mask,
			       double scale_factor);



#endif /* _INC_GUPPI_SCATTER_STYLE_H */

/* $Id: guppi-scatter-style.h,v 1.2 2000/04/13 19:45:17 trow Exp $ */
