/* This is -*- C -*- */
/* $Id: guppi-item-state.c,v 1.4 2000/03/09 02:57:24 trow Exp $ */

/*
 * guppi-item-state.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-item-state.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

enum {
  CHANGED,
  RESET_X_DATA,
  RESET_Y_DATA,
  CHANGED_X_DATA,
  CHANGED_Y_DATA,
  LAST_SIGNAL
};

static guint gis_signals[LAST_SIGNAL] = { 0 };

static void
guppi_item_state_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_item_state_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_item_state_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_item_state_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_item_state_class_init(GuppiItemStateClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GTK_TYPE_OBJECT);

  object_class->get_arg = guppi_item_state_get_arg;
  object_class->set_arg = guppi_item_state_set_arg;
  object_class->destroy = guppi_item_state_destroy;
  object_class->finalize = guppi_item_state_finalize;

  gis_signals[CHANGED] =
    gtk_signal_new("changed",
		   GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GuppiItemStateClass, changed),
		   gtk_marshal_NONE__NONE,
		   GTK_TYPE_NONE, 0);

  gis_signals[RESET_X_DATA] = 
    gtk_signal_new("reset_x_data",
		   GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GuppiItemStateClass, reset_x_data),
		   gtk_marshal_NONE__NONE,
		   GTK_TYPE_NONE, 0);

  gis_signals[RESET_Y_DATA] = 
    gtk_signal_new("reset_y_data",
		   GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GuppiItemStateClass, reset_y_data),
		   gtk_marshal_NONE__NONE,
		   GTK_TYPE_NONE, 0);

  gis_signals[CHANGED_X_DATA] = 
    gtk_signal_new("changed_x_data",
		   GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GuppiItemStateClass, changed_x_data),
		   gtk_marshal_NONE__NONE,
		   GTK_TYPE_NONE, 0);

  gis_signals[CHANGED_Y_DATA] = 
    gtk_signal_new("changed_y_data",
		   GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GuppiItemStateClass, changed_y_data),
		   gtk_marshal_NONE__NONE,
		   GTK_TYPE_NONE, 0);

  gtk_object_class_add_signals(object_class, gis_signals, LAST_SIGNAL);
}

static void
guppi_item_state_init(GuppiItemState* obj)
{
  obj->freeze_count = 0;
}

GtkType
guppi_item_state_get_type(void)
{
  static GtkType guppi_item_state_type = 0;
  if (!guppi_item_state_type) {
    static const GtkTypeInfo guppi_item_state_info = {
      "GuppiItemState",
      sizeof(GuppiItemState),
      sizeof(GuppiItemStateClass),
      (GtkClassInitFunc)guppi_item_state_class_init,
      (GtkObjectInitFunc)guppi_item_state_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_item_state_type = gtk_type_unique(GTK_TYPE_OBJECT, &guppi_item_state_info);
  }
  return guppi_item_state_type;
}

GuppiItemState*
guppi_item_state_new(void)
{
  return GUPPI_ITEM_STATE(gtk_type_new(guppi_item_state_get_type()));
}

void
guppi_item_state_freeze(GuppiItemState* gis)
{
  g_return_if_fail(gis != NULL);
  g_assert(gis->freeze_count >= 0);
  ++gis->freeze_count;
}

void
guppi_item_state_thaw(GuppiItemState* gis)
{
  g_return_if_fail(gis != NULL);
  g_return_if_fail(gis->freeze_count > 0);
 
 --gis->freeze_count;
  
  if (gis->freeze_count == 0) {

    if (gis->pending_reset_x_data)
      gtk_signal_emit(GTK_OBJECT(gis), gis_signals[RESET_X_DATA]);

    if (gis->pending_reset_y_data)
      gtk_signal_emit(GTK_OBJECT(gis), gis_signals[RESET_Y_DATA]);

    if (gis->pending_changed_x_data)
      gtk_signal_emit(GTK_OBJECT(gis), gis_signals[CHANGED_X_DATA]);

    if (gis->pending_changed_y_data)
      gtk_signal_emit(GTK_OBJECT(gis), gis_signals[CHANGED_Y_DATA]);

    if (gis->pending_changed)
      gtk_signal_emit(GTK_OBJECT(gis), gis_signals[CHANGED]);

    gis->pending_changed = FALSE;
    gis->pending_reset_x_data = FALSE;
    gis->pending_reset_y_data = FALSE;
    gis->pending_changed_x_data = FALSE;
    gis->pending_changed_y_data = FALSE;
  }
}

void
guppi_item_state_changed(GuppiItemState* gis)
{
  g_return_if_fail(gis != NULL);
  if (gis->freeze_count == 0)
    gtk_signal_emit(GTK_OBJECT(gis), gis_signals[CHANGED]);
  else
    gis->pending_changed = TRUE;
}

/****************************************************************************/

/*
  Convert GuppiData "changed" signals into GuppiItemState "changed_*_data"
  signals.
*/

static void
convert_x_change_signals(GuppiData* data, GuppiItemState* state)
{
  if (state->freeze_count == 0)
    gtk_signal_emit(GTK_OBJECT(state), gis_signals[CHANGED_X_DATA]);
  else
    state->pending_changed_x_data = TRUE;
}

static void
convert_y_change_signals(GuppiData* data, GuppiItemState* state)
{
  if (state->freeze_count == 0)
    gtk_signal_emit(GTK_OBJECT(state), gis_signals[CHANGED_Y_DATA]);
  else
    state->pending_changed_y_data = TRUE;
}

void
guppi_item_state_set_x_data(GuppiItemState* gis, GuppiData* data)
{
  gboolean (*fn_set)(GuppiItemState*, GuppiData*);
  GuppiData* (*fn_get)(GuppiItemState*);
  GuppiData* old_data = NULL;

  g_return_if_fail(gis != NULL);

  fn_set = GUPPI_ITEM_STATE_CLASS(GTK_OBJECT(gis)->klass)->set_x_data;
  fn_get = GUPPI_ITEM_STATE_CLASS(GTK_OBJECT(gis)->klass)->get_x_data;

  if (fn_get) {
    old_data = fn_get(gis);
    if (old_data)
      gtk_object_ref(GTK_OBJECT(old_data));
  }

  if (fn_set != NULL && fn_set(gis, data)) {

    if (old_data)
      gtk_signal_disconnect_by_func(GTK_OBJECT(old_data),
				    GTK_SIGNAL_FUNC(convert_x_change_signals),
				    gis);

    if (data) 
      gtk_signal_connect(GTK_OBJECT(data),
			 "changed",
			 GTK_SIGNAL_FUNC(convert_x_change_signals),
			 gis);

    if (gis->freeze_count == 0) {
      gtk_signal_emit(GTK_OBJECT(gis), gis_signals[RESET_X_DATA]);
    } else {
      gis->pending_changed_x_data = FALSE;
      gis->pending_reset_x_data = TRUE;
    }
  }
  
  if (old_data)
    gtk_object_unref(GTK_OBJECT(old_data));

}
	       
void
guppi_item_state_set_y_data(GuppiItemState* gis, GuppiData* data)
{
  gboolean (*fn_set)(GuppiItemState*, GuppiData*);
  GuppiData* (*fn_get)(GuppiItemState*);
  GuppiData* old_data = NULL;

  g_return_if_fail(gis != NULL);

  fn_set = GUPPI_ITEM_STATE_CLASS(GTK_OBJECT(gis)->klass)->set_y_data;
  fn_get = GUPPI_ITEM_STATE_CLASS(GTK_OBJECT(gis)->klass)->get_y_data;

  if (fn_get) {
    old_data = fn_get(gis);
    if (old_data)
      gtk_object_ref(GTK_OBJECT(old_data));
  }

  if (fn_set != NULL && fn_set(gis, data)) {

    if (old_data)
      gtk_signal_disconnect_by_func(GTK_OBJECT(old_data),
				    GTK_SIGNAL_FUNC(convert_y_change_signals),
				    gis);

    if (data) 
      gtk_signal_connect(GTK_OBJECT(data),
			 "changed",
			 GTK_SIGNAL_FUNC(convert_y_change_signals),
			 gis);

    if (gis->freeze_count == 0) {
      gtk_signal_emit(GTK_OBJECT(gis), gis_signals[RESET_Y_DATA]);
    } else {
      gis->pending_changed_y_data = FALSE;
      gis->pending_reset_y_data = TRUE;
    }
  }

  if (old_data)
    gtk_object_unref(GTK_OBJECT(old_data));

}

/*****************************************************************************/

static void
reset_x_cb(GuppiItemState* state1, GuppiItemState* state2)
{
  GuppiData* (*fn_get)(GuppiItemState*);
  GuppiData* data = NULL;

  fn_get = GUPPI_ITEM_STATE_CLASS(GTK_OBJECT(state1)->klass)->get_x_data;
  if (fn_get) data = fn_get(state1);
  
  guppi_item_state_set_x_data(state2, data);
}

static void
reset_y_cb(GuppiItemState* state1, GuppiItemState* state2)
{
  GuppiData* (*fn_get)(GuppiItemState*);
  GuppiData* data = NULL;

  fn_get = GUPPI_ITEM_STATE_CLASS(GTK_OBJECT(state1)->klass)->get_y_data;
  if (fn_get) data = fn_get(state1);

  guppi_item_state_set_y_data(state2, data);
}

void
guppi_item_state_connect_x_data(GuppiItemState* a, GuppiItemState* b)
{
  g_return_if_fail(a != NULL);
  g_return_if_fail(b != NULL);

  gtk_signal_connect(GTK_OBJECT(a),
		     "reset_x_data",
		     GTK_SIGNAL_FUNC(reset_x_cb),
		     b);

  gtk_signal_connect(GTK_OBJECT(b),
		     "reset_x_data",
		     GTK_SIGNAL_FUNC(reset_x_cb),
		     a);
}

void
guppi_item_state_connect_y_data(GuppiItemState* a, GuppiItemState* b)
{
  g_return_if_fail(a != NULL);
  g_return_if_fail(b != NULL);

  gtk_signal_connect(GTK_OBJECT(a),
		     "reset_y_data",
		     GTK_SIGNAL_FUNC(reset_y_cb),
		     b);

  gtk_signal_connect(GTK_OBJECT(b),
		     "reset_y_data",
		     GTK_SIGNAL_FUNC(reset_y_cb),
		     a);
}


/* $Id: guppi-item-state.c,v 1.4 2000/03/09 02:57:24 trow Exp $ */
