/* This is -*- C -*- */
/* $Id: guppi-data-importer.c,v 1.3 2000/02/16 22:50:07 trow Exp $ */

/*
 * guppi-data-importer.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-data-importer-plug-in.h"
#include "guppi-data-importer.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_data_importer_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_data_importer_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_data_importer_destroy(GtkObject* obj)
{
  GuppiDataImporter* imp = GUPPI_DATA_IMPORTER(obj);

  if (parent_class->destroy)
    parent_class->destroy(obj);

  if (imp->file) {
    gtk_object_unref(GTK_OBJECT(imp->file));
    imp->file = NULL;
  }
  if (imp->str) {
    gtk_object_unref(GTK_OBJECT(imp->str));
    imp->str = NULL;
  }
}

static void
guppi_data_importer_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_data_importer_class_init(GuppiDataImporterClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GTK_TYPE_OBJECT);

  object_class->get_arg = guppi_data_importer_get_arg;
  object_class->set_arg = guppi_data_importer_set_arg;
  object_class->destroy = guppi_data_importer_destroy;
  object_class->finalize = guppi_data_importer_finalize;

}

static void
guppi_data_importer_init(GuppiDataImporter* obj)
{

}

GtkType
guppi_data_importer_get_type(void)
{
  static GtkType guppi_data_importer_type = 0;
  if (!guppi_data_importer_type) {
    static const GtkTypeInfo guppi_data_importer_info = {
      "GuppiDataImporter",
      sizeof(GuppiDataImporter),
      sizeof(GuppiDataImporterClass),
      (GtkClassInitFunc)guppi_data_importer_class_init,
      (GtkObjectInitFunc)guppi_data_importer_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_data_importer_type = gtk_type_unique(GTK_TYPE_OBJECT, &guppi_data_importer_info);
  }
  return guppi_data_importer_type;
}

GuppiDataImporter*
guppi_data_importer_new(const gchar* name)
{
  GuppiPlugIn* plug_in;
  GuppiDataImporterPlugIn* dipi;
  GuppiDataImporter* gdi;

  g_return_val_if_fail(name != NULL, NULL);

  plug_in = guppi_plug_in_lookup("data_import", name);
  if (plug_in == NULL) {
    g_warning("Unknown data-import plug-in: \"%s\"", name);
    return NULL;
  }

  g_return_val_if_fail(GUPPI_IS_DATA_IMPORTER_PLUG_IN(plug_in), NULL);
  dipi = GUPPI_DATA_IMPORTER_PLUG_IN(plug_in);

  g_return_val_if_fail(dipi->construct != NULL, NULL);
  gdi = (dipi->construct)();

  return gdi;
}

const gchar*
guppi_data_importer_get_name(GuppiDataImporter* imp)
{
  GuppiDataImporterClass* klass;
  g_return_val_if_fail(imp != NULL, NULL);
  klass = GUPPI_DATA_IMPORTER_CLASS(GTK_OBJECT(imp)->klass);
  return klass->name ? klass->name : _("unnamed");
}

void
guppi_data_importer_set_source(GuppiDataImporter* imp, GuppiFile* f)
{
  GuppiDataImporterClass* klass;

  g_return_if_fail(imp != NULL);
  g_return_if_fail(f != NULL);
  g_return_if_fail(imp->file == NULL && imp->str == NULL);

  imp->file = f;
  gtk_object_ref(GTK_OBJECT(imp->file));

  klass = GUPPI_DATA_IMPORTER_CLASS(GTK_OBJECT(imp)->klass);
  if (klass->set_source_hook)
    (klass->set_source_hook)(imp);
}

GuppiFile*
guppi_data_importer_file(GuppiDataImporter* imp)
{
  g_return_val_if_fail(imp != NULL, NULL);

  return imp->file;
}

GuppiStream*
guppi_data_importer_stream(GuppiDataImporter* imp)
{
  g_return_val_if_fail(imp != NULL, NULL);

  if (imp->str == NULL) {
    g_return_val_if_fail(imp->file != NULL, NULL);
    imp->str = guppi_stream_new(imp->file);
    gtk_object_unref(GTK_OBJECT(imp->file));
    imp->file = NULL;
  }
  return imp->str;
}

GuppiData**
guppi_data_importer_import(GuppiDataImporter* imp)
{
  GuppiDataImporterClass* klass;
  g_return_val_if_fail(imp != NULL, NULL);

  klass = GUPPI_DATA_IMPORTER_CLASS(GTK_OBJECT(imp)->klass);
  g_return_val_if_fail(klass->import != NULL, NULL);

  return (klass->import)(imp);
}

/* $Id: guppi-data-importer.c,v 1.3 2000/02/16 22:50:07 trow Exp $ */
