/* $Id: plug-ins.c,v 1.1 2000/02/11 19:47:49 trow Exp $ */

/*
 * plug-ins.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <guppi-useful.h>
#include "plug-ins.h"

static void
add_plug_in(GuppiPlugIn* pi, gpointer data)
{
  gchar* text[3];
  GtkCList* clist = GTK_CLIST(data);
  
  text[0] = (gchar*)pi->type;
  text[1] = (gchar*)pi->external_name;
  /* This is a memory leak. */
  text[2] = g_strdup_printf("%d.%d.%d",
			    pi->major_version,
			    pi->minor_version,
			    pi->micro_version);
  gtk_clist_append(clist, text);
}

void
loaded_plug_ins(void)
{
  GtkWidget* dialog;
  GtkWidget* clist;
  GtkWidget* swin;
  gchar* clist_titles[] = { "Type", "Name", "Version" };

  dialog = gnome_dialog_new(_("Loaded Plug-Ins"),
			    GNOME_STOCK_BUTTON_OK,
			    NULL);
  gnome_dialog_set_close(GNOME_DIALOG(dialog), TRUE);

  clist = gtk_clist_new_with_titles(3, clist_titles);
  gtk_clist_set_column_auto_resize(GTK_CLIST(clist), 0, TRUE);
  gtk_clist_set_column_auto_resize(GTK_CLIST(clist), 1, TRUE);
  gtk_clist_set_column_auto_resize(GTK_CLIST(clist), 2, TRUE);
  guppi_plug_in_foreach(add_plug_in, clist);

  swin = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
				 GTK_POLICY_NEVER,
				 GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(swin, 300, 100);

  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(swin), clist);

  gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), swin, TRUE, TRUE, 0);

  gtk_widget_show_all(dialog);
}


/* $Id: plug-ins.c,v 1.1 2000/02/11 19:47:49 trow Exp $ */
