/* This is -*- C -*- */
/* $Id: guppi-scatter-element.c,v 1.6 2000/03/09 22:59:46 trow Exp $ */

/*
 * guppi-scatter-element.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-scatter-element.h"
#include <guppi-scatter-state-control.h>
#include <guppi-scatter-item.h>
#include "guppi-scatter-tools.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_scatter_element_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_scatter_element_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_scatter_element_destroy(GtkObject* obj)
{
  GuppiScatterElement* gse = GUPPI_SCATTER_ELEMENT(obj);

  if (parent_class->destroy)
    parent_class->destroy(obj);

  gtk_object_unref(GTK_OBJECT(gse->state));
  gse->state = NULL;
  
}

static void
guppi_scatter_element_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static GuppiCanvasItem*
gse_make_canvas_item(GuppiPlotElement* gpe, GnomeCanvas* canv,
		     double x1, double y1, double x2, double y2)
{
  GnomeCanvasItem* ci;
  GuppiScatterElement* gse = GUPPI_SCATTER_ELEMENT(gpe);

  g_return_val_if_fail(gse != NULL, NULL);
  g_return_val_if_fail(canv != NULL, NULL);
  g_return_val_if_fail(gse->state != NULL, NULL);

  ci = gnome_canvas_item_new(gnome_canvas_root(canv),
			     guppi_scatter_item_get_type(),
			     "x1", x1, "y1", y1,
			     "x2", x2, "y2", y2,
			     "state", gse->state,
			     NULL);

  return GUPPI_CANVAS_ITEM(ci);
}

static GtkWidget*
gse_make_state_widget(GuppiPlotElement* gpe)
{
  GuppiScatterElement* gse = GUPPI_SCATTER_ELEMENT(gpe);

  g_return_val_if_fail(gse != NULL, NULL);
  g_return_val_if_fail(gse->state != NULL, NULL);

  return guppi_scatter_state_control_new(gse->state);
}

static void
guppi_scatter_element_class_init(GuppiScatterElementClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;
  GuppiPlotElementClass* pe_klass = GUPPI_PLOT_ELEMENT_CLASS(klass);
  gint i;

  parent_class = gtk_type_class(GUPPI_TYPE_PLOT_ELEMENT);

  pe_klass->type_name = _("scatter plot");
  pe_klass->make_canvas_item = gse_make_canvas_item;
  pe_klass->make_state_widget = gse_make_state_widget;

  object_class->get_arg = guppi_scatter_element_get_arg;
  object_class->set_arg = guppi_scatter_element_set_arg;
  object_class->destroy = guppi_scatter_element_destroy;
  object_class->finalize = guppi_scatter_element_finalize;

  guppi_plot_toolkit_set_button_tool(&pe_klass->default_toolkit,
				     2, GDK_SHIFT_MASK,
				     guppi_scatter_tool_frame_brush(0));

  for (i=1; i<=3; ++i) 
    guppi_plot_toolkit_set_button_tool(&pe_klass->default_toolkit,
				       i, GDK_CONTROL_MASK,
				       guppi_scatter_tool_radius_brush(i,10*i));

  guppi_plot_toolkit_set_button_tool(&pe_klass->default_toolkit,
				     1, GDK_SHIFT_MASK | GDK_CONTROL_MASK,
				     guppi_scatter_tool_home_view());

  guppi_plot_toolkit_set_button_tool(&pe_klass->default_toolkit,
				     2, GDK_SHIFT_MASK | GDK_CONTROL_MASK,
				     guppi_scatter_tool_drag_point());
}

static void
guppi_scatter_element_init(GuppiScatterElement* obj)
{
  obj->state = GUPPI_SCATTER_STATE(guppi_scatter_state_new());
}

GtkType
guppi_scatter_element_get_type(void)
{
  static GtkType guppi_scatter_element_type = 0;
  if (!guppi_scatter_element_type) {
    static const GtkTypeInfo guppi_scatter_element_info = {
      "GuppiScatterElement",
      sizeof(GuppiScatterElement),
      sizeof(GuppiScatterElementClass),
      (GtkClassInitFunc)guppi_scatter_element_class_init,
      (GtkObjectInitFunc)guppi_scatter_element_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_scatter_element_type = gtk_type_unique(GUPPI_TYPE_PLOT_ELEMENT, &guppi_scatter_element_info);
  }
  return guppi_scatter_element_type;
}

GuppiPlotElement*
guppi_scatter_element_new(void)
{
  return GUPPI_PLOT_ELEMENT(gtk_type_new(guppi_scatter_element_get_type()));
}

GuppiPlotElement*
guppi_scatter_element_new_with_state(GuppiScatterState* s)
{
  GuppiPlotElement* e = guppi_scatter_element_new();
  gtk_object_unref(GTK_OBJECT(GUPPI_SCATTER_ELEMENT(e)->state));
  gtk_object_ref(GTK_OBJECT(s));
  GUPPI_SCATTER_ELEMENT(e)->state = s;

  /* CRAP
  gtk_signal_connect_object(GTK_OBJECT(s),
			    "changed",
			    GTK_SIGNAL_FUNC(guppi_plot_element_request_update),
			    GTK_OBJECT(e));
  */

  return e;
}



/* $Id: guppi-scatter-element.c,v 1.6 2000/03/09 22:59:46 trow Exp $ */
