/* This is -*- C -*- */
/* $Id: guppi-seq-date-impl.h,v 1.1 2000/02/21 18:32:54 trow Exp $ */

/*
 * guppi-seq-date-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SEQ_DATE_IMPL_H
#define _INC_GUPPI_SEQ_DATE_IMPL_H

#include <config.h>
#include <gnome.h>

#include "guppi-seq-impl.h"

typedef struct _GuppiSeqDateImpl GuppiSeqDateImpl;
typedef struct _GuppiSeqDateImplClass GuppiSeqDateImplClass;

struct _GuppiSeqDateImpl {
  GuppiSeqImpl parent;
};

struct _GuppiSeqDateImplClass {
  GuppiSeqImplClass parent_class;

  /* virtual functions */
  const GDate* (*get)(const GuppiSeqDateImpl*, gint);
  void (*set)(GuppiSeqDateImpl*, gint, const GDate*);
  void (*insert)(GuppiSeqDateImpl*, gint, const GDate*);

  const GDate* (*min)(const GuppiSeqDateImpl*);
  const GDate* (*max)(const GuppiSeqDateImpl*);
};

#define GUPPI_TYPE_SEQ_DATE_IMPL (guppi_seq_date_impl_get_type())
#define GUPPI_SEQ_DATE_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SEQ_DATE_IMPL,GuppiSeqDateImpl))
#define GUPPI_SEQ_DATE_IMPL0(obj) ((obj) ? (GUPPI_SEQ_DATE_IMPL(obj)) : NULL)
#define GUPPI_SEQ_DATE_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SEQ_DATE_IMPL,GuppiSeqDateImplClass))
#define GUPPI_IS_SEQ_DATE_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SEQ_DATE_IMPL))
#define GUPPI_IS_SEQ_DATE_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_SEQ_DATE_IMPL(obj)))
#define GUPPI_IS_SEQ_DATE_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SEQ_DATE_IMPL))

GtkType guppi_seq_date_impl_get_type(void);

GtkObject* guppi_seq_date_impl_new(void);



#endif /* _INC_GUPPI_SEQ_DATE_IMPL_H */

/* $Id: guppi-seq-date-impl.h,v 1.1 2000/02/21 18:32:54 trow Exp $ */
