/* This is -*- C -*- */
/* $Id: guppi-array-impl.h,v 1.1 2000/02/09 21:04:56 trow Exp $ */

/*
 * guppi-array-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_ARRAY_IMPL_H
#define _INC_GUPPI_ARRAY_IMPL_H

#include <config.h>
#include <gnome.h>

#include "guppi-data-impl.h"
#include "guppi-array.h"

typedef struct _GuppiArrayImpl GuppiArrayImpl;
typedef struct _GuppiArrayImplClass GuppiArrayImplClass;

struct _GuppiArrayImpl {
  GuppiDataImpl parent;

  gint* dims;         /* pointer to int containing # of dimensions */
  gint** index_min;   /* pointer^2 to intv containing min indices, by dim */
  gint** index_sizes; /* pointer^2 to intv containing size, by dim */
  gint** strides;     /* pointer^2 to intv of strides, by dim */
  double** data;      /* pointer^2 pointing at first data elt */
};

struct _GuppiArrayImplClass {
  GuppiDataImplClass parent_class;

  /* Virtual functions/variables */
  void (*construct)(GuppiArrayImpl*, gint, const gint*, const gint*);
  void (*get_cb)(const GuppiArrayImpl*, const gint*);
  void (*set_cb)(GuppiArrayImpl*, double x, const gint*);
};

#define GUPPI_TYPE_ARRAY_IMPL (guppi_array_impl_get_type())
#define GUPPI_ARRAY_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_ARRAY_IMPL,GuppiArrayImpl))
#define GUPPI_ARRAY_IMPL0(obj) ((obj) ? (GUPPI_ARRAY_IMPL(obj)) : NULL)
#define GUPPI_ARRAY_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_ARRAY_IMPL,GuppiArrayImplClass))
#define GUPPI_IS_ARRAY_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_ARRAY_IMPL))
#define GUPPI_IS_ARRAY_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_ARRAY_IMPL(obj)))
#define GUPPI_IS_ARRAY_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_ARRAY_IMPL))

GtkType guppi_array_impl_get_type(void);

#endif /* _INC_GUPPI_ARRAY_IMPL_H */

/* $Id: guppi-array-impl.h,v 1.1 2000/02/09 21:04:56 trow Exp $ */













