/* $Id: guppi-scatter-tools.c,v 1.1 2000/02/28 05:02:38 trow Exp $ */

/*
 * guppi-scatter-tools.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>.

 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-scatter-tools.h"
#include "guppi-scatter-item.h"
#include "guppi-scatter-element.h"

static void
radius_brush_cb(GuppiPlotTool* tool, GuppiCanvasItem* gci)
{
  GuppiScatterItem* si = (GuppiScatterItem*)gci;
  guppi_scatter_state_brush_circle(si->state,
				   (gint)tool->arg1,
				   tool->x, tool->y, tool->arg2,
				   transform_plot_units_per_pixel(gci->x_transform),
				   transform_plot_units_per_pixel(gci->y_transform)
				   );
}

GuppiPlotTool*
guppi_scatter_tool_radius_brush(gint brush, double radius)
{
  GuppiPlotTool* tool;

  g_return_val_if_fail(brush >= 0, NULL);
  g_return_val_if_fail(radius > 0, NULL);

  tool = guppi_plot_tool_new();
  tool->name = g_strdup(_("Brush (Radius)"));
  tool->acts_on = GUPPI_TYPE_SCATTER_ELEMENT;
  tool->cue_type = GPTPC_CIRCLE;
  tool->cue_fill_color = 0xff000030;
  tool->cue_arg = radius;

  tool->arg1 = brush;
  tool->arg2 = radius;
  tool->first = tool->middle = tool->last = radius_brush_cb;
  
  return tool;
}

static void
frame_brush_cb(GuppiPlotTool* tool, GuppiCanvasItem* gci)
{
  GuppiScatterItem* si = (GuppiScatterItem*)gci;
  guppi_scatter_state_brush_rectangle(si->state,
				      (gint)tool->arg1,
				      tool->start_x, tool->start_y,
				      tool->x, tool->y);
}

GuppiPlotTool*
guppi_scatter_tool_frame_brush(gint brush)
{
  GuppiPlotTool* tool;

  g_return_val_if_fail(brush >= 0, NULL);

  tool = guppi_plot_tool_new();
  tool->name = g_strdup(_("Brush (Rectangle)"));
  tool->acts_on = GUPPI_TYPE_SCATTER_ELEMENT;
  tool->cue_type = GPTPC_FRAME;
  tool->cue_fill_color = 0xff000030;

  tool->arg1 = brush;
  tool->last = frame_brush_cb;

  return tool;
}

static void
home_cb(GuppiPlotTool* tool, GuppiCanvasItem* gci)
{
  GuppiScatterState* state = ((GuppiScatterItem*)gci)->state;

  if (state && state->x_data)
    guppi_canvas_item_set_x_bounds(gci,
				   guppi_seq_scalar_min(state->x_data),
				   guppi_seq_scalar_max(state->x_data));

  if (state && state->y_data)
    guppi_canvas_item_set_y_bounds(gci,
				   guppi_seq_scalar_min(state->y_data),
				   guppi_seq_scalar_max(state->y_data));

}

GuppiPlotTool*
guppi_scatter_tool_home_view(void)
{
  GuppiPlotTool* tool;

  tool = guppi_plot_tool_new();
  tool->name = g_strdup(_("Home View"));
  tool->acts_on = GUPPI_TYPE_SCATTER_ELEMENT;
  tool->first = home_cb;

  return tool;
}


/* $Id: guppi-scatter-tools.c,v 1.1 2000/02/28 05:02:38 trow Exp $ */
