# Make script for freetype 2.3.6

MOD=freetype
VER=2.3.6
THIS=$MOD-$VER

# We use a string of hex digits to make it more evident that it is
# just a hash value and not supposed to be relevant at end-user
# machines.
HEX=`echo $THIS | md5sum | cut -d' ' -f1`

# Don't let libtool do its relinking dance. Don't know how relevant
# this is, but it doesn't hurt anyway.
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <builds/unix/ltmain.sh >builds/unix/ltmain.temp && mv builds/unix/ltmain.temp builds/unix/ltmain.sh

# Do use the -export-symbols and -no-undefined libtool options.  For
# backward compatibility with the gnuwin32 build of freetype 2.1.10,
# and previous builds by tml, and with existing software that already
# link to that name, generate a DLL called freetype6.dll. To get that,
# we need to use the -avoid-version -module libtool options.
sed -e 's/# -export/-avoid-version -module -export/' -e 's/:= lib\$(PROJECT)/:=$(PROJECT)6/' <builds/unix/unix-cc.in >builds/unix/unix-cc.in.temp && mv builds/unix/unix-cc.in.temp builds/unix/unix-cc.in

# Enable the bytecode interpreter.
sed -e 's!^/\* \(#define TT_CONFIG_OPTION_BYTECODE_INTERPRETER\) \*/!\1!' <include/freetype/config/ftoption.h >include/freetype/config/ftoption.h.temp && mv include/freetype/config/ftoption.h.temp include/freetype/config/ftoption.h

# Hide ftmac.h so that apinames won't generate export symbols for the
# functions in it, which are compiled on Macs only.
mv include/freetype/ftmac.h include/freetype/ftmac.h.bak
touch include/freetype/ftmac.h

# Don't use absolute paths in freetype-config.
sed -e 's!prefix=@prefix@!prefix=`dirname $0`/..!' -e 's/@prefix@/${prefix}/' <builds/unix/freetype-config.in >builds/unix/freetype-config.in.temp && mv builds/unix/freetype-config.in.temp builds/unix/freetype-config.in

# Add many "internal" functions to the exported symbols list because
# they used to be exported, and some software like fontconfig used
# them. Drop doing this in 2008 perhaps?

# Yes, try dropping this now
if false; then
sed -e '/	  @echo TT_RunIns >> \$(EXPORTS_LIST)/ a\
	@echo FT_Alloc >> $(EXPORTS_LIST)\
	@echo FT_QAlloc >> $(EXPORTS_LIST)\
	@echo FT_Realloc >> $(EXPORTS_LIST)\
	@echo FT_QRealloc >> $(EXPORTS_LIST)\
	@echo FT_Free >> $(EXPORTS_LIST)\
	@echo FT_Stream_New >> $(EXPORTS_LIST)\
	@echo FT_Stream_Free >> $(EXPORTS_LIST)\
	@echo FT_Stream_OpenMemory >> $(EXPORTS_LIST)\
	@echo FT_Stream_Close >> $(EXPORTS_LIST)\
	@echo FT_Stream_Seek >> $(EXPORTS_LIST)\
	@echo FT_Stream_Skip >> $(EXPORTS_LIST)\
	@echo FT_Stream_Pos >> $(EXPORTS_LIST)\
	@echo FT_Stream_Read >> $(EXPORTS_LIST)\
	@echo FT_Stream_ReadAt >> $(EXPORTS_LIST)\
	@echo FT_Stream_TryRead >> $(EXPORTS_LIST)\
	@echo FT_Stream_EnterFrame >> $(EXPORTS_LIST)\
	@echo FT_Stream_ExitFrame >> $(EXPORTS_LIST)\
	@echo FT_Stream_ExtractFrame >> $(EXPORTS_LIST)\
	@echo FT_Stream_ReleaseFrame >> $(EXPORTS_LIST)\
	@echo FT_Stream_GetChar >> $(EXPORTS_LIST)\
	@echo FT_Stream_GetShort >> $(EXPORTS_LIST)\
	@echo FT_Stream_GetOffset >> $(EXPORTS_LIST)\
	@echo FT_Stream_GetLong >> $(EXPORTS_LIST)\
	@echo FT_Stream_GetShortLE >> $(EXPORTS_LIST)\
	@echo FT_Stream_GetLongLE >> $(EXPORTS_LIST)\
	@echo FT_Stream_ReadChar >> $(EXPORTS_LIST)\
	@echo FT_Stream_ReadOffset >> $(EXPORTS_LIST)\
	@echo FT_Stream_ReadLong >> $(EXPORTS_LIST)\
	@echo FT_Stream_ReadShortLE >> $(EXPORTS_LIST)\
	@echo FT_Stream_ReadLongLE >> $(EXPORTS_LIST)\
	@echo FT_Stream_ReadFields >> $(EXPORTS_LIST)\
' <builds/exports.mk >builds/exports.mk.temp && mv builds/exports.mk.temp builds/exports.mk
fi

# Don't use the $(value) function that is not present in the somewhat older GNU Make I use
sed -e 's/\$(value CFG)/$(CFG)/' <builds/unix/detect.mk >builds/unix/detect.mk.temp && mv builds/unix/detect.mk.temp builds/unix/detect.mk

usestable

# Note that even if we run the configure script with
# --prefix=/devel/target/$HEX, this does *not* mean that when
# deployed at an end-user machine, the package would have to be
# installed in such a path. With the change to freetype-config above,
# the package does not rely on any hardcoded paths.
CC='gcc -mtune=pentium3 -mthreads' LDFLAGS='-Wl,--enable-auto-image-base' CFLAGS=-O2 ./configure --prefix=c:/devel/target/$HEX --disable-static
PATH=/devel/target/$HEX/bin:.libs:$PATH make &&

# Restore ftmac.h.
mv include/freetype/ftmac.h.bak include/freetype/ftmac.h &&
make install &&

# With -module, libtool installs the dll in "lib", so move it to "bin".
mv /devel/target/$HEX/lib/freetype6.dll /devel/target/$HEX/bin &&

# Use normal name for import library.
mv /devel/target/$HEX/lib/freetype6.dll.a /devel/target/$HEX/lib/libfreetype.dll.a &&

# Generate zip archive distribution

rm -f /tmp/$MOD-$VER.zip /tmp/$MOD-dev-$VER.zip &&
(cd /devel/target/$HEX && zip /tmp/$MOD-$VER.zip bin/freetype6.dll) &&
(cd /devel/target/$HEX && zip /tmp/$MOD-dev-$VER.zip bin/freetype-config) &&
(cd /devel/target/$HEX && zip /tmp/$MOD-dev-$VER.zip lib/libfreetype.dll.a) &&
(cd /devel/target/$HEX && zip /tmp/$MOD-dev-$VER.zip lib/pkgconfig/freetype2.pc) &&
(cd /devel/target/$HEX && zip -r -D /tmp/$MOD-dev-$VER.zip include) &&
(cd /devel/target/$HEX && zip -r -D /tmp/$MOD-dev-$VER.zip share) &&
# Include *this* file in the developer zipfile for reference
(cd /devel/src/tml && zip /tmp/$MOD-dev-$VER.zip make/$THIS.sh) &&
# Include "manifest" files
manifestify /tmp/$MOD-$VER.zip /tmp/$MOD-dev-$VER.zip
