/*
 * TemplateInterface.java
 *
 * Brazil project web application toolkit,
 * export version: 2.1 
 * Copyright (c) 2001-2003 Sun Microsystems, Inc.
 *
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version 
 * 1.0 (the "License"). You may not use this file except in compliance with 
 * the License. A copy of the License is included as the file "license.terms",
 * and also available at http://www.sun.com/
 * 
 * The Original Code is from:
 *    Brazil project web application toolkit release 2.1.
 * The Initial Developer of the Original Code is: suhler.
 * Portions created by suhler are Copyright (C) Sun Microsystems, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s): suhler.
 *
 * Version:  2.2
 * Created by suhler on 01/05/11
 * Last modified by suhler on 03/08/01 16:18:50
 */

package sunlabs.brazil.template;

/**
 * Interface for templates.  Most templates are expected to extend
 * the Template class.  This interface is for those cases where
 * a template must extend something else.
 *
 * @author Stephen Uhler
 * @version %W
 */

public interface TemplateInterface {

    /**
     * Called before this template processes any tags.
     */
    public boolean init(RewriteContext hr);

    /**
     * Called after all tags have been processed, one final chance.
     */
    public boolean done(RewriteContext hr);
}
