/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.tidy.Anchor;
import org.w3c.tidy.AttVal;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.Dict;
import org.w3c.tidy.Node;
import org.w3c.tidy.Parser;
import org.w3c.tidy.ParserImpl;
import org.w3c.tidy.TagCheckImpl;

public final class TagTable {
    public static final Dict XML_TAGS = new Dict(null, Dict.VERS_ALL, 8, null, null);
    private static final Dict[] TAGS = new Dict[]{new Dict("html", Dict.VERS_ALL, 0x208002, ParserImpl.HTML, TagCheckImpl.HTML), new Dict("head", Dict.VERS_ALL, 0x208002, ParserImpl.HEAD, null), new Dict("title", Dict.VERS_ALL, 4, ParserImpl.TITLE, null), new Dict("base", Dict.VERS_ALL, 5, ParserImpl.EMPTY, null), new Dict("link", Dict.VERS_ALL, 5, ParserImpl.EMPTY, TagCheckImpl.LINK), new Dict("meta", Dict.VERS_ALL, 5, ParserImpl.EMPTY, TagCheckImpl.META), new Dict("style", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 4, ParserImpl.SCRIPT, TagCheckImpl.STYLE), new Dict("script", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 131100, ParserImpl.SCRIPT, TagCheckImpl.SCRIPT), new Dict("server", Dict.VERS_NETSCAPE, 131100, ParserImpl.SCRIPT, null), new Dict("body", Dict.VERS_ALL, 0x208002, ParserImpl.BODY, null), new Dict("frameset", Dict.VERS_FRAMESET, 8194, ParserImpl.FRAMESET, null), new Dict("p", Dict.VERS_ALL, 32776, ParserImpl.INLINE, null), new Dict("h1", Dict.VERS_ALL, 16392, ParserImpl.INLINE, null), new Dict("h2", Dict.VERS_ALL, 16392, ParserImpl.INLINE, null), new Dict("h3", Dict.VERS_ALL, 16392, ParserImpl.INLINE, null), new Dict("h4", Dict.VERS_ALL, 16392, ParserImpl.INLINE, null), new Dict("h5", Dict.VERS_ALL, 16392, ParserImpl.INLINE, null), new Dict("h6", Dict.VERS_ALL, 16392, ParserImpl.INLINE, null), new Dict("ul", Dict.VERS_ALL, 8, ParserImpl.LIST, null), new Dict("ol", Dict.VERS_ALL, 8, ParserImpl.LIST, null), new Dict("dl", Dict.VERS_ALL, 8, ParserImpl.DEFLIST, null), new Dict("dir", Dict.VERS_LOOSE, 524296, ParserImpl.LIST, null), new Dict("menu", Dict.VERS_LOOSE, 524296, ParserImpl.LIST, null), new Dict("pre", Dict.VERS_ALL, 8, ParserImpl.PRE, null), new Dict("listing", Dict.VERS_ALL, 524296, ParserImpl.PRE, null), new Dict("xmp", Dict.VERS_ALL, 524296, ParserImpl.PRE, null), new Dict("plaintext", Dict.VERS_ALL, 524296, ParserImpl.PRE, null), new Dict("address", Dict.VERS_ALL, 8, ParserImpl.BLOCK, null), new Dict("blockquote", Dict.VERS_ALL, 8, ParserImpl.BLOCK, null), new Dict("form", Dict.VERS_ALL, 8, ParserImpl.BLOCK, TagCheckImpl.FORM), new Dict("isindex", Dict.VERS_LOOSE, 9, ParserImpl.EMPTY, null), new Dict("fieldset", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 8, ParserImpl.BLOCK, null), new Dict("table", Dict.VERS_FROM32, 8, ParserImpl.TABLETAG, TagCheckImpl.TABLE), new Dict("hr", Dict.without(Dict.VERS_ALL, Dict.VERS_BASIC), 9, ParserImpl.EMPTY, TagCheckImpl.HR), new Dict("div", Dict.VERS_FROM32, 8, ParserImpl.BLOCK, null), new Dict("multicol", Dict.VERS_NETSCAPE, 8, ParserImpl.BLOCK, null), new Dict("nosave", Dict.VERS_NETSCAPE, 8, ParserImpl.BLOCK, null), new Dict("layer", Dict.VERS_NETSCAPE, 8, ParserImpl.BLOCK, null), new Dict("ilayer", Dict.VERS_NETSCAPE, 16, ParserImpl.INLINE, null), new Dict("nolayer", Dict.VERS_NETSCAPE, 131096, ParserImpl.BLOCK, null), new Dict("align", Dict.VERS_NETSCAPE, 8, ParserImpl.BLOCK, null), new Dict("center", Dict.VERS_LOOSE, 8, ParserImpl.BLOCK, null), new Dict("ins", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 131096, ParserImpl.INLINE, null), new Dict("del", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 131096, ParserImpl.INLINE, null), new Dict("li", Dict.VERS_ALL, 294944, ParserImpl.BLOCK, null), new Dict("dt", Dict.VERS_ALL, 294976, ParserImpl.INLINE, null), new Dict("dd", Dict.VERS_ALL, 294976, ParserImpl.BLOCK, null), new Dict("caption", Dict.VERS_FROM32, 128, ParserImpl.INLINE, TagCheckImpl.CAPTION), new Dict("colgroup", Dict.VERS_HTML40, 32896, ParserImpl.COLGROUP, null), new Dict("col", Dict.VERS_HTML40, 129, ParserImpl.EMPTY, null), new Dict("thead", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 33152, ParserImpl.ROWGROUP, null), new Dict("tfoot", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 33152, ParserImpl.ROWGROUP, null), new Dict("tbody", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 33152, ParserImpl.ROWGROUP, null), new Dict("tr", Dict.VERS_FROM32, 32896, ParserImpl.ROW, null), new Dict("td", Dict.VERS_FROM32, 295424, ParserImpl.BLOCK, TagCheckImpl.TABLECELL), new Dict("th", Dict.VERS_FROM32, 295424, ParserImpl.BLOCK, TagCheckImpl.TABLECELL), new Dict("q", Dict.VERS_HTML40, 16, ParserImpl.INLINE, null), new Dict("a", Dict.VERS_ALL, 16, ParserImpl.INLINE, TagCheckImpl.ANCHOR), new Dict("br", Dict.VERS_ALL, 17, ParserImpl.EMPTY, null), new Dict("img", Dict.VERS_ALL, 65553, ParserImpl.EMPTY, TagCheckImpl.IMG), new Dict("object", Dict.VERS_HTML40, 71700, ParserImpl.BLOCK, null), new Dict("applet", Dict.VERS_LOOSE, 71696, ParserImpl.BLOCK, null), new Dict("servlet", Dict.VERS_SUN, 71696, ParserImpl.BLOCK, null), new Dict("param", Dict.VERS_FROM32, 17, ParserImpl.EMPTY, null), new Dict("embed", Dict.VERS_NETSCAPE, 65553, ParserImpl.EMPTY, null), new Dict("noembed", Dict.VERS_NETSCAPE, 16, ParserImpl.INLINE, null), new Dict("iframe", Dict.VERS_HTML40_LOOSE, 16, ParserImpl.BLOCK, null), new Dict("frame", Dict.VERS_FRAMESET, 8193, ParserImpl.EMPTY, null), new Dict("noframes", Dict.VERS_IFRAME, 8200, ParserImpl.NOFRAMES, null), new Dict("noscript", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 131096, ParserImpl.BLOCK, null), new Dict("b", Dict.without(Dict.VERS_ALL, Dict.VERS_BASIC), 16, ParserImpl.INLINE, null), new Dict("i", Dict.without(Dict.VERS_ALL, Dict.VERS_BASIC), 16, ParserImpl.INLINE, null), new Dict("u", Dict.VERS_LOOSE, 16, ParserImpl.INLINE, null), new Dict("tt", Dict.without(Dict.VERS_ALL, Dict.VERS_BASIC), 16, ParserImpl.INLINE, null), new Dict("s", Dict.VERS_LOOSE, 16, ParserImpl.INLINE, null), new Dict("strike", Dict.VERS_LOOSE, 16, ParserImpl.INLINE, null), new Dict("big", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 16, ParserImpl.INLINE, null), new Dict("small", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 16, ParserImpl.INLINE, null), new Dict("sub", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 16, ParserImpl.INLINE, null), new Dict("sup", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 16, ParserImpl.INLINE, null), new Dict("em", Dict.VERS_ALL, 16, ParserImpl.INLINE, null), new Dict("strong", Dict.VERS_ALL, 16, ParserImpl.INLINE, null), new Dict("mark", Dict.VERS_ALL, 16, ParserImpl.INLINE, null), new Dict("dfn", Dict.VERS_ALL, 16, ParserImpl.INLINE, null), new Dict("code", Dict.VERS_ALL, 16, ParserImpl.INLINE, null), new Dict("samp", Dict.VERS_ALL, 16, ParserImpl.INLINE, null), new Dict("kbd", Dict.VERS_ALL, 16, ParserImpl.INLINE, null), new Dict("var", Dict.VERS_ALL, 16, ParserImpl.INLINE, null), new Dict("cite", Dict.VERS_ALL, 16, ParserImpl.INLINE, null), new Dict("abbr", Dict.VERS_HTML40, 16, ParserImpl.INLINE, null), new Dict("acronym", Dict.VERS_HTML40, 16, ParserImpl.INLINE, null), new Dict("span", Dict.VERS_FROM32, 16, ParserImpl.INLINE, null), new Dict("blink", Dict.VERS_PROPRIETARY, 16, ParserImpl.INLINE, null), new Dict("nobr", Dict.VERS_PROPRIETARY, 16, ParserImpl.INLINE, null), new Dict("wbr", Dict.VERS_PROPRIETARY, 17, ParserImpl.EMPTY, null), new Dict("marquee", Dict.VERS_MICROSOFT, 32784, ParserImpl.INLINE, null), new Dict("bgsound", Dict.VERS_MICROSOFT, 5, ParserImpl.EMPTY, null), new Dict("comment", Dict.VERS_MICROSOFT, 16, ParserImpl.INLINE, null), new Dict("spacer", Dict.VERS_NETSCAPE, 17, ParserImpl.EMPTY, null), new Dict("keygen", Dict.VERS_NETSCAPE, 17, ParserImpl.EMPTY, null), new Dict("nolayer", Dict.VERS_NETSCAPE, 131096, ParserImpl.BLOCK, null), new Dict("ilayer", Dict.VERS_NETSCAPE, 16, ParserImpl.INLINE, null), new Dict("map", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 16, ParserImpl.BLOCK, TagCheckImpl.MAP), new Dict("area", Dict.without(Dict.VERS_ALL, Dict.VERS_BASIC), 9, ParserImpl.EMPTY, TagCheckImpl.AREA), new Dict("input", Dict.VERS_ALL, 65553, ParserImpl.EMPTY, null), new Dict("select", Dict.VERS_ALL, 1040, ParserImpl.SELECT, null), new Dict("option", Dict.VERS_ALL, 33792, ParserImpl.TEXT, null), new Dict("optgroup", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 33792, ParserImpl.OPTGROUP, null), new Dict("textarea", Dict.VERS_ALL, 1040, ParserImpl.TEXT, null), new Dict("label", Dict.VERS_HTML40, 16, ParserImpl.INLINE, null), new Dict("legend", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 16, ParserImpl.INLINE, null), new Dict("button", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 16, ParserImpl.INLINE, null), new Dict("basefont", Dict.VERS_LOOSE, 17, ParserImpl.EMPTY, null), new Dict("font", Dict.VERS_LOOSE, 16, ParserImpl.INLINE, null), new Dict("bdo", Dict.without(Dict.VERS_HTML40, Dict.VERS_BASIC), 16, ParserImpl.INLINE, null), new Dict("ruby", Dict.VERS_HTML5, 16, ParserImpl.INLINE, null), new Dict("rbc", Dict.VERS_XHTML11, 16, ParserImpl.INLINE, null), new Dict("rtc", Dict.VERS_XHTML11, 16, ParserImpl.INLINE, null), new Dict("rb", Dict.VERS_HTML5, 16, ParserImpl.INLINE, null), new Dict("rt", Dict.VERS_HTML5, 16, ParserImpl.INLINE, null), new Dict("", Dict.VERS_XHTML11, 16, ParserImpl.INLINE, null), new Dict("rp", Dict.VERS_HTML5, 16, ParserImpl.INLINE, null), new Dict("article", Dict.VERS_HTML5, 8, ParserImpl.BLOCK, null), new Dict("aside", Dict.VERS_HTML5, 8, ParserImpl.BLOCK, null), new Dict("bdi", Dict.VERS_HTML5, 16, ParserImpl.INLINE, null), new Dict("details", Dict.VERS_HTML5, 8, ParserImpl.BLOCK, null), new Dict("dialog", Dict.VERS_HTML5, 8, ParserImpl.BLOCK, null), new Dict("figcaption", Dict.VERS_HTML5, 8, ParserImpl.BLOCK, null), new Dict("figure", Dict.VERS_HTML5, 8, ParserImpl.BLOCK, null), new Dict("footer", Dict.VERS_HTML5, 8, ParserImpl.BLOCK, null), new Dict("header", Dict.VERS_HTML5, 8, ParserImpl.BLOCK, null), new Dict("main", Dict.VERS_HTML5, 16, ParserImpl.INLINE, null), new Dict("menuitem", Dict.VERS_HTML5, 16, ParserImpl.INLINE, null), new Dict("meter", Dict.VERS_HTML5, 16, ParserImpl.INLINE, null), new Dict("nav", Dict.VERS_HTML5, 16, ParserImpl.INLINE, null), new Dict("progress", Dict.VERS_HTML5, 16, ParserImpl.INLINE, null), new Dict("section", Dict.VERS_HTML5, 8, ParserImpl.BLOCK, null), new Dict("summary", Dict.VERS_HTML5, 8, ParserImpl.BLOCK, null), new Dict("time", Dict.VERS_HTML5, 16, ParserImpl.INLINE, null), new Dict("wbr", Dict.VERS_XHTML11, 16, ParserImpl.INLINE, null), new Dict("datalist", Dict.VERS_XHTML11, 16, ParserImpl.INLINE, null), new Dict("output", Dict.VERS_XHTML11, 16, ParserImpl.INLINE, null), new Dict("audio", Dict.VERS_HTML5, 8, ParserImpl.BLOCK, null), new Dict("video", Dict.VERS_HTML5, 8, ParserImpl.BLOCK, null), new Dict("canvas", Dict.VERS_HTML5, 8, ParserImpl.BLOCK, null), new Dict("svg", Dict.VERS_HTML5, 8, ParserImpl.BLOCK, null), new Dict("source", Dict.VERS_HTML5, 9, ParserImpl.EMPTY, null), new Dict("track", Dict.VERS_HTML5, 8, ParserImpl.BLOCK, null), new Dict("embed", Dict.VERS_HTML5, 8, ParserImpl.BLOCK, null), new Dict("picture", Dict.VERS_HTML5, 8, ParserImpl.BLOCK, null)};
    protected Dict tagHtml;
    protected Dict tagHead;
    protected Dict tagBody;
    protected Dict tagFrameset;
    protected Dict tagFrame;
    protected Dict tagIframe;
    protected Dict tagNoframes;
    protected Dict tagMeta;
    protected Dict tagTitle;
    protected Dict tagBase;
    protected Dict tagHr;
    protected Dict tagPre;
    protected Dict tagListing;
    protected Dict tagH1;
    protected Dict tagH2;
    protected Dict tagP;
    protected Dict tagUl;
    protected Dict tagOl;
    protected Dict tagDir;
    protected Dict tagLi;
    protected Dict tagDt;
    protected Dict tagDd;
    protected Dict tagDl;
    protected Dict tagTd;
    protected Dict tagTh;
    protected Dict tagTr;
    protected Dict tagCol;
    protected Dict tagColgroup;
    protected Dict tagBr;
    protected Dict tagA;
    protected Dict tagLink;
    protected Dict tagB;
    protected Dict tagI;
    protected Dict tagStrong;
    protected Dict tagMark;
    protected Dict tagEm;
    protected Dict tagBig;
    protected Dict tagSmall;
    protected Dict tagParam;
    protected Dict tagOption;
    protected Dict tagOptgroup;
    protected Dict tagImg;
    protected Dict tagMap;
    protected Dict tagArea;
    protected Dict tagNobr;
    protected Dict tagFont;
    protected Dict tagSpacer;
    protected Dict tagLayer;
    protected Dict tagCenter;
    protected Dict tagStyle;
    protected Dict tagScript;
    protected Dict tagNoscript;
    protected Dict tagTable;
    protected Dict tagCaption;
    protected Dict tagForm;
    protected Dict tagTextarea;
    protected Dict tagBlockquote;
    protected Dict tagApplet;
    protected Dict tagObject;
    protected Dict tagDiv;
    protected Dict tagSpan;
    protected Dict tagInput;
    protected Dict tagQ;
    protected Dict tagArticle;
    protected Dict tagAside;
    protected Dict tagBdi;
    protected Dict tagDetails;
    protected Dict tagDialog;
    protected Dict tagFigcaption;
    protected Dict tagFigure;
    protected Dict tagFooter;
    protected Dict tagHeader;
    protected Dict tagMain;
    protected Dict tagMenuitem;
    protected Dict tagMeter;
    protected Dict tagNav;
    protected Dict tagProgress;
    protected Dict tagRp;
    protected Dict tagRt;
    protected Dict tagRuby;
    protected Dict tagSection;
    protected Dict tagSummary;
    protected Dict tagTime;
    protected Dict tagWbr;
    protected Dict tagDatalist;
    protected Dict tagOutput;
    protected Dict tagSvg;
    protected Dict tagCanvas;
    protected Dict tagAudio;
    protected Dict tagEmbed;
    protected Dict tagSource;
    protected Dict tagTrack;
    protected Dict tagVideo;
    protected Dict tagPicture;
    protected Dict tagBlink;
    protected Anchor anchorList;
    private Configuration configuration;
    private Map<String, Dict> tagHashtable = new HashMap<String, Dict>();

    protected TagTable() {
        for (Dict TAG : TAGS) {
            this.install(TAG);
        }
        this.tagHtml = this.lookup("html");
        this.tagHead = this.lookup("head");
        this.tagBody = this.lookup("body");
        this.tagFrameset = this.lookup("frameset");
        this.tagFrame = this.lookup("frame");
        this.tagIframe = this.lookup("iframe");
        this.tagNoframes = this.lookup("noframes");
        this.tagMeta = this.lookup("meta");
        this.tagTitle = this.lookup("title");
        this.tagBase = this.lookup("base");
        this.tagHr = this.lookup("hr");
        this.tagPre = this.lookup("pre");
        this.tagListing = this.lookup("listing");
        this.tagH1 = this.lookup("h1");
        this.tagH2 = this.lookup("h2");
        this.tagP = this.lookup("p");
        this.tagUl = this.lookup("ul");
        this.tagOl = this.lookup("ol");
        this.tagDir = this.lookup("dir");
        this.tagLi = this.lookup("li");
        this.tagDt = this.lookup("dt");
        this.tagDd = this.lookup("dd");
        this.tagDl = this.lookup("dl");
        this.tagTd = this.lookup("td");
        this.tagTh = this.lookup("th");
        this.tagTr = this.lookup("tr");
        this.tagCol = this.lookup("col");
        this.tagColgroup = this.lookup("colgroup");
        this.tagBr = this.lookup("br");
        this.tagA = this.lookup("a");
        this.tagLink = this.lookup("link");
        this.tagB = this.lookup("b");
        this.tagI = this.lookup("i");
        this.tagStrong = this.lookup("strong");
        this.tagEm = this.lookup("em");
        this.tagBig = this.lookup("big");
        this.tagSmall = this.lookup("small");
        this.tagParam = this.lookup("param");
        this.tagOption = this.lookup("option");
        this.tagOptgroup = this.lookup("optgroup");
        this.tagImg = this.lookup("img");
        this.tagMap = this.lookup("map");
        this.tagArea = this.lookup("area");
        this.tagNobr = this.lookup("nobr");
        this.tagWbr = this.lookup("wbr");
        this.tagFont = this.lookup("font");
        this.tagSpacer = this.lookup("spacer");
        this.tagLayer = this.lookup("layer");
        this.tagCenter = this.lookup("center");
        this.tagStyle = this.lookup("style");
        this.tagScript = this.lookup("script");
        this.tagNoscript = this.lookup("noscript");
        this.tagTable = this.lookup("table");
        this.tagCaption = this.lookup("caption");
        this.tagForm = this.lookup("form");
        this.tagTextarea = this.lookup("textarea");
        this.tagBlockquote = this.lookup("blockquote");
        this.tagApplet = this.lookup("applet");
        this.tagObject = this.lookup("object");
        this.tagDiv = this.lookup("div");
        this.tagSpan = this.lookup("span");
        this.tagInput = this.lookup("input");
        this.tagQ = this.lookup("q");
        this.tagBlink = this.lookup("blink");
        this.tagArticle = this.lookup("article");
        this.tagAside = this.lookup("aside");
        this.tagBdi = this.lookup("bdi");
        this.tagDetails = this.lookup("details");
        this.tagDialog = this.lookup("dialog");
        this.tagFigcaption = this.lookup("figcaption");
        this.tagFigure = this.lookup("figure");
        this.tagFooter = this.lookup("footer");
        this.tagHeader = this.lookup("header");
        this.tagMain = this.lookup("main");
        this.tagMark = this.lookup("mark");
        this.tagMenuitem = this.lookup("menuitem");
        this.tagMeter = this.lookup("meter");
        this.tagNav = this.lookup("nav");
        this.tagProgress = this.lookup("progress");
        this.tagRp = this.lookup("rp");
        this.tagRt = this.lookup("rt");
        this.tagRuby = this.lookup("ruby");
        this.tagSection = this.lookup("section");
        this.tagSummary = this.lookup("summary");
        this.tagTime = this.lookup("time");
        this.tagDatalist = this.lookup("datalist");
        this.tagOutput = this.lookup("output");
        this.tagAudio = this.lookup("audio");
        this.tagEmbed = this.lookup("embed");
        this.tagSource = this.lookup("source");
        this.tagTrack = this.lookup("track");
        this.tagVideo = this.lookup("video");
        this.tagCanvas = this.lookup("canvas");
        this.tagSvg = this.lookup("svg");
        this.tagPicture = this.lookup("picture");
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Dict lookup(String name) {
        return this.tagHashtable.get(name);
    }

    public Dict install(Dict dict) {
        Dict d = this.tagHashtable.get(dict.name);
        if (d != null) {
            d.versions = dict.versions;
            d.model |= dict.model;
            d.setParser(dict.getParser());
            d.setChkattrs(dict.getChkattrs());
            return d;
        }
        this.tagHashtable.put(dict.name, dict);
        return dict;
    }

    public boolean findTag(Node node) {
        Dict np;
        if (this.configuration != null && this.configuration.xmlTags) {
            node.tag = XML_TAGS;
            return true;
        }
        if (node.element != null && (np = this.lookup(node.element)) != null) {
            node.tag = np;
            return true;
        }
        return false;
    }

    public Parser findParser(Node node) {
        Dict np;
        if (node.element != null && (np = this.lookup(node.element)) != null) {
            return np.getParser();
        }
        return null;
    }

    boolean isAnchorElement(Node node) {
        return node.tag == this.tagA || node.tag == this.tagApplet || node.tag == this.tagForm || node.tag == this.tagFrame || node.tag == this.tagIframe || node.tag == this.tagImg || node.tag == this.tagMap;
    }

    public void defineTag(short tagType, String name) {
        Parser tagParser;
        int model;
        switch (tagType) {
            case 4: {
                model = 8;
                tagParser = ParserImpl.BLOCK;
                break;
            }
            case 1: {
                model = 1;
                tagParser = ParserImpl.BLOCK;
                break;
            }
            case 8: {
                model = 8;
                tagParser = ParserImpl.PRE;
                break;
            }
            default: {
                model = 16;
                tagParser = ParserImpl.INLINE;
            }
        }
        this.install(new Dict(name, Dict.VERS_PROPRIETARY, model, tagParser, null));
    }

    List findAllDefinedTag(short tagType) {
        ArrayList<String> tagNames = new ArrayList<String>();
        for (Dict curDictEntry : this.tagHashtable.values()) {
            if (curDictEntry == null || curDictEntry.versions != Dict.VERS_PROPRIETARY) continue;
            switch (tagType) {
                case 1: {
                    if ((curDictEntry.model & 1) != 1 || curDictEntry.equals(this.tagWbr)) break;
                    tagNames.add(curDictEntry.name);
                    break;
                }
                case 2: {
                    if ((curDictEntry.model & 0x10) != 16 || curDictEntry.equals(this.tagBlink) || curDictEntry.equals(this.tagNobr) || curDictEntry.equals(this.tagWbr)) break;
                    tagNames.add(curDictEntry.name);
                    break;
                }
                case 4: {
                    if ((curDictEntry.model & 8) != 8 || curDictEntry.getParser() != ParserImpl.BLOCK) break;
                    tagNames.add(curDictEntry.name);
                    break;
                }
                case 8: {
                    if ((curDictEntry.model & 8) != 8 || curDictEntry.getParser() != ParserImpl.PRE) break;
                    tagNames.add(curDictEntry.name);
                    break;
                }
            }
        }
        return tagNames;
    }

    public void freeAttrs(Node node) {
        while (node.attributes != null) {
            AttVal av = node.attributes;
            if ("id".equalsIgnoreCase(av.attribute) || "name".equalsIgnoreCase(av.attribute) && this.isAnchorElement(node)) {
                this.removeAnchorByNode(node);
            }
            node.attributes = av.next;
        }
    }

    void removeAnchorByNode(Node node) {
        Anchor prev = null;
        Anchor found = this.anchorList;
        while (found != null) {
            Anchor next = found.next;
            if (found.node == node) {
                if (prev != null) {
                    prev.next = next;
                } else {
                    this.anchorList = next;
                }
            } else {
                prev = found;
            }
            found = found.next;
        }
    }

    Anchor newAnchor() {
        return new Anchor();
    }

    Anchor addAnchor(String name, Node node) {
        Anchor a = this.newAnchor();
        a.name = name;
        a.node = node;
        if (this.anchorList == null) {
            this.anchorList = a;
        } else {
            Anchor here = this.anchorList;
            while (here.next != null) {
                here = here.next;
            }
            here.next = a;
        }
        return this.anchorList;
    }

    Node getNodeByAnchor(String name) {
        Anchor found = this.anchorList;
        while (found != null && !name.equalsIgnoreCase(found.name)) {
            found = found.next;
        }
        if (found != null) {
            return found.node;
        }
        return null;
    }

    void freeAnchors() {
        this.anchorList = null;
    }
}

