/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.bnd;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Constants;
import aQute.bnd.osgi.Jar;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.lang.Ops4jException;
import org.ops4j.pax.swissbox.bnd.OverwriteMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BndUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BndUtils.class);
    private static final Pattern INSTRUCTIONS_PATTERN = Pattern.compile("([a-zA-Z_0-9-]+)=([\\-!\"'()\\[\\]*+,.\\\\0-9A-Z_a-z%;:=/\\s]+)?");
    private static final Pattern CAMELCASE_PATTERN = Pattern.compile("/\\b([A-Z][a-z]*){2,}\\b/");

    private BndUtils() {
    }

    public static InputStream createBundle(InputStream jarInputStream, Properties instructions, String jarInfo) throws IOException {
        return BndUtils.createBundle(jarInputStream, instructions, jarInfo, OverwriteMode.KEEP);
    }

    public static InputStream createBundle(InputStream jarInputStream, Properties instructions, String jarInfo, OverwriteMode overwriteMode) throws IOException {
        NullArgumentException.validateNotNull(jarInputStream, "Jar URL");
        NullArgumentException.validateNotNull(instructions, "Instructions");
        NullArgumentException.validateNotEmpty(jarInfo, "Jar info");
        LOG.debug("Creating bundle for [" + jarInfo + "]");
        LOG.debug("Overwrite mode: " + (Object)((Object)overwriteMode));
        LOG.trace("Using instructions " + instructions);
        Jar jar = new Jar("dot", jarInputStream);
        Manifest manifest = null;
        try {
            manifest = jar.getManifest();
        }
        catch (Exception e) {
            jar.close();
            throw new Ops4jException(e);
        }
        if (manifest == null || OverwriteMode.KEEP != overwriteMode || manifest.getMainAttributes().getValue("Export-Package") == null && manifest.getMainAttributes().getValue("Import-Package") == null) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)instructions);
            properties.put("Generated-By-Ops4j-Pax-From", jarInfo);
            Analyzer analyzer = new Analyzer();
            analyzer.setJar(jar);
            analyzer.setProperties(properties);
            if (manifest != null && OverwriteMode.MERGE == overwriteMode) {
                analyzer.mergeManifest(manifest);
            }
            BndUtils.checkMandatoryProperties(analyzer, jar, jarInfo);
            try {
                Manifest newManifest = analyzer.calcManifest();
                jar.setManifest(newManifest);
            }
            catch (Exception e) {
                jar.close();
                throw new Ops4jException(e);
            }
        }
        return BndUtils.createInputStream(jar);
    }

    private static PipedInputStream createInputStream(final Jar jar) throws IOException {
        final CloseAwarePipedInputStream pin = new CloseAwarePipedInputStream();
        final PipedOutputStream pout = new PipedOutputStream(pin);
        new Thread(){

            @Override
            public void run() {
                try {
                    jar.write(pout);
                }
                catch (Exception e) {
                    if (pin.closed) {
                        LOG.debug("Bundle cannot be generated, pipe closed by reader", (Throwable)e);
                    } else {
                        LOG.warn("Bundle cannot be generated", (Throwable)e);
                    }
                }
                finally {
                    try {
                        jar.close();
                        pout.close();
                    }
                    catch (IOException ignore) {
                        LOG.error("Bundle cannot be generated", (Throwable)ignore);
                    }
                }
            }
        }.start();
        return pin;
    }

    private static void checkMandatoryProperties(Analyzer analyzer, Jar jar, String symbolicName) {
        String exportPackage;
        String importPackage = analyzer.getProperty("Import-Package");
        if (importPackage == null || importPackage.trim().length() == 0) {
            analyzer.setProperty("Import-Package", "*;resolution:=optional");
        }
        if ((exportPackage = analyzer.getProperty("Export-Package")) == null || exportPackage.trim().length() == 0) {
            analyzer.setProperty("Export-Package", "*");
        }
        String localSymbolicName = analyzer.getProperty("Bundle-SymbolicName", symbolicName);
        analyzer.setProperty("Bundle-SymbolicName", BndUtils.generateSymbolicName(localSymbolicName));
    }

    private static String generateSymbolicName(String symbolicName) {
        return symbolicName.replaceAll("[^a-zA-Z_0-9.-]", "_");
    }

    public static Properties parseInstructions(String query) throws MalformedURLException {
        Properties instructions = new Properties();
        if (query != null) {
            try {
                String[] segments;
                for (String segment : segments = query.split("&")) {
                    if (segment.trim().length() <= 0) continue;
                    Matcher matcher = INSTRUCTIONS_PATTERN.matcher(segment);
                    if (matcher.matches()) {
                        String key = matcher.group(1);
                        String val = matcher.group(2);
                        instructions.setProperty(BndUtils.verifyKey(key), val != null ? URLDecoder.decode(val, "UTF-8") : "");
                        continue;
                    }
                    throw new MalformedURLException("Invalid syntax for instruction [" + segment + "]. Take a look at http://www.aqute.biz/Code/Bnd.");
                }
            }
            catch (UnsupportedEncodingException e) {
                BndUtils.throwAsMalformedURLException("Could not retrieve the instructions from [" + query + "]", e);
            }
        }
        return instructions;
    }

    private static String verifyKey(String key) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(Constants.headers));
        list.add("Web-ContextPath");
        if (list.contains(key)) {
            return key;
        }
        if (CAMELCASE_PATTERN.matcher(key).matches()) {
            return key;
        }
        for (String header : list) {
            if (!header.equalsIgnoreCase(key)) continue;
            return header;
        }
        return key;
    }

    private static void throwAsMalformedURLException(String message, Exception cause) throws MalformedURLException {
        MalformedURLException exception = new MalformedURLException(message);
        exception.initCause(cause);
        throw exception;
    }

    private static final class CloseAwarePipedInputStream
    extends PipedInputStream {
        private boolean closed = false;

        private CloseAwarePipedInputStream() {
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            super.close();
        }
    }
}

