/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.MatchReference;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationListExpression;
import org.apache.uima.ruta.expression.feature.FeatureExpression;
import org.apache.uima.ruta.expression.feature.FeatureMatchExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.expression.type.ITypeListExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class AnnotationTypeExpression
extends RutaExpression
implements ITypeExpression,
IAnnotationExpression,
IAnnotationListExpression {
    private MatchReference reference;
    private ITypeExpression typeExpression;
    private ITypeListExpression typeListExpression;
    private IAnnotationExpression annotationExpression;
    private IAnnotationListExpression annotationListExpression;
    private FeatureExpression featureExpression;
    private boolean initialized = false;

    public AnnotationTypeExpression(MatchReference reference) {
        this.reference = reference;
    }

    private void initialize(MatchContext context, RutaStream stream) {
        this.annotationExpression = this.reference.getAnnotationExpression(context, stream);
        this.annotationListExpression = this.reference.getAnnotationListExpression(context, stream);
        this.featureExpression = this.reference.getFeatureExpression(context, stream);
        this.typeExpression = this.reference.getTypeExpression(context, stream);
        this.typeListExpression = this.reference.getTypeListExpression(context, stream);
        this.initialized = true;
    }

    @Override
    public AnnotationFS getAnnotation(MatchContext context, RutaStream stream) {
        if (!this.initialized) {
            this.initialize(context, stream);
        }
        if (this.annotationExpression != null) {
            AnnotationFS annotation = this.annotationExpression.getAnnotation(context, stream);
            if (this.featureExpression != null) {
                Collection<? extends AnnotationFS> result = this.featureExpression.getAnnotations(Arrays.asList(annotation), true, context, stream);
                if (result != null && !result.isEmpty()) {
                    return result.iterator().next();
                }
                return null;
            }
            return annotation;
        }
        if (this.annotationListExpression != null) {
            List<AnnotationFS> annotations = this.annotationListExpression.getAnnotationList(context, stream);
            if (annotations != null && !annotations.isEmpty()) {
                if (this.featureExpression != null) {
                    Collection<? extends AnnotationFS> result = this.featureExpression.getAnnotations(annotations, true, context, stream);
                    if (result.isEmpty()) {
                        return null;
                    }
                    annotations = new ArrayList<AnnotationFS>(result);
                }
                if (context.getDirection()) {
                    return annotations.get(annotations.size() - 1);
                }
                return annotations.get(0);
            }
        } else {
            Type type;
            List<Object> types = null;
            types = this.typeListExpression != null ? this.typeListExpression.getTypeList(context, stream) : ((type = this.getType(context, stream)) != null ? Arrays.asList(type) : Collections.emptyList());
            for (Type type2 : types) {
                if (type2 == null) continue;
                List<AnnotationFS> bestGuessedAnnotations = null;
                if (this.featureExpression instanceof FeatureMatchExpression) {
                    bestGuessedAnnotations = stream.getAnnotationsByTypeInContext(type2, context);
                } else if (this.featureExpression != null) {
                    bestGuessedAnnotations = stream.getBestGuessedAnnotationsAt(context.getAnnotation(), type2);
                } else {
                    bestGuessedAnnotations = stream.getBestGuessedAnnotationsAt(context.getAnnotation(), type2);
                    if (bestGuessedAnnotations.isEmpty()) {
                        bestGuessedAnnotations = Arrays.asList(stream.getSingleAnnotationByTypeInContext(type2, context));
                    }
                }
                if (this.featureExpression != null) {
                    ArrayList<AnnotationFS> annotations = new ArrayList<AnnotationFS>();
                    annotations.addAll(bestGuessedAnnotations);
                    Collection<? extends AnnotationFS> featureAnnotations = this.featureExpression.getAnnotations(annotations, true, context, stream);
                    if (featureAnnotations != null && !featureAnnotations.isEmpty()) {
                        return featureAnnotations.iterator().next();
                    }
                }
                if (bestGuessedAnnotations == null || bestGuessedAnnotations.isEmpty()) continue;
                return bestGuessedAnnotations.get(0);
            }
        }
        return null;
    }

    @Override
    public FeatureStructure getFeatureStructure(MatchContext context, RutaStream stream) {
        if (this.annotationExpression != null) {
            return this.annotationExpression.getFeatureStructure(context, stream);
        }
        return this.getAnnotation(context, stream);
    }

    @Override
    public List<FeatureStructure> getFeatureStructureList(MatchContext context, RutaStream stream) {
        if (this.annotationListExpression != null) {
            return this.annotationListExpression.getFeatureStructureList(context, stream);
        }
        List<AnnotationFS> annotationList = this.getAnnotationList(context, stream);
        ArrayList<FeatureStructure> result = new ArrayList<FeatureStructure>();
        result.addAll(annotationList);
        return result;
    }

    @Override
    public Type getType(MatchContext context, RutaStream stream) {
        if (!this.initialized) {
            this.initialize(context, stream);
        }
        if (this.typeExpression == null && this.typeListExpression == null && this.annotationExpression == null && this.annotationListExpression == null) {
            return null;
        }
        if (this.typeExpression != null) {
            return this.typeExpression.getType(context, stream);
        }
        AnnotationFS annotation = this.getAnnotation(context, stream);
        if (annotation != null) {
            return annotation.getType();
        }
        return null;
    }

    @Override
    public String getStringValue(MatchContext context, RutaStream stream) {
        if (!this.initialized) {
            this.initialize(context, stream);
        }
        if (this.annotationListExpression != null) {
            return this.annotationListExpression.getStringValue(context, stream);
        }
        if (this.annotationExpression != null) {
            return this.annotationExpression.getStringValue(context, stream);
        }
        if (this.typeListExpression != null) {
            return this.typeListExpression.getStringValue(context, stream);
        }
        if (this.typeExpression != null) {
            return this.typeExpression.getStringValue(context, stream);
        }
        return "";
    }

    @Override
    public List<AnnotationFS> getAnnotationList(MatchContext context, RutaStream stream) {
        if (!this.initialized) {
            this.initialize(context, stream);
        }
        if (this.annotationListExpression != null) {
            List<AnnotationFS> result = this.annotationListExpression.getAnnotationList(context, stream);
            if (result != null && this.featureExpression != null) {
                return new ArrayList<AnnotationFS>(this.featureExpression.getAnnotations(result, true, context, stream));
            }
            return result;
        }
        if (this.annotationExpression != null) {
            AnnotationFS annotation = this.annotationExpression.getAnnotation(context, stream);
            List<AnnotationFS> result = Arrays.asList(annotation);
            if (this.featureExpression != null) {
                return new ArrayList<AnnotationFS>(this.featureExpression.getAnnotations(result, true, context, stream));
            }
            return result;
        }
        List<Type> types = null;
        types = this.typeListExpression != null ? this.typeListExpression.getTypeList(context, stream) : Arrays.asList(this.getType(context, stream));
        ArrayList<AnnotationFS> annotations = new ArrayList<AnnotationFS>();
        for (Type type : types) {
            if (type == null) continue;
            List<AnnotationFS> bestGuessedAnnotations = null;
            if (this.featureExpression instanceof FeatureMatchExpression) {
                bestGuessedAnnotations = stream.getAnnotationsByTypeInContext(type, context);
            } else if (this.featureExpression != null) {
                bestGuessedAnnotations = stream.getBestGuessedAnnotationsAt(context.getAnnotation(), type);
                if (bestGuessedAnnotations.isEmpty()) {
                    bestGuessedAnnotations = stream.getAnnotationsByTypeInContext(type, context);
                }
            } else {
                bestGuessedAnnotations = stream.getAnnotationsByTypeInContext(type, context);
            }
            if (this.featureExpression != null) {
                Collection<? extends AnnotationFS> featureAnnotations = this.featureExpression.getAnnotations(bestGuessedAnnotations, true, context, stream);
                if (featureAnnotations == null || featureAnnotations.isEmpty()) continue;
                annotations.addAll(featureAnnotations);
                continue;
            }
            if (bestGuessedAnnotations == null || bestGuessedAnnotations.isEmpty()) continue;
            annotations.addAll(bestGuessedAnnotations);
        }
        return annotations;
    }

    public MatchReference getReference() {
        return this.reference;
    }

    public void setReference(MatchReference reference) {
        this.reference = reference;
    }

    public ITypeExpression getTypeExpression() {
        return this.typeExpression;
    }

    public ITypeListExpression getTypeListExpression() {
        return this.typeListExpression;
    }

    public IAnnotationExpression getAnnotationExpression() {
        return this.annotationExpression;
    }

    public IAnnotationListExpression getAnnotationListExpression() {
        return this.annotationListExpression;
    }

    public FeatureExpression getFeatureExpression() {
        return this.featureExpression;
    }

    public String toString() {
        return this.reference.toString();
    }
}

