/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.serializer;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jabsorb.serializer.FixUp;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ProcessedObject;
import org.jabsorb.serializer.UnmarshallException;

public class SerializerState {
    private Map processedObjects = new IdentityHashMap();
    private List fixups = new ArrayList();
    private LinkedList currentLocation = new LinkedList();

    public void addFixUp(List originalLocation, Object ref) throws MarshallException {
        this.currentLocation.add(ref);
        this.fixups.add(new FixUp(this.currentLocation, originalLocation));
        this.pop();
    }

    public List getFixUps() {
        return this.fixups;
    }

    public ProcessedObject getProcessedObject(Object object) {
        return (ProcessedObject)this.processedObjects.get(object);
    }

    public boolean isAncestor(ProcessedObject dup, Object parent) {
        for (ProcessedObject ancestor = this.getProcessedObject(parent); ancestor != null; ancestor = ancestor.getParent()) {
            if (dup != ancestor) continue;
            return true;
        }
        return false;
    }

    public void pop() throws MarshallException {
        if (this.currentLocation.size() == 0) {
            throw new MarshallException("scope error, attempt to pop too much off the scope stack.");
        }
        this.currentLocation.removeLast();
    }

    public void push(Object parent, Object obj, Object ref) {
        ProcessedObject parentProcessedObject = null;
        if (parent != null && (parentProcessedObject = this.getProcessedObject(parent)) == null) {
            throw new IllegalArgumentException("attempt to process an object with an unprocessed parent");
        }
        ProcessedObject p = new ProcessedObject();
        p.setParent(parentProcessedObject);
        p.setObject(obj);
        this.processedObjects.put(obj, p);
        if (ref != null) {
            p.setRef(ref);
            this.currentLocation.add(ref);
        }
    }

    public void setSerialized(Object source, Object target) throws UnmarshallException {
        if (source == null) {
            throw new UnmarshallException("source object may not be null");
        }
        ProcessedObject p = this.getProcessedObject(source);
        if (p == null) {
            throw new UnmarshallException("source object must be already registered as a ProcessedObject " + String.valueOf(source));
        }
        p.setSerialized(target);
    }

    public ProcessedObject store(Object obj) {
        ProcessedObject p = new ProcessedObject();
        p.setObject(obj);
        this.processedObjects.put(obj, p);
        return p;
    }
}

