/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.basic;

import java.sql.Connection;
import java.util.ArrayList;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.basic.BasicModelManager;
import org.apache.fulcrum.security.model.basic.entity.BasicGroup;
import org.apache.fulcrum.security.model.basic.entity.BasicUser;
import org.apache.fulcrum.security.spi.AbstractManager;
import org.apache.fulcrum.security.torque.security.TorqueAbstractSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.torque.TorqueException;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public class TorqueBasicModelManagerImpl
extends AbstractManager
implements BasicModelManager {
    public synchronized void grant(User user, Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = this.getGroupManager().checkExists(group);
        boolean userExists = this.getUserManager().checkExists(user);
        if (groupExists && userExists) {
            ((BasicUser)user).addGroup(group);
            ((BasicGroup)group).addUser(user);
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                ((TorqueAbstractSecurityEntity)user).update((Connection)con);
                ((TorqueAbstractSecurityEntity)group).update((Connection)con);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (TorqueException e) {
                throw new DataBackendException("grant('" + user.getName() + String.valueOf(user.getId()) + "', '" + group.getName() + String.valueOf(group.getId()) + "') failed", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
            return;
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
    }

    public synchronized void revoke(User user, Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = this.getGroupManager().checkExists(group);
        boolean userExists = this.getUserManager().checkExists(user);
        if (groupExists && userExists) {
            ((BasicUser)user).removeGroup(group);
            ((BasicGroup)group).removeUser(user);
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                ((TorqueAbstractSecurityEntity)user).update((Connection)con);
                ((TorqueAbstractSecurityEntity)group).update((Connection)con);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (TorqueException e) {
                throw new DataBackendException("grant('" + user.getName() + String.valueOf(user.getId()) + "', '" + group.getName() + String.valueOf(group.getId()) + "') failed", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
            return;
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
    }

    public synchronized void revokeAll(User user) throws DataBackendException, UnknownEntityException {
        boolean userExists = this.getUserManager().checkExists(user);
        if (userExists) {
            BasicUser u = (BasicUser)user;
            ArrayList groups = new ArrayList(u.getGroups());
            for (Group group : groups) {
                u.removeGroup(group);
            }
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                ((TorqueAbstractSecurityEntity)user).update((Connection)con);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (TorqueException e) {
                throw new DataBackendException("revokeAll('" + user.getName() + String.valueOf(user.getId()) + "') failed", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
            return;
        }
        throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
    }
}

