/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.mimetype.util;

import java.util.ArrayList;

public class MimeType
implements Cloneable {
    public static final MimeType TEXT_HTML = new MimeType("text/html");
    public static final MimeType TEXT_WML = new MimeType("text/vnd.wap.wml");
    public static final MimeType TEXT_HDML = new MimeType("text/x-hdml");
    public static final MimeType TEXT_CHTML = new MimeType("text/x-chtml");
    public static final MimeType TEXT_PLAIN = new MimeType("text/plain");
    public static final MimeType MULTIPART = new MimeType("multipart/*");
    public static final MimeType MULTIPART_FORM_DATA = new MimeType("multipart/form-data");
    public static final MimeType APPLICATION_POSTSCRIPT = new MimeType("application/postscript");
    public static final MimeType APPLICATION_OCTET_STREAM = new MimeType("application/octet-stream");
    public static final MimeType APPLICATION_X_JAVA_AGENT = new MimeType("application/x-java-agent");
    public static final MimeType APPLICATION_X_WWW_FORM_URLENCODED = new MimeType("application/x-www-form-urlencoded");
    public static final MimeType MESSAGE_HTTP = new MimeType("message/http");
    public static final MimeType TEXT_CSS = new MimeType("text/css");
    public static final MimeType TEXT = new MimeType("text/*");
    public static final MimeType IMAGE_PNG = new MimeType("image/png");
    public static final MimeType IMAGE_GIF = new MimeType("image/gif");
    public static final MimeType IMAGE_JPEG = new MimeType("image/jpeg");
    public static final MimeType IMAGE_WBMP = new MimeType("image/vnd.wap.wbmp");
    public static final int NO_MATCH = 0;
    public static final int MATCH_TYPE = 1;
    public static final int MATCH_SUBTYPE = 2;
    public static final int MATCH_SPECIFIC_SUBTYPE = 3;
    private String mimeType;
    private String mimeSubtype;
    private String[] parameterNames;
    private String[] parameterValues;
    private String mimeTypeString;

    public MimeType(String spec) {
        this(spec, true);
    }

    public MimeType(String spec, boolean parsep) {
        int start;
        char look = '\u0000';
        int length = spec.length();
        for (start = 0; start < length && Character.isWhitespace(spec.charAt(start)); ++start) {
        }
        while (length > start && Character.isWhitespace(spec.charAt(length - 1))) {
            --length;
        }
        StringBuilder sb = new StringBuilder();
        while (start < length) {
            char c = spec.charAt(start);
            look = c;
            if (c == '/') break;
            sb.append(look);
            ++start;
        }
        if (look != '/') {
            throw new IllegalArgumentException("Syntax error in MIME type " + spec);
        }
        this.mimeType = sb.toString();
        ++start;
        sb.setLength(0);
        while (start < length && (look = spec.charAt(start)) != ';' && !Character.isWhitespace(look)) {
            sb.append(look);
            ++start;
        }
        this.mimeSubtype = sb.toString();
        if (parsep) {
            while (start < length && Character.isWhitespace(spec.charAt(start))) {
                ++start;
            }
            if (start < length) {
                if (spec.charAt(start) != ';') {
                    throw new IllegalArgumentException("Syntax error in MIME type parameters " + spec);
                }
                ++start;
                ArrayList<String> na = new ArrayList<String>(4);
                ArrayList<String> va = new ArrayList<String>(4);
                while (start < length) {
                    while (start < length && Character.isWhitespace(spec.charAt(start))) {
                        ++start;
                    }
                    sb.setLength(0);
                    while (start < length && (look = spec.charAt(start)) != '=' && !Character.isWhitespace(look)) {
                        sb.append(Character.toLowerCase(look));
                        ++start;
                    }
                    String name = sb.toString();
                    while (start < length && Character.isWhitespace(spec.charAt(start))) {
                        ++start;
                    }
                    if (spec.charAt(start) != '=') {
                        throw new IllegalArgumentException("Syntax error in MIME type parameters " + spec);
                    }
                    ++start;
                    while (start < length && Character.isWhitespace(spec.charAt(start))) {
                        ++start;
                    }
                    sb.setLength(0);
                    int delim = 59;
                    if (spec.charAt(start) == '\"') {
                        ++start;
                        delim = 34;
                    }
                    while (!(start >= length || (look = spec.charAt(start)) == delim || delim != 34 && Character.isWhitespace(look))) {
                        sb.append(look);
                        ++start;
                    }
                    while (start < length && spec.charAt(start) != ';') {
                        ++start;
                    }
                    ++start;
                    String value = sb.toString();
                    na.add(name);
                    va.add(value);
                }
                this.parameterNames = na.toArray(new String[na.size()]);
                this.parameterValues = va.toArray(new String[va.size()]);
            }
        }
    }

    public MimeType(String type, String subtype) {
        this(type, subtype, null, null);
    }

    public MimeType(String type, String subtype, String[] names, String[] values) {
        if (type == null || subtype == null) {
            throw new NullPointerException("MIME type or subtype missing");
        }
        this.mimeType = type.trim();
        this.mimeSubtype = subtype.trim();
        this.parameterNames = names;
        this.parameterValues = values;
    }

    public int match(MimeType other) {
        if (this.mimeType.equals("*") || other.mimeType.equals("*")) {
            return 1;
        }
        if (!this.mimeType.equalsIgnoreCase(other.mimeType)) {
            return 0;
        }
        if (this.mimeSubtype.equals("*") || other.mimeSubtype.equals("*")) {
            return 2;
        }
        if (!this.mimeSubtype.equalsIgnoreCase(other.mimeSubtype)) {
            return 0;
        }
        return 3;
    }

    public String getType() {
        return this.mimeType;
    }

    public String getSubtype() {
        return this.mimeSubtype;
    }

    public String getTypes() {
        return this.mimeType + '/' + this.mimeSubtype;
    }

    public synchronized boolean hasParameter(String param) {
        String[] na = this.parameterNames;
        if (na != null) {
            for (int i = 0; i < na.length; ++i) {
                if (!na[i].equalsIgnoreCase(param)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized String getParameter(String param) {
        String[] na = this.parameterNames;
        if (na != null) {
            String[] va = this.parameterValues;
            for (int i = 0; i < na.length; ++i) {
                if (!na[i].equalsIgnoreCase(param)) continue;
                return va[i];
            }
        }
        return null;
    }

    public synchronized void setParameter(String param, String value) {
        if (this.parameterNames != null) {
            for (int i = 0; i < this.parameterNames.length; ++i) {
                if (!this.parameterNames[i].equalsIgnoreCase(param)) continue;
                this.parameterValues[i] = value;
                this.mimeTypeString = null;
                return;
            }
        }
        this.addParameter(param, value);
    }

    public void addParameter(String param, String value) {
        this.addParameters(new String[]{param}, new String[]{value});
    }

    public synchronized void addParameters(String[] params, String[] values) {
        if (params == null || values == null || params.length != values.length) {
            throw new IllegalArgumentException("Incorrect MIME type parameters");
        }
        if (this.parameterNames != null) {
            String[] na = new String[this.parameterNames.length + params.length];
            String[] va = new String[this.parameterValues.length + values.length];
            System.arraycopy(this.parameterNames, 0, na, 0, this.parameterNames.length);
            System.arraycopy(params, 0, na, this.parameterNames.length, params.length);
            System.arraycopy(this.parameterValues, 0, va, 0, this.parameterValues.length);
            System.arraycopy(values, 0, va, this.parameterValues.length, values.length);
            this.parameterNames = na;
            this.parameterValues = va;
        } else {
            this.parameterNames = params;
            this.parameterValues = values;
        }
        this.mimeTypeString = null;
    }

    public String toString() {
        if (this.mimeTypeString == null) {
            StringBuilder sb = new StringBuilder(this.mimeType);
            sb.append('/');
            sb.append(this.mimeSubtype);
            String[] na = this.parameterNames;
            if (na != null) {
                String[] va = this.parameterValues;
                for (int i = 0; i < va.length; ++i) {
                    sb.append(';');
                    sb.append(na[i]);
                    if (va[i] == null) continue;
                    sb.append('=');
                    sb.append(va[i]);
                }
            }
            this.mimeTypeString = sb.toString();
        }
        return this.mimeTypeString;
    }
}

