/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Objects;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class MultiValueHashMap<K, V>
extends BaseHashMap
implements Map<K, V> {
    private Set<K> keySet;
    private Collection<V> values;
    private Set<Map.Entry<K, V>> entries;

    public MultiValueHashMap() {
        this(8);
    }

    public MultiValueHashMap(int n) throws IllegalArgumentException {
        super(n, 3, 3, false);
        this.isMultiValue = true;
    }

    public MultiValueHashMap(int n, ObjectComparator<K> objectComparator) throws IllegalArgumentException {
        this(n);
        this.comparator = objectComparator;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return super.containsObjectKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    @Override
    public V get(K k) {
        if (k == null) {
            throw new NullPointerException();
        }
        int n = this.comparator.hashCode(k);
        int n2 = this.getLookup(k, n);
        if (n2 != -1) {
            return (V)this.objectValueTable[n2];
        }
        return null;
    }

    public Iterator<V> getValuesIterator(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return super.getMultiValuesIterator(object);
    }

    @Override
    public V put(K k, V v) {
        if (k == null) {
            throw new NullPointerException();
        }
        boolean bl = super.addMultiVal(0L, 0L, k, v);
        return bl ? null : (V)v;
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return (V)super.removeMultiVal(0L, 0L, object, null, false);
    }

    public boolean remove(K k, V v) {
        if (k == null) {
            throw new NullPointerException();
        }
        Object object = super.removeMultiVal(0L, 0L, k, v, true);
        return object != null;
    }

    public int valueCount(K k) {
        if (k == null) {
            throw new NullPointerException();
        }
        int n = this.comparator.hashCode(k);
        return super.multiValueElementCount(k);
    }

    public void putAll(Map<K, V> map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null) continue;
            this.put(e, map.get(e));
        }
    }

    public void putAll(MultiValueHashMap<K, V> multiValueHashMap) {
        Iterator iterator = multiValueHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Iterator<V> iterator2 = multiValueHashMap.getValuesIterator(e);
            while (iterator2.hasNext()) {
                V v = iterator2.next();
                this.put(e, v);
            }
        }
    }

    public <T> T[] keysToArray(T[] TArray) {
        return this.toArray(TArray, true);
    }

    public <T> T[] valuesToArray(T[] TArray) {
        return this.toArray(TArray, false);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values
    extends AbstractReadOnlyCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            MultiValueHashMap multiValueHashMap = MultiValueHashMap.this;
            Objects.requireNonNull(multiValueHashMap);
            return new BaseHashMap.BaseHashIterator(multiValueHashMap, false);
        }

        @Override
        public int size() {
            return MultiValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet
    extends AbstractReadOnlyCollection<K>
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new BaseHashMap.MultiValueKeyIterator(MultiValueHashMap.this);
        }

        @Override
        public int size() {
            return MultiValueHashMap.this.multiValueKeyCount();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator<K, V>
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(MultiValueHashMap.this, true);
        }

        @Override
        public Map.Entry<K, V> next() {
            Object object = super.next();
            Object object2 = MultiValueHashMap.this.objectValueTable[this.lookup];
            return new MapEntry<Object, Object>(object, object2);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return MultiValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

