/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.api.models.ComponentsImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.callbacks.CallbackIO;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import io.smallrye.openapi.runtime.io.headers.HeaderIO;
import io.smallrye.openapi.runtime.io.links.LinkIO;
import io.smallrye.openapi.runtime.io.media.ContentIO;
import io.smallrye.openapi.runtime.io.media.ExampleObjectIO;
import io.smallrye.openapi.runtime.io.media.SchemaIO;
import io.smallrye.openapi.runtime.io.parameters.ParameterIO;
import io.smallrye.openapi.runtime.io.parameters.RequestBodyIO;
import io.smallrye.openapi.runtime.io.responses.APIResponseIO;
import io.smallrye.openapi.runtime.io.security.SecuritySchemeIO;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.jboss.jandex.AnnotationInstance;

public class ComponentsIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<Components, V, A, O, AB, OB> {
    private static final String PROP_CALLBACKS = "callbacks";
    private static final String PROP_LINKS = "links";
    private static final String PROP_SECURITY_SCHEMES = "securitySchemes";
    private static final String PROP_HEADERS = "headers";
    private static final String PROP_REQUEST_BODIES = "requestBodies";
    private static final String PROP_EXAMPLES = "examples";
    private static final String PROP_PARAMETERS = "parameters";
    private static final String PROP_RESPONSES = "responses";
    private static final String PROP_SCHEMAS = "schemas";
    private final APIResponseIO<V, A, O, AB, OB> responseIO;
    private final HeaderIO<V, A, O, AB, OB> headerIO;
    private final SchemaIO<V, A, O, AB, OB> schemaIO;
    private final ExampleObjectIO<V, A, O, AB, OB> exampleObjectIO;
    private final CallbackIO<V, A, O, AB, OB> callbackIO;
    private final LinkIO<V, A, O, AB, OB> linkIO;
    private final ParameterIO<V, A, O, AB, OB> parameterIO;
    private final RequestBodyIO<V, A, O, AB, OB> requestBodyIO;
    private final SecuritySchemeIO<V, A, O, AB, OB> securitySchemeIO;
    private final ExtensionIO<V, A, O, AB, OB> extensionIO;

    public ComponentsIO(IOContext<V, A, O, AB, OB> context, ContentIO<V, A, O, AB, OB> contentIO, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        super(context, Names.COMPONENTS, Names.create(Components.class));
        this.responseIO = new APIResponseIO<V, A, O, AB, OB>(context, contentIO, extensionIO);
        this.headerIO = new HeaderIO<V, A, O, AB, OB>(context, contentIO, extensionIO);
        this.schemaIO = new SchemaIO<V, A, O, AB, OB>(context, extensionIO);
        this.exampleObjectIO = new ExampleObjectIO<V, A, O, AB, OB>(context, extensionIO);
        this.callbackIO = new CallbackIO<V, A, O, AB, OB>(context, contentIO, extensionIO);
        this.linkIO = new LinkIO<V, A, O, AB, OB>(context, extensionIO);
        this.parameterIO = new ParameterIO<V, A, O, AB, OB>(context, contentIO, extensionIO);
        this.requestBodyIO = new RequestBodyIO<V, A, O, AB, OB>(context, contentIO, extensionIO);
        this.securitySchemeIO = new SecuritySchemeIO<V, A, O, AB, OB>(context, extensionIO);
        this.extensionIO = extensionIO;
    }

    public CallbackIO<V, A, O, AB, OB> callbacks() {
        return this.callbackIO;
    }

    public SecuritySchemeIO<V, A, O, AB, OB> securitySchemes() {
        return this.securitySchemeIO;
    }

    @Override
    public Components read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@Components");
        ComponentsImpl components = new ComponentsImpl();
        components.setCallbacks(this.callbackIO.readMap(annotation.value(PROP_CALLBACKS)));
        components.setExamples(this.exampleObjectIO.readMap(annotation.value(PROP_EXAMPLES)));
        components.setHeaders(this.headerIO.readMap(annotation.value(PROP_HEADERS)));
        components.setLinks(this.linkIO.readMap(annotation.value(PROP_LINKS)));
        components.setParameters(this.parameterIO.readMap(annotation.value(PROP_PARAMETERS)));
        components.setRequestBodies(this.requestBodyIO.readMap(annotation.value(PROP_REQUEST_BODIES)));
        components.setResponses(this.responseIO.readMap(annotation.value(PROP_RESPONSES)));
        components.setSchemas(this.schemaIO.readMap(annotation.value(PROP_SCHEMAS)));
        components.setSecuritySchemes(this.securitySchemeIO.readMap(annotation.value(PROP_SECURITY_SCHEMES)));
        components.setExtensions(this.extensionIO.readExtensible(annotation));
        return components;
    }

    @Override
    public Components readObject(O node) {
        IoLogging.logger.singleJsonNode("Components");
        ComponentsImpl components = new ComponentsImpl();
        components.setCallbacks(this.callbackIO.readMap(this.jsonIO().getValue(node, PROP_CALLBACKS)));
        components.setExamples(this.exampleObjectIO.readMap(this.jsonIO().getValue(node, PROP_EXAMPLES)));
        components.setHeaders(this.headerIO.readMap(this.jsonIO().getValue(node, PROP_HEADERS)));
        components.setLinks(this.linkIO.readMap(this.jsonIO().getValue(node, PROP_LINKS)));
        components.setParameters(this.parameterIO.readMap(this.jsonIO().getValue(node, PROP_PARAMETERS)));
        components.setRequestBodies(this.requestBodyIO.readMap(this.jsonIO().getValue(node, PROP_REQUEST_BODIES)));
        components.setResponses(this.responseIO.readMap(this.jsonIO().getValue(node, PROP_RESPONSES)));
        components.setSchemas(this.schemaIO.readMap(this.jsonIO().getValue(node, PROP_SCHEMAS)));
        components.setSecuritySchemes(this.securitySchemeIO.readMap(this.jsonIO().getValue(node, PROP_SECURITY_SCHEMES)));
        components.setExtensions(this.extensionIO.readMap(node));
        return components;
    }

    @Override
    public Optional<O> write(Components model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setIfPresent(node, PROP_SCHEMAS, this.schemaIO.write(model.getSchemas()));
            this.setIfPresent(node, PROP_RESPONSES, this.responseIO.write(model.getResponses()));
            this.setIfPresent(node, PROP_PARAMETERS, this.parameterIO.write(model.getParameters()));
            this.setIfPresent(node, PROP_EXAMPLES, this.exampleObjectIO.write(model.getExamples()));
            this.setIfPresent(node, PROP_REQUEST_BODIES, this.requestBodyIO.write(model.getRequestBodies()));
            this.setIfPresent(node, PROP_HEADERS, this.headerIO.write(model.getHeaders()));
            this.setIfPresent(node, PROP_SECURITY_SCHEMES, this.securitySchemeIO.write(model.getSecuritySchemes()));
            this.setIfPresent(node, PROP_LINKS, this.linkIO.write(model.getLinks()));
            this.setIfPresent(node, PROP_CALLBACKS, this.callbackIO.write(model.getCallbacks()));
            this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

