/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import jakarta.enterprise.context.RequestScoped;
import org.apache.openejb.BeanContext;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.web.context.ServletRequestContext;

public class RequestScopedThreadContextListener
implements ThreadContextListener {
    @Override
    public void contextEntered(ThreadContext oldContext, ThreadContext newContext, boolean propagateTx) {
        BeanContext beanContext = newContext.getBeanContext();
        WebBeansContext webBeansContext = beanContext.getModuleContext().getAppContext().getWebBeansContext();
        if (webBeansContext == null) {
            return;
        }
        ContextsService contextsService = webBeansContext.getContextsService();
        ServletRequestContext requestContext = ((CdiAppContextsService)((Object)CdiAppContextsService.class.cast(contextsService))).getRequestContext(false);
        if (requestContext == null) {
            contextsService.startContext(RequestScoped.class, CdiAppContextsService.EJB_REQUEST_EVENT);
            newContext.set(DestroyContext.class, new DestroyContext(contextsService, newContext));
        }
    }

    @Override
    public void contextExited(ThreadContext exitedContext, ThreadContext reenteredContext) {
        if (exitedContext == null) {
            return;
        }
        DestroyContext destroyContext = exitedContext.get(DestroyContext.class);
        if (destroyContext == null || destroyContext.threadContext != exitedContext) {
            return;
        }
        destroyContext.contextsService.endContext(RequestScoped.class, CdiAppContextsService.EJB_REQUEST_EVENT);
        destroyContext.contextsService.removeThreadLocals();
    }

    private static final class DestroyContext {
        private final ContextsService contextsService;
        private final ThreadContext threadContext;

        private DestroyContext(ContextsService contextsService, ThreadContext threadContext) {
            this.contextsService = contextsService;
            this.threadContext = threadContext;
        }
    }
}

