/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import jakarta.validation.ConstraintDefinitionException;
import jakarta.validation.ConstraintValidator;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.stream.Stream;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.reflection.TypeUtils;

public class ValidatorUtils {
    private static final WildcardType UNBOUNDED = TypeUtils.wildcardType().build();
    private static final String CV = ConstraintValidator.class.getSimpleName();

    public static Class<?> getValidatedType(Class<? extends ConstraintValidator<?, ?>> validatorType) {
        Type result = TypeUtils.getTypeArguments(validatorType, ConstraintValidator.class).get(ConstraintValidator.class.getTypeParameters()[1]);
        if (!ValidatorUtils.isSupported(result)) {
            Exceptions.raise(ConstraintDefinitionException::new, "Validated type %s declared by %s %s is unsupported", result, CV, validatorType.getName());
        }
        return TypeUtils.getRawType(result, null);
    }

    private static boolean isSupported(Type validatedType) {
        if (validatedType instanceof Class) {
            return true;
        }
        if (validatedType instanceof ParameterizedType) {
            return Stream.of(((ParameterizedType)validatedType).getActualTypeArguments()).allMatch(arg -> TypeUtils.equals(arg, (Type)UNBOUNDED));
        }
        return false;
    }
}

