/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;

public class AnonymousTraversalSource<T extends TraversalSource> {
    private final Class<T> traversalSourceClass;

    private AnonymousTraversalSource(Class<T> traversalSourceClass) {
        this.traversalSourceClass = traversalSourceClass;
    }

    public static AnonymousTraversalSource<GraphTraversalSource> traversal() {
        return AnonymousTraversalSource.traversal(GraphTraversalSource.class);
    }

    public static <T extends TraversalSource> AnonymousTraversalSource<T> traversal(Class<T> traversalSourceClass) {
        return new AnonymousTraversalSource<T>(traversalSourceClass);
    }

    @Deprecated
    public T withRemote(String configFile) throws Exception {
        return this.with(configFile);
    }

    @Deprecated
    public T withRemote(Configuration conf) {
        return this.with(RemoteConnection.from(conf));
    }

    @Deprecated
    public T withRemote(RemoteConnection remoteConnection) {
        return this.with(remoteConnection);
    }

    @Deprecated
    public T withEmbedded(Graph graph) {
        return this.with(graph);
    }

    public T with(Graph graph) {
        try {
            return (T)((TraversalSource)this.traversalSourceClass.getConstructor(Graph.class).newInstance(graph));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public T with(RemoteConnection remoteConnection) {
        try {
            return (T)((TraversalSource)this.traversalSourceClass.getConstructor(RemoteConnection.class).newInstance(remoteConnection));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public T with(String configFile) throws Exception {
        Configurations configs = new Configurations();
        return this.with((Configuration)configs.properties(configFile));
    }

    public T with(Configuration conf) {
        if (conf.containsKey("gremlin.graph")) {
            return this.with(GraphFactory.open(conf));
        }
        return this.with(RemoteConnection.from(conf));
    }
}

