/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy;

import java.io.Serializable;
import org.apache.commons.configuration2.Configuration;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class TraversalStrategyProxy<T extends TraversalStrategy>
implements Serializable,
TraversalStrategy {
    private final Configuration configuration;
    private final Class<T> strategyClass;

    public TraversalStrategyProxy(T traversalStrategy) {
        this(traversalStrategy.getClass(), traversalStrategy.getConfiguration());
    }

    public TraversalStrategyProxy(Class<T> strategyClass, Configuration configuration) {
        this.configuration = configuration;
        this.strategyClass = strategyClass;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Class<T> getStrategyClass() {
        return this.strategyClass;
    }

    public void apply(Traversal.Admin traversal) {
        throw new UnsupportedOperationException("TraversalStrategyProxy is not meant to be used directly as a TraversalStrategy and is for serialization purposes only");
    }

    @Override
    public int compareTo(Object o) {
        throw new UnsupportedOperationException("TraversalStrategyProxy is not meant to be used directly as a TraversalStrategy and is for serialization purposes only");
    }

    public String toString() {
        return StringFactory.traversalStrategyProxyString(this);
    }
}

