/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class ClassFilterStep<S, T>
extends FilterStep<S> {
    private final Class<T> classFilter;
    private final boolean allowClasses;

    public ClassFilterStep(Traversal.Admin traversal, Class<T> classFilter, boolean allowClasses) {
        super(traversal);
        this.classFilter = classFilter;
        this.allowClasses = allowClasses;
    }

    @Override
    public boolean filter(Traverser.Admin<S> traverser) {
        return this.allowClasses == this.classFilter.isInstance(traverser.get());
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.classFilter.hashCode() ^ Boolean.hashCode(this.allowClasses);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.classFilter.getSimpleName());
    }
}

