/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.validation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.validation.ResponseConstraintViolationException;

@Provider
public class ValidationExceptionMapper
implements ExceptionMapper<ValidationException> {
    private static final Logger LOG = LogUtils.getL7dLogger(ValidationExceptionMapper.class);
    private boolean addMessageToResponse;

    @Override
    public Response toResponse(ValidationException exception) {
        Response.Status errorStatus = Response.Status.INTERNAL_SERVER_ERROR;
        if (exception instanceof ConstraintViolationException) {
            StringBuilder responseBody = this.addMessageToResponse ? new StringBuilder() : null;
            ConstraintViolationException constraint = (ConstraintViolationException)exception;
            for (ConstraintViolation violation : constraint.getConstraintViolations()) {
                String message = this.buildErrorMessage(violation);
                if (responseBody != null) {
                    responseBody.append(message).append('\n');
                }
                LOG.log(Level.WARNING, message);
            }
            if (!(constraint instanceof ResponseConstraintViolationException)) {
                errorStatus = Response.Status.BAD_REQUEST;
            }
            return this.buildResponse(errorStatus, responseBody != null ? responseBody.toString() : null);
        }
        return this.buildResponse(errorStatus, this.addMessageToResponse ? exception.getMessage() : null);
    }

    protected String buildErrorMessage(ConstraintViolation<?> violation) {
        return "Value " + (String)(violation.getInvalidValue() != null ? "'" + violation.getInvalidValue().toString() + "'" : "(null)") + " of " + violation.getRootBeanClass().getSimpleName() + "." + violation.getPropertyPath() + ": " + violation.getMessage();
    }

    protected Response buildResponse(Response.Status errorStatus, String responseText) {
        Response.ResponseBuilder rb = JAXRSUtils.toResponseBuilder(errorStatus);
        if (responseText != null) {
            rb.type("text/plain").entity(responseText);
        }
        return rb.build();
    }

    public void setAddMessageToResponse(boolean addMessageToResponse) {
        this.addMessageToResponse = addMessageToResponse;
    }
}

