/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser.chunking;

import java.util.Arrays;
import java.util.List;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.model.Event;
import opennlp.tools.parser.AbstractBottomUpParser;
import opennlp.tools.parser.AbstractParserEventStream;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserEventTypeEnum;
import opennlp.tools.parser.chunking.BuildContextGenerator;
import opennlp.tools.parser.chunking.CheckContextGenerator;
import opennlp.tools.util.ObjectStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserEventStream
extends AbstractParserEventStream {
    private static final Logger logger = LoggerFactory.getLogger(ParserEventStream.class);
    protected BuildContextGenerator bcg;
    protected CheckContextGenerator kcg;

    public ParserEventStream(ObjectStream<Parse> d, HeadRules rules, ParserEventTypeEnum etype, Dictionary dict) {
        super(d, rules, etype, dict);
    }

    public ParserEventStream(ObjectStream<Parse> d, HeadRules rules, ParserEventTypeEnum etype) {
        this(d, rules, etype, null);
    }

    @Override
    protected void init() {
        if (this.etype == ParserEventTypeEnum.BUILD) {
            this.bcg = new BuildContextGenerator(this.dict);
        } else if (this.etype == ParserEventTypeEnum.CHECK) {
            this.kcg = new CheckContextGenerator();
        }
    }

    protected boolean firstChild(Parse child, Parse parent) {
        return AbstractBottomUpParser.collapsePunctuation(parent.getChildren(), this.punctSet)[0] == child;
    }

    public static Parse[] reduceChunks(Parse[] chunks, int ci, Parse parent) {
        Parse[] reducedChunks;
        int reduceStart;
        String type = parent.getType();
        int reduceEnd = ci;
        for (reduceStart = ci; reduceStart >= 0 && chunks[reduceStart].getParent() == parent; --reduceStart) {
        }
        ++reduceStart;
        if (!type.equals("TOP")) {
            reducedChunks = new Parse[chunks.length - (reduceEnd - reduceStart + 1) + 1];
            System.arraycopy(chunks, 0, reducedChunks, 0, reduceStart);
            reducedChunks[reduceStart] = parent;
            parent.setPrevPunctuation(chunks[reduceStart].getPreviousPunctuationSet());
            parent.setNextPunctuation(chunks[reduceEnd].getNextPunctuationSet());
            int ri = reduceStart + 1;
            for (int rci = reduceEnd + 1; rci < chunks.length; ++rci) {
                reducedChunks[ri] = chunks[rci];
                ++ri;
            }
            ci = reduceStart - 1;
        } else {
            reducedChunks = new Parse[]{};
        }
        return reducedChunks;
    }

    @Override
    protected void addParseEvents(List<Event> parseEvents, Parse[] chunks) {
        for (int ci = 0; ci < chunks.length; ++ci) {
            int start;
            Parse c;
            Parse parent;
            if (logger.isTraceEnabled()) {
                logger.trace("parserEventStream.addParseEvents: chunks={}", (Object)Arrays.asList(chunks));
            }
            if ((parent = (c = chunks[ci]).getParent()) == null) continue;
            String type = parent.getType();
            String outcome = this.firstChild(c, parent) ? "S-" + type : "C-" + type;
            if (logger.isTraceEnabled()) {
                logger.trace("parserEventStream.addParseEvents: chunks[{}]={} label={} bcg={}", ci, c, outcome, this.bcg);
            }
            c.setLabel(outcome);
            if (this.etype == ParserEventTypeEnum.BUILD) {
                parseEvents.add(new Event(outcome, this.bcg.getContext(chunks, ci)));
            }
            for (start = ci - 1; start >= 0 && chunks[start].getParent() == parent; --start) {
            }
            if (this.lastChild(c, parent)) {
                int reduceStart;
                if (this.etype == ParserEventTypeEnum.CHECK) {
                    parseEvents.add(new Event("c", this.kcg.getContext(chunks, type, start + 1, ci)));
                }
                for (reduceStart = ci; reduceStart >= 0 && chunks[reduceStart].getParent() == parent; --reduceStart) {
                }
                chunks = ParserEventStream.reduceChunks(chunks, ci, parent);
                ci = ++reduceStart - 1;
                continue;
            }
            if (this.etype != ParserEventTypeEnum.CHECK) continue;
            parseEvents.add(new Event("i", this.kcg.getContext(chunks, type, start + 1, ci)));
        }
    }
}

