/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.provider.FranceGeocentricInterpolation;
import org.apache.sis.internal.referencing.provider.Molodensky;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.transform.InterpolatedGeocentricTransform;
import org.apache.sis.referencing.operation.transform.InterpolatedMolodenskyTransform2D;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.MolodenskyFormula;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class InterpolatedMolodenskyTransform
extends MolodenskyFormula {
    private static final long serialVersionUID = -5691721806681489940L;
    private static final ParameterDescriptorGroup DESCRIPTOR;
    private static final ParameterDescriptorGroup INVERSE;
    private final InterpolatedMolodenskyTransform inverse;

    InterpolatedMolodenskyTransform(InterpolatedMolodenskyTransform interpolatedMolodenskyTransform, Ellipsoid ellipsoid, Ellipsoid ellipsoid2) {
        super(interpolatedMolodenskyTransform, ellipsoid, ellipsoid2, INVERSE);
        this.inverse = interpolatedMolodenskyTransform;
    }

    protected InterpolatedMolodenskyTransform(Ellipsoid ellipsoid, boolean bl, Ellipsoid ellipsoid2, boolean bl2, DatumShiftGrid<Angle, Length> datumShiftGrid) {
        super(ellipsoid, bl, ellipsoid2, bl2, datumShiftGrid.getCellMean(0), datumShiftGrid.getCellMean(1), datumShiftGrid.getCellMean(2), datumShiftGrid, false, DESCRIPTOR);
        InterpolatedMolodenskyTransform.ensureGeocentricTranslation(datumShiftGrid, ellipsoid.getAxisUnit());
        this.inverse = bl || bl2 ? new Inverse(this, ellipsoid, ellipsoid2) : new InterpolatedMolodenskyTransform2D.Inverse(this, ellipsoid, ellipsoid2);
    }

    public static MathTransform createGeodeticTransformation(MathTransformFactory mathTransformFactory, Ellipsoid ellipsoid, boolean bl, Ellipsoid ellipsoid2, boolean bl2, DatumShiftGrid<Angle, Length> datumShiftGrid) throws FactoryException {
        ArgumentChecks.ensureNonNull("grid", datumShiftGrid);
        InterpolatedMolodenskyTransform interpolatedMolodenskyTransform = bl || bl2 ? new InterpolatedMolodenskyTransform(ellipsoid, bl, ellipsoid2, bl2, datumShiftGrid) : new InterpolatedMolodenskyTransform2D(ellipsoid, ellipsoid2, datumShiftGrid);
        interpolatedMolodenskyTransform.inverse.context.completeTransform(mathTransformFactory, null);
        return interpolatedMolodenskyTransform.context.completeTransform(mathTransformFactory, interpolatedMolodenskyTransform);
    }

    @Override
    final void completeParameters(Parameters parameters, double d, Unit<?> unit, double d2) {
        super.completeParameters(parameters, d, unit, d2);
        if (parameters != this.context) {
            d2 = this.\u0394fmod / d;
            parameters.getOrCreate(Molodensky.AXIS_LENGTH_DIFFERENCE).setValue(this.\u0394a, unit);
            parameters.getOrCreate(Molodensky.FLATTENING_DIFFERENCE).setValue(d2, Units.UNITY);
        }
        this.grid.getParameterValues(parameters);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        double[] dArray3 = new double[3];
        double d = dArray[n];
        double d2 = dArray[n + 1];
        this.grid.interpolateInCell(this.normalizedToGridX(d), this.normalizedToGridY(d2), dArray3);
        return this.transform(d, d2, this.isSource3D ? dArray[n + 2] : 0.0, dArray2, n2, dArray3[0], dArray3[1], dArray3[2], null, bl);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        int n4 = this.isSource3D ? 3 : 2;
        int n5 = this.isTarget3D ? 3 : 2;
        int n6 = 0;
        double[] dArray3 = null;
        if (dArray == dArray2) {
            switch (IterationStrategy.suggest(n, n4, n2, n5, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n4;
                    n4 = -n4;
                    n2 += (n3 - 1) * n5;
                    n5 = -n5;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n, n + n3 * n4);
                    n = 0;
                    break;
                }
                case BUFFER_TARGET: {
                    dArray3 = dArray2;
                    n6 = n2;
                    dArray2 = new double[n3 * n5];
                    n2 = 0;
                }
            }
        }
        double[] dArray4 = new double[3];
        while (--n3 >= 0) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            this.grid.interpolateInCell(this.normalizedToGridX(d), this.normalizedToGridY(d2), dArray4);
            this.transform(d, d2, this.isSource3D ? dArray[n + 2] : 0.0, dArray2, n2, dArray4[0], dArray4[1], dArray4[2], null, false);
            n += n4;
            n2 += n5;
        }
        if (dArray3 != null) {
            System.arraycopy(dArray2, 0, dArray3, n6, dArray2.length);
        }
    }

    @Override
    public MathTransform inverse() {
        return this.inverse;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        GeneralParameterDescriptor[] generalParameterDescriptorArray = new ParameterDescriptor[]{Molodensky.DIMENSION, Molodensky.SRC_SEMI_MAJOR, Molodensky.SRC_SEMI_MINOR, Molodensky.AXIS_LENGTH_DIFFERENCE, Molodensky.FLATTENING_DIFFERENCE, FranceGeocentricInterpolation.FILE};
        return ((ParameterBuilder)((ParameterBuilder)new ParameterBuilder().setRequired(true).setCodeSpace(Citations.SIS, "SIS")).addName(this.context.getDescriptor().getName().getCode() + " (radians domain)")).createGroup(generalParameterDescriptorArray);
    }

    static {
        ParameterBuilder parameterBuilder = (ParameterBuilder)new ParameterBuilder().setRequired(true).setCodeSpace(Citations.SIS, "SIS");
        DESCRIPTOR = ((ParameterBuilder)parameterBuilder.addName("Molodensky interpolation")).createGroupWithSameParameters(InterpolatedGeocentricTransform.DESCRIPTOR);
        INVERSE = ((ParameterBuilder)parameterBuilder.addName("Molodensky inverse interpolation")).createGroupWithSameParameters(InterpolatedGeocentricTransform.DESCRIPTOR);
    }

    static class Inverse
    extends InterpolatedMolodenskyTransform {
        private static final long serialVersionUID = -3520896803296425651L;

        Inverse(InterpolatedMolodenskyTransform interpolatedMolodenskyTransform, Ellipsoid ellipsoid, Ellipsoid ellipsoid2) {
            super(interpolatedMolodenskyTransform, ellipsoid, ellipsoid2);
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
            return this.transform(dArray[n], dArray[n + 1], this.isSource3D ? dArray[n + 2] : 0.0, dArray2, n2, this.tX, this.tY, this.tZ, new double[3], bl);
        }

        @Override
        public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
            int n4 = this.isSource3D ? 3 : 2;
            int n5 = this.isTarget3D ? 3 : 2;
            int n6 = 0;
            double[] dArray3 = null;
            if (dArray == dArray2) {
                switch (IterationStrategy.suggest(n, n4, n2, n5, n3)) {
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        n += (n3 - 1) * n4;
                        n4 = -n4;
                        n2 += (n3 - 1) * n5;
                        n5 = -n5;
                        break;
                    }
                    default: {
                        dArray = Arrays.copyOfRange(dArray, n, n + n3 * n4);
                        n = 0;
                        break;
                    }
                    case BUFFER_TARGET: {
                        dArray3 = dArray2;
                        n6 = n2;
                        dArray2 = new double[n3 * n5];
                        n2 = 0;
                    }
                }
            }
            double[] dArray4 = new double[3];
            while (--n3 >= 0) {
                this.transform(dArray[n], dArray[n + 1], this.isSource3D ? dArray[n + 2] : 0.0, dArray2, n2, this.tX, this.tY, this.tZ, dArray4, false);
                n += n4;
                n2 += n5;
            }
            if (dArray3 != null) {
                System.arraycopy(dArray2, 0, dArray3, n6, dArray2.length);
            }
        }
    }
}

