/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DomainDefinition;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class AbstractMathTransform
extends FormattableObject
implements MathTransform,
Parameterized,
LenientComparable {
    static final int MAXIMUM_BUFFER_SIZE = 512;
    static final int MAXIMUM_FAILURES = 32;
    private transient int hashCode;

    protected AbstractMathTransform() {
    }

    @Override
    public abstract int getSourceDimensions();

    @Override
    public abstract int getTargetDimensions();

    public Optional<Envelope> getDomain(DomainDefinition domainDefinition) throws TransformException {
        ArgumentChecks.ensureNonNull("criteria", domainDefinition);
        return Optional.empty();
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        ContextualParameters contextualParameters = this.getContextualParameters();
        return contextualParameters != null ? contextualParameters.getDescriptor() : null;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return null;
    }

    protected ContextualParameters getContextualParameters() {
        return null;
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    static MismatchedDimensionException mismatchedDimension(String string, int n, int n2) {
        return new MismatchedDimensionException(Errors.format((short)81, string, n, n2));
    }

    @Override
    public DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) throws TransformException {
        int n = this.getSourceDimensions();
        int n2 = this.getTargetDimensions();
        ArgumentChecks.ensureDimensionMatches("ptSrc", n, directPosition);
        if (directPosition2 != null) {
            int n3;
            double[] dArray;
            ArgumentChecks.ensureDimensionMatches("ptDst", n2, directPosition2);
            if (n >= n2) {
                dArray = directPosition.getCoordinate();
            } else {
                dArray = new double[n2];
                n3 = n;
                while (--n3 >= 0) {
                    dArray[n3] = directPosition.getOrdinate(n3);
                }
            }
            this.transform(dArray, 0, dArray, 0, false);
            for (n3 = 0; n3 < n2; ++n3) {
                directPosition2.setOrdinate(n3, dArray[n3]);
            }
        } else {
            double[] dArray;
            GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(n2);
            if (n <= n2) {
                dArray = generalDirectPosition.coordinates;
                for (int i = 0; i < n; ++i) {
                    dArray[i] = directPosition.getOrdinate(i);
                }
            } else {
                dArray = directPosition.getCoordinate();
            }
            this.transform(dArray, 0, generalDirectPosition.coordinates, 0, false);
            directPosition2 = generalDirectPosition;
        }
        return directPosition2;
    }

    public abstract Matrix transform(double[] var1, int var2, double[] var3, int var4, boolean var5) throws TransformException;

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        if (n3 <= 0) {
            return;
        }
        double[] dArray3 = null;
        int n4 = 0;
        int n5 = this.getSourceDimensions();
        int n6 = this.getTargetDimensions();
        if (dArray == dArray2) {
            switch (IterationStrategy.suggest(n, n5, n2, n6, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n5;
                    n5 = -n5;
                    n2 += (n3 - 1) * n6;
                    n6 = -n6;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n, n + n3 * n5);
                    n = 0;
                    break;
                }
                case BUFFER_TARGET: {
                    dArray3 = dArray2;
                    dArray2 = new double[n3 * n6];
                    n4 = n2;
                    n2 = 0;
                }
            }
        }
        TransformException transformException = null;
        int n7 = 0;
        int n8 = 0;
        do {
            block14: {
                try {
                    this.transform(dArray, n, dArray2, n2, false);
                }
                catch (TransformException transformException2) {
                    if ((n7 += Math.abs(n5)) > 32) {
                        throw transformException;
                    }
                    Arrays.fill(dArray2, n2, n2 + Math.abs(n6), Double.NaN);
                    if (transformException == null) {
                        transformException = transformException2;
                        n8 = n;
                    }
                    transformException.addSuppressed(transformException2);
                    if (Math.abs(n - n8) <= 512) break block14;
                    n7 = 0;
                    n8 = n;
                }
            }
            n += n5;
            n2 += n6;
        } while (--n3 != 0);
        if (dArray3 != null) {
            System.arraycopy(dArray2, 0, dArray3, n4, dArray2.length);
        }
        if (transformException != null) {
            transformException.setLastCompletedTransform(this);
            throw transformException;
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws TransformException {
        int n4;
        if (n3 <= 0) {
            return;
        }
        int n5 = this.getSourceDimensions();
        int n6 = this.getTargetDimensions();
        int n7 = Math.max(n5, n6);
        int n8 = n3;
        int n9 = n3 * n7;
        if (n9 > 512) {
            n8 = Math.max(1, 512 / n7);
            n9 = n8 * n7;
        }
        int n10 = n5 * n8;
        int n11 = n6 * n8;
        int n12 = n10;
        int n13 = n11;
        if (fArray == fArray2) {
            n4 = (n3 + n8 - 1) / n8;
            switch (IterationStrategy.suggest(n, n10, n2, n11, n4)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    int n14 = n3 - n8;
                    n += n14 * n5;
                    n2 += n14 * n6;
                    n10 = -n10;
                    n11 = -n11;
                    break;
                }
                default: {
                    fArray = Arrays.copyOfRange(fArray, n, n + n3 * n5);
                    n = 0;
                }
            }
        }
        n4 = n5 >= n6 ? 0 : n13 - n12;
        double[] dArray = new double[n9];
        TransformException transformException = null;
        do {
            int n15;
            if (n3 < n8) {
                n8 = n3;
                n12 = n3 * n5;
                n13 = n3 * n6;
                if (n10 < 0) {
                    n -= n12 + n10;
                    n2 -= n13 + n11;
                }
            }
            for (n15 = 0; n15 < n12; ++n15) {
                dArray[n4 + n15] = fArray[n + n15];
            }
            assert (!IterationStrategy.suggest((int)n4, (int)n5, (int)0, (int)n6, (int)n8).needBuffer);
            try {
                this.transform(dArray, n4, dArray, 0, n8);
            }
            catch (TransformException transformException2) {
                if (transformException2.getLastCompletedTransform() != this) {
                    throw transformException2;
                }
                if (transformException == null) {
                    transformException = transformException2;
                }
                transformException.addSuppressed(transformException2);
            }
            for (n15 = 0; n15 < n13; ++n15) {
                fArray2[n2 + n15] = (float)dArray[n15];
            }
            n += n10;
            n2 += n11;
        } while ((n3 -= n8) != 0);
        if (transformException != null) {
            throw transformException;
        }
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) throws TransformException {
        if (n3 <= 0) {
            return;
        }
        int n4 = this.getSourceDimensions();
        int n5 = this.getTargetDimensions();
        int n6 = n3;
        int n7 = n3 * n5;
        if (n7 > 512) {
            n6 = Math.max(1, 512 / n5);
            n7 = n6 * n5;
        }
        int n8 = n6 * n4;
        int n9 = n6 * n5;
        double[] dArray2 = new double[n7];
        TransformException transformException = null;
        do {
            if (n3 < n6) {
                n6 = n3;
                n8 = n3 * n4;
                n9 = n3 * n5;
            }
            try {
                this.transform(dArray, n, dArray2, 0, n6);
            }
            catch (TransformException transformException2) {
                if (transformException2.getLastCompletedTransform() != this) {
                    throw transformException2;
                }
                if (transformException == null) {
                    transformException = transformException2;
                }
                transformException.addSuppressed(transformException2);
            }
            for (int i = 0; i < n9; ++i) {
                fArray[n2++] = (float)dArray2[i];
            }
            n += n8;
        } while ((n3 -= n6) != 0);
        if (transformException != null) {
            throw transformException;
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) throws TransformException {
        int n4;
        if (n3 <= 0) {
            return;
        }
        int n5 = this.getSourceDimensions();
        if (n5 == (n4 = this.getTargetDimensions())) {
            int n6 = n3 * n5;
            for (int i = 0; i < n6; ++i) {
                dArray[n2 + i] = fArray[n + i];
            }
            this.transform(dArray, n2, dArray, n2, n3);
            return;
        }
        int n7 = n3;
        int n8 = n3 * n5;
        if (n8 > 512) {
            n7 = Math.max(1, 512 / n5);
            n8 = n7 * n5;
        }
        int n9 = n7 * n5;
        int n10 = n7 * n4;
        double[] dArray2 = new double[n8];
        TransformException transformException = null;
        do {
            if (n3 < n7) {
                n7 = n3;
                n9 = n3 * n5;
                n10 = n3 * n4;
            }
            for (int i = 0; i < n9; ++i) {
                dArray2[i] = fArray[n++];
            }
            try {
                this.transform(dArray2, 0, dArray, n2, n7);
            }
            catch (TransformException transformException2) {
                if (transformException2.getLastCompletedTransform() != this) {
                    throw transformException2;
                }
                if (transformException == null) {
                    transformException = transformException2;
                }
                transformException.addSuppressed(transformException2);
            }
            n2 += n10;
        } while ((n3 -= n7) != 0);
        if (transformException != null) {
            throw transformException;
        }
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) throws TransformException {
        int n = this.getSourceDimensions();
        double[] dArray = directPosition.getCoordinate();
        if (dArray.length != n) {
            throw AbstractMathTransform.mismatchedDimension("point", n, dArray.length);
        }
        Matrix matrix = this.transform(dArray, 0, null, 0, true);
        if (matrix == null) {
            throw new TransformException(Resources.format((short)2));
        }
        return matrix;
    }

    @Override
    public MathTransform inverse() throws NoninvertibleTransformException {
        if (this.isIdentity()) {
            return this;
        }
        throw new NoninvertibleTransformException(Resources.format((short)53));
    }

    static boolean isInverseEquals(MathTransform mathTransform, MathTransform mathTransform2) {
        if (mathTransform.getSourceDimensions() != mathTransform2.getTargetDimensions() || mathTransform.getTargetDimensions() != mathTransform2.getSourceDimensions()) {
            return false;
        }
        if (mathTransform instanceof LinearTransform != mathTransform2 instanceof LinearTransform) {
            return false;
        }
        try {
            mathTransform = mathTransform.inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return false;
        }
        if (mathTransform instanceof LenientComparable) {
            return ((LenientComparable)((Object)mathTransform)).equals(mathTransform2, ComparisonMode.APPROXIMATE);
        }
        if (mathTransform2 instanceof LenientComparable) {
            return ((LenientComparable)((Object)mathTransform2)).equals(mathTransform, ComparisonMode.APPROXIMATE);
        }
        return mathTransform.equals(mathTransform2);
    }

    protected MathTransform tryConcatenate(boolean bl, MathTransform mathTransform, MathTransformFactory mathTransformFactory) throws FactoryException {
        if (AbstractMathTransform.isInverseEquals(this, mathTransform)) {
            return MathTransforms.identity(bl ? this.getTargetDimensions() : this.getSourceDimensions());
        }
        return null;
    }

    public final int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = this.computeHashCode();
            if (n == 0) {
                n = -1;
            }
            this.hashCode = n;
        }
        assert (n == -1 || n == this.computeHashCode()) : this;
        return n;
    }

    protected int computeHashCode() {
        return this.getClass().hashCode() + this.getSourceDimensions() + 31 * this.getTargetDimensions();
    }

    @Override
    public final boolean equals(Object object) {
        boolean bl = this.equals(object, ComparisonMode.STRICT);
        assert (!bl || this.computeHashCode() == ((AbstractMathTransform)object).computeHashCode()) : this;
        return bl;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object != null && this.getClass() == object.getClass()) {
            int n;
            int n2;
            AbstractMathTransform abstractMathTransform = (AbstractMathTransform)object;
            if (!comparisonMode.isApproximate() && (n2 = this.hashCode) != 0 && (n = abstractMathTransform.hashCode) != 0 && n2 != n) {
                return false;
            }
            if (comparisonMode.isIgnoringMetadata()) {
                return true;
            }
            return Utilities.deepEquals(this.getContextualParameters(), abstractMathTransform.getContextualParameters(), comparisonMode);
        }
        return false;
    }

    int beforeFormat(List<Object> list, int n, boolean bl) {
        assert (AbstractMathTransform.unwrap(list.get(n), bl) == this);
        ContextualParameters contextualParameters = this.getContextualParameters();
        return contextualParameters != null ? contextualParameters.beforeFormat(list, n, bl) : n;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        WKTUtilities.appendParamMT(this.getParameterValues(), formatter);
        return "Param_MT";
    }

    private static Object unwrap(Object object, boolean bl) {
        return bl ? ((Inverse)object).inverse() : object;
    }

    protected static abstract class Inverse
    extends AbstractMathTransform {
        protected Inverse() {
        }

        @Override
        public int getSourceDimensions() {
            return this.inverse().getTargetDimensions();
        }

        @Override
        public int getTargetDimensions() {
            return this.inverse().getSourceDimensions();
        }

        @Override
        public Optional<Envelope> getDomain(DomainDefinition domainDefinition) throws TransformException {
            MathTransform mathTransform = this.inverse();
            if (mathTransform instanceof AbstractMathTransform) {
                Optional<Envelope> optional = ((AbstractMathTransform)mathTransform).getDomain(domainDefinition);
                return Optional.ofNullable(domainDefinition.intersectOrTransform(optional.orElse(null), mathTransform));
            }
            return Optional.empty();
        }

        @Override
        public Matrix derivative(DirectPosition directPosition) throws TransformException {
            if (directPosition != null) {
                directPosition = this.transform(directPosition, null);
            }
            return Matrices.inverse(this.inverse().derivative(directPosition));
        }

        @Override
        public abstract MathTransform inverse();

        @Override
        public boolean isIdentity() {
            return this.inverse().isIdentity();
        }

        @Override
        protected int computeHashCode() {
            return super.computeHashCode() + 31 * this.inverse().hashCode();
        }

        @Override
        public boolean equals(Object object, ComparisonMode comparisonMode) {
            if (object == this) {
                return true;
            }
            if (object != null && object.getClass() == this.getClass()) {
                MathTransform mathTransform = ((Inverse)object).inverse();
                MathTransform mathTransform2 = this.inverse();
                if (mathTransform2 instanceof LenientComparable) {
                    return ((LenientComparable)((Object)mathTransform2)).equals(mathTransform, comparisonMode);
                }
                return mathTransform2.equals(mathTransform);
            }
            return false;
        }

        @Override
        int beforeFormat(List<Object> list, int n, boolean bl) {
            ContextualParameters contextualParameters = this.getContextualParameters();
            if (contextualParameters != null) {
                return contextualParameters.beforeFormat(list, n, bl);
            }
            MathTransform mathTransform = this.inverse();
            if (mathTransform instanceof AbstractMathTransform) {
                return ((AbstractMathTransform)mathTransform).beforeFormat(list, n, !bl);
            }
            return n;
        }

        @Override
        protected String formatTo(Formatter formatter) {
            ParameterValueGroup parameterValueGroup = this.getParameterValues();
            if (parameterValueGroup != null) {
                WKTUtilities.appendParamMT(parameterValueGroup, formatter);
                return "Param_MT";
            }
            formatter.newLine();
            formatter.append((FormattableObject)((Object)this.inverse()));
            return "Inverse_MT";
        }
    }
}

