/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.quality.DefaultBasicMeasure;
import org.apache.sis.metadata.iso.quality.DefaultMeasureDescription;
import org.apache.sis.metadata.iso.quality.DefaultSourceReference;
import org.apache.sis.metadata.iso.quality.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.util.InternationalString;
import org.opengis.util.TypeName;

@XmlType(name="DQM_Measure_Type", namespace="http://standards.iso.org/iso/19157/-2/dqm/1.0", propOrder={"measureIdentifier", "name", "aliases", "elementNames", "definition", "description", "valueType", "examples", "basicMeasure", "sourceReferences", "parameters"})
@XmlRootElement(name="DQM_Measure", namespace="http://standards.iso.org/iso/19157/-2/dqm/1.0")
@UML(identifier="DQM_Measure", specification=Specification.UNSPECIFIED)
public class DefaultQualityMeasure
extends ISOMetadata {
    private static final long serialVersionUID = -2004468907779670827L;
    private Identifier measureIdentifier;
    private InternationalString name;
    private Collection<InternationalString> aliases;
    private Collection<TypeName> elementNames;
    private DefaultBasicMeasure basicMeasure;
    private InternationalString definition;
    private DefaultMeasureDescription description;
    private Collection<DefaultSourceReference> sourceReferences;
    private TypeName valueType;
    private Collection<ParameterDescriptor<?>> parameters;
    private Collection<DefaultMeasureDescription> examples;

    public DefaultQualityMeasure() {
    }

    public DefaultQualityMeasure(DefaultQualityMeasure defaultQualityMeasure) {
        super(defaultQualityMeasure);
        if (defaultQualityMeasure != null) {
            this.measureIdentifier = defaultQualityMeasure.getMeasureIdentifier();
            this.name = defaultQualityMeasure.getName();
            this.aliases = this.copyCollection(defaultQualityMeasure.getAliases(), InternationalString.class);
            this.elementNames = this.copyCollection(defaultQualityMeasure.getElementNames(), TypeName.class);
            this.definition = defaultQualityMeasure.getDefinition();
            this.description = defaultQualityMeasure.getDescription();
            this.valueType = defaultQualityMeasure.getValueType();
            this.examples = this.copyCollection(defaultQualityMeasure.getExamples(), DefaultMeasureDescription.class);
            this.basicMeasure = defaultQualityMeasure.getBasicMeasure();
            this.sourceReferences = this.copyCollection(defaultQualityMeasure.getSourceReferences(), DefaultSourceReference.class);
            this.parameters = this.copyCollection(defaultQualityMeasure.getParameters(), ParameterDescriptor.class);
        }
    }

    @XmlElement(name="measureIdentifier", required=true)
    @UML(identifier="measureIdentifier", obligation=Obligation.MANDATORY, specification=Specification.UNSPECIFIED)
    public Identifier getMeasureIdentifier() {
        return this.measureIdentifier;
    }

    public void setMeasureIdentifier(Identifier identifier) {
        this.checkWritePermission(this.measureIdentifier);
        this.measureIdentifier = identifier;
    }

    @XmlElement(name="name", required=true)
    @UML(identifier="name", obligation=Obligation.MANDATORY, specification=Specification.UNSPECIFIED)
    public InternationalString getName() {
        return this.name;
    }

    public void setName(InternationalString internationalString) {
        this.checkWritePermission(this.name);
        this.name = internationalString;
    }

    @XmlElement(name="alias")
    @UML(identifier="alias", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public Collection<InternationalString> getAliases() {
        this.aliases = this.nonNullCollection(this.aliases, InternationalString.class);
        return this.aliases;
    }

    public void setAliases(Collection<? extends InternationalString> collection) {
        this.aliases = this.writeCollection(collection, this.aliases, InternationalString.class);
    }

    @XmlElement(name="elementName", required=true)
    @UML(identifier="elementName", obligation=Obligation.MANDATORY, specification=Specification.UNSPECIFIED)
    public Collection<TypeName> getElementNames() {
        this.elementNames = this.nonNullCollection(this.elementNames, TypeName.class);
        return this.elementNames;
    }

    public void setElementNames(Collection<? extends TypeName> collection) {
        this.elementNames = this.writeCollection(collection, this.elementNames, TypeName.class);
    }

    @XmlElement(name="basicMeasure")
    @UML(identifier="basicMeasure", obligation=Obligation.CONDITIONAL, specification=Specification.UNSPECIFIED)
    public DefaultBasicMeasure getBasicMeasure() {
        return this.basicMeasure;
    }

    public void setBasicMeasure(DefaultBasicMeasure defaultBasicMeasure) {
        this.checkWritePermission(this.basicMeasure);
        this.basicMeasure = defaultBasicMeasure;
    }

    @XmlElement(name="definition", required=true)
    @UML(identifier="definition", obligation=Obligation.MANDATORY, specification=Specification.UNSPECIFIED)
    public InternationalString getDefinition() {
        return this.definition;
    }

    public void setDefinition(InternationalString internationalString) {
        this.checkWritePermission(this.definition);
        this.definition = internationalString;
    }

    @XmlElement(name="description")
    @UML(identifier="description", obligation=Obligation.CONDITIONAL, specification=Specification.UNSPECIFIED)
    public DefaultMeasureDescription getDescription() {
        return this.description;
    }

    public void setDescription(DefaultMeasureDescription defaultMeasureDescription) {
        this.checkWritePermission(this.description);
        this.description = defaultMeasureDescription;
    }

    @XmlElement(name="sourceReference")
    @UML(identifier="sourceReference", obligation=Obligation.CONDITIONAL, specification=Specification.UNSPECIFIED)
    public Collection<DefaultSourceReference> getSourceReferences() {
        this.sourceReferences = this.nonNullCollection(this.sourceReferences, DefaultSourceReference.class);
        return this.sourceReferences;
    }

    public void setSourceReferences(Collection<? extends DefaultSourceReference> collection) {
        this.sourceReferences = this.writeCollection(collection, this.sourceReferences, DefaultSourceReference.class);
    }

    @XmlElement(name="valueType", required=true)
    @UML(identifier="valueType", obligation=Obligation.MANDATORY, specification=Specification.UNSPECIFIED)
    public TypeName getValueType() {
        return this.valueType;
    }

    public void setValueType(TypeName typeName) {
        this.checkWritePermission(this.valueType);
        this.valueType = typeName;
    }

    @XmlElement(name="parameter")
    @UML(identifier="parameter", obligation=Obligation.CONDITIONAL, specification=Specification.UNSPECIFIED)
    public Collection<ParameterDescriptor<?>> getParameters() {
        this.parameters = this.nonNullCollection(this.parameters, ParameterDescriptor.class);
        return this.parameters;
    }

    public void setParameters(Collection<? extends ParameterDescriptor<?>> collection) {
        this.parameters = this.writeCollection(collection, this.parameters, ParameterDescriptor.class);
    }

    @XmlElement(name="example")
    @UML(identifier="example", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public Collection<DefaultMeasureDescription> getExamples() {
        this.examples = this.nonNullCollection(this.examples, DefaultMeasureDescription.class);
        return this.examples;
    }

    public void setExamples(Collection<? extends DefaultMeasureDescription> collection) {
        this.examples = this.writeCollection(collection, this.examples, DefaultMeasureDescription.class);
    }
}

