/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import org.apache.sis.internal.util.DefinitionURI;
import org.apache.sis.internal.util.FinalFieldSetter;
import org.apache.sis.math.Fraction;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.ConventionalUnit;
import org.apache.sis.measure.Prefixes;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.UnitDimension;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.Localized;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public class UnitFormat
extends Format
implements javax.measure.format.UnitFormat,
Localized {
    private static final long serialVersionUID = -3064428584419360693L;
    private static final boolean PARSE_AUTHORITY_CODES = true;
    private static final String DEGREES = "degrees";
    private static final String UNITY = "unity";
    static final UnitFormat INSTANCE = new UnitFormat();
    private Locale locale;
    private Style style;
    private final Map<Unit<?>, String> unitToLabel;
    private final Map<String, Unit<?>> labelToUnit;
    private volatile transient ResourceBundle symbolToName;
    private volatile transient Map<String, Unit<?>> nameToUnit;
    private static final WeakValueHashMap<Locale, Map<String, Unit<?>>> SHARED = new WeakValueHashMap(Locale.class);

    private UnitFormat() {
        this.locale = Locale.ROOT;
        this.style = Style.SYMBOL;
        this.unitToLabel = Collections.emptyMap();
        this.labelToUnit = Collections.emptyMap();
    }

    public UnitFormat(Locale locale) {
        ArgumentChecks.ensureNonNull("locale", locale);
        this.locale = locale;
        this.style = Style.SYMBOL;
        this.unitToLabel = new HashMap();
        this.labelToUnit = new HashMap();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        ArgumentChecks.ensureNonNull("locale", locale);
        this.locale = locale;
        this.symbolToName = null;
        this.nameToUnit = null;
    }

    @Override
    public boolean isLocaleSensitive() {
        return this.style == Style.NAME;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        ArgumentChecks.ensureNonNull("style", (Object)style);
        this.style = style;
    }

    @Override
    public void label(Unit<?> unit, String string) {
        int n;
        ArgumentChecks.ensureNonNull("unit", unit);
        string = CharSequences.trimWhitespaces(string);
        ArgumentChecks.ensureNonEmpty("label", string);
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (AbstractUnit.isSymbolChar(n) || Character.isSpaceChar(n)) continue;
            throw new IllegalArgumentException(Errors.format((short)45, "label", string));
        }
        Unit<?> unit2 = unit;
        if (unit2 instanceof ConventionalUnit) {
            unit2 = ((ConventionalUnit)unit2).forSymbol(string);
        }
        Unit<?> unit3 = this.labelToUnit.remove(this.unitToLabel.put(unit, string));
        Unit<?> unit4 = this.labelToUnit.put(string, unit2);
        if (unit4 != null && !unit4.equals(unit2) && !string.equals(this.unitToLabel.remove(unit4))) {
            throw new CorruptedObjectException("unitToLabel");
        }
        if (unit3 != null && !unit3.getSystemUnit().equals(unit.getSystemUnit())) {
            throw new CorruptedObjectException("labelToUnit");
        }
    }

    static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("org.apache.sis.measure.UnitNames", locale, UnitFormat.class.getClassLoader());
    }

    private ResourceBundle symbolToName() {
        ResourceBundle resourceBundle = this.symbolToName;
        if (resourceBundle == null) {
            this.symbolToName = resourceBundle = UnitFormat.getBundle(this.locale);
        }
        return resourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Unit<?> fromName(String string) {
        Map<String, Unit<?>> map;
        int n = string.length();
        int n2 = 0;
        while (true) {
            if (n2 != DEGREES.length()) {
                if (n2 == n || (string.charAt(n2) | 0x20) != DEGREES.charAt(n2)) {
                    if (n2 != 3 && n2 != 6) break;
                }
            } else {
                if (n == n2) {
                    return Units.DEGREE;
                }
                int n3 = string.codePointAt(n2);
                if (n3 == 95 || Character.isSpaceChar(n3)) {
                    n2 += Character.charCount(n3);
                }
                if (n - n2 != 1) break;
                switch (string.charAt(n2)) {
                    case 'K': 
                    case '\u212a': {
                        return Units.KELVIN;
                    }
                    case 'C': {
                        return Units.CELSIUS;
                    }
                    case 'E': 
                    case 'N': {
                        return Units.DEGREE;
                    }
                }
                break;
            }
            ++n2;
        }
        if ((map = this.nameToUnit) == null) {
            map = SHARED.get(this.locale);
            if (map == null) {
                map = new HashMap(128);
                UnitFormat.copy(this.locale, this.symbolToName(), map);
                if (!this.locale.equals(Locale.US)) {
                    UnitFormat.copy(Locale.US, UnitFormat.getBundle(Locale.US), map);
                }
                if (!this.locale.equals(Locale.ROOT)) {
                    UnitFormat.copy(Locale.ROOT, UnitFormat.getBundle(Locale.ROOT), map);
                }
                ResourceBundle resourceBundle = ResourceBundle.getBundle("org.apache.sis.measure.UnitAliases", this.locale, UnitFormat.class.getClassLoader());
                for (String object : resourceBundle.keySet()) {
                    map.put(object.intern(), Units.get(resourceBundle.getString(object)));
                }
                map = Collections.unmodifiableMap(map);
                WeakValueHashMap<Locale, Map<String, Unit<?>>> weakValueHashMap = SHARED;
                synchronized (weakValueHashMap) {
                    for (Map<String, Unit<?>> map2 : SHARED.values()) {
                        if (!map.equals(map2)) continue;
                        map = map2;
                        break;
                    }
                    SHARED.put(this.locale, map);
                }
            }
            this.nameToUnit = map;
        }
        string = string.replace('_', ' ').toLowerCase(this.locale);
        Unit<?> unit = map.get(string = CharSequences.replace(CharSequences.replace(CharSequences.replace(CharSequences.toASCII(string), "meters", "meter"), "metres", "metre"), DEGREES, "degree").toString());
        if (unit == null) {
            int n4 = string.length();
            if (--n4 > 0 && UnitFormat.isDigit(string.charAt(n4))) {
                while (--n4 >= 0) {
                    if (UnitFormat.isDigit(string.charAt(n4))) continue;
                    if (string.charAt(n4) == '-' && --n4 < 0 || (unit = map.get(string.substring(0, ++n4))) == null) break;
                    unit = unit.pow(Integer.parseInt(string.substring(n4)));
                    break;
                }
            }
        }
        return unit;
    }

    private static void copy(Locale locale, ResourceBundle resourceBundle, Map<String, Unit<?>> map) {
        for (String string : resourceBundle.keySet()) {
            map.put(CharSequences.toASCII(resourceBundle.getString(string).toLowerCase(locale)).toString().intern(), Units.get(string));
        }
    }

    @Override
    public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
        Map<Unit<?>, Number> map;
        Map<Unit<?>, Number> map2;
        ArgumentChecks.ensureNonNull("unit", unit);
        ArgumentChecks.ensureNonNull("toAppendTo", appendable);
        Unit<?> unit2 = this.unitToLabel.get(unit);
        if (unit2 != null) {
            return appendable.append((CharSequence)((Object)unit2));
        }
        if (this.style == Style.NAME) {
            if (!(unit instanceof AbstractUnit)) {
                unit2 = unit.getName();
                if (unit2 != null) {
                    return appendable.append((CharSequence)((Object)unit2));
                }
            } else {
                unit2 = unit.getSymbol();
                if (unit2 != null) {
                    if (((String)((Object)unit2)).isEmpty()) {
                        unit2 = UNITY;
                    }
                    ResourceBundle resourceBundle = this.symbolToName();
                    try {
                        unit2 = resourceBundle.getString((String)((Object)unit2));
                    }
                    catch (MissingResourceException missingResourceException) {
                        Logging.ignorableException(Logger.getLogger("org.apache.sis.measure"), UnitFormat.class, "format", missingResourceException);
                    }
                    return appendable.append((CharSequence)((Object)unit2));
                }
            }
        }
        if ((unit2 = unit.getSymbol()) != null) {
            return this.style.appendSymbol(appendable, (String)((Object)unit2));
        }
        unit2 = unit.getSystemUnit();
        double d = AbstractConverter.scale(unit.getConverterTo(unit2));
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException(Errors.format((short)104, "?\u22c5(" + unit2 + ')'));
        }
        int n = 0;
        boolean bl = false;
        if (unit2 instanceof AbstractUnit) {
            map = map2 = ((AbstractUnit)unit2).getBaseSystemUnits();
            for (Map.Entry<Unit<?>, Number> entry : map2.entrySet()) {
                Fraction fraction = (Fraction)entry.getValue();
                if (fraction.signum() <= 0) continue;
                bl = true;
                if (n == 0 && fraction.denominator == 1 && ((SystemUnit)entry.getKey()).isPrefixable()) {
                    n = fraction.numerator;
                    continue;
                }
                n = 0;
                break;
            }
        } else {
            map2 = unit2.getBaseUnits();
            if (map2 == null) {
                map2 = Collections.singletonMap(unit, 1);
            }
            map = map2;
            for (Map.Entry<Unit<?>, Number> entry : map2.entrySet()) {
                int n2 = (Integer)entry.getValue();
                if (n2 <= 0) continue;
                bl = true;
                if (n == 0 && AbstractUnit.isPrefixable(entry.getKey())) {
                    n = n2;
                    continue;
                }
                n = 0;
                break;
            }
        }
        if (d != 1.0) {
            char c = Prefixes.symbol(d, n);
            if (c != '\u0000') {
                appendable.append(Prefixes.concat(c, ""));
            } else {
                double d2;
                boolean bl2;
                boolean bl3 = bl2 = this.style != Style.UCUM;
                if (bl2 && (bl2 = AbstractConverter.epsilonEquals(d2 = Math.log10(d), d2 = (double)Math.round(d2)))) {
                    appendable.append("10");
                    String string = Integer.toString((int)d2);
                    for (int i = 0; i < string.length(); ++i) {
                        appendable.append(Characters.toSuperScript(string.charAt(i)));
                    }
                }
                if (!bl2) {
                    String string = Double.toString(d);
                    int n3 = string.length();
                    if (string.endsWith(".0")) {
                        n3 -= 2;
                    }
                    appendable.append(string, 0, n3);
                }
                if (bl) {
                    appendable.append(this.style.multiply);
                }
            }
        } else if (!bl) {
            appendable.append('1');
        }
        UnitFormat.formatComponents(map, this.style, appendable);
        return appendable;
    }

    static void formatComponents(Map<?, ? extends Number> map, Style style, Appendable appendable) throws IOException {
        boolean bl = true;
        ArrayList arrayList = new ArrayList(map.size());
        for (Map.Entry<?, Number> entry : map.entrySet()) {
            int n;
            Number object = entry.getValue();
            int n2 = n = object instanceof Fraction ? ((Fraction)object).numerator : object.intValue();
            if (n > 0) {
                if (!bl) {
                    appendable.append(style.multiply);
                }
                bl = false;
                UnitFormat.formatComponent(entry, false, style, appendable);
                continue;
            }
            if (n == 0) continue;
            arrayList.add(entry);
        }
        if (!arrayList.isEmpty()) {
            boolean bl2;
            appendable.append(style.divide);
            boolean bl3 = bl2 = arrayList.size() > 1;
            if (bl2) {
                appendable.append('(');
            }
            bl = true;
            for (Map.Entry entry : arrayList) {
                if (!bl) {
                    appendable.append(style.multiply);
                }
                bl = false;
                UnitFormat.formatComponent(entry, true, style, appendable);
            }
            if (bl2) {
                appendable.append(')');
            }
        }
    }

    private static void formatComponent(Map.Entry<?, ? extends Number> entry, boolean bl, Style style, Appendable appendable) throws IOException {
        int n;
        UnitFormat.formatSymbol(entry.getKey(), style, appendable);
        Number number = entry.getValue();
        if (number instanceof Fraction) {
            Fraction fraction = (Fraction)number;
            if (fraction.denominator != 1) {
                if (bl) {
                    fraction = fraction.negate();
                }
                style.appendPower(appendable, fraction);
                return;
            }
            n = fraction.numerator;
        } else {
            n = number.intValue();
        }
        if (bl) {
            n = -n;
        }
        if (n != 1) {
            style.appendPower(appendable, n);
        }
    }

    private static void formatSymbol(Object object, Style style, Appendable appendable) throws IOException {
        String string;
        char c;
        if (object instanceof UnitDimension && (c = ((UnitDimension)object).symbol) != '\u0000') {
            appendable.append(c);
            return;
        }
        if (object instanceof Unit && (string = ((Unit)object).getSymbol()) != null) {
            style.appendSymbol(appendable, string);
            return;
        }
        appendable.append('?');
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        try {
            return (StringBuffer)this.format((Unit)object, stringBuffer);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public String format(Unit<?> unit) {
        try {
            return this.format(unit, new StringBuilder()).toString();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private static int exponentOperator(CharSequence charSequence, int n, int n2) {
        if (n >= 0 && ++n < n2) {
            char c = charSequence.charAt(n);
            if (c == '*') {
                return 1;
            }
            if ((UnitFormat.isDigit(c) || UnitFormat.isSign(c)) && UnitFormat.isDigit(charSequence.charAt(n - 2))) {
                return 0;
            }
        }
        return -1;
    }

    private static boolean isDecimalSeparator(CharSequence charSequence, int n, int n2) {
        return n == 0 || UnitFormat.isDigit(charSequence.charAt(n - 1)) && (++n >= n2 || UnitFormat.isDigit(charSequence.charAt(n)));
    }

    private static boolean isDigit(int n) {
        return n >= 48 && n <= 57;
    }

    private static boolean isSign(int n) {
        return n == 43 || n == 45;
    }

    private static boolean isDivisor(int n) {
        return n == 47 || n == 8725;
    }

    private static boolean hasDigit(CharSequence charSequence, int n, int n2) {
        while (n < n2) {
            if (!UnitFormat.isDigit(charSequence.charAt(n++))) continue;
            return true;
        }
        return false;
    }

    private static void finish(ParsePosition parsePosition) {
        if (parsePosition instanceof Position) {
            ((Position)parsePosition).finished = true;
        }
    }

    @Override
    public Unit<?> parse(CharSequence charSequence) throws ParserException {
        int n;
        Position position = new Position();
        Unit<?> unit = this.parse(charSequence, position);
        int n2 = charSequence.length();
        while ((n = CharSequences.skipLeadingWhitespaces(charSequence, position.getIndex(), n2)) < n2) {
            if (position.finished || !Character.isLetter(Character.codePointAt(charSequence, n))) {
                throw new ParserException(Errors.format((short)135, CharSequences.trimWhitespaces(charSequence, 0, n), CharSequences.trimWhitespaces(charSequence, n, n2)), charSequence, n);
            }
            position.setIndex(n);
            unit = unit.multiply(this.parse(charSequence, position));
        }
        return unit;
    }

    @Override
    public Unit<?> parse(CharSequence charSequence, ParsePosition parsePosition) throws ParserException {
        int n;
        int n2;
        int n3;
        int n4;
        ArgumentChecks.ensureNonNull("symbols", charSequence);
        ArgumentChecks.ensureNonNull("position", parsePosition);
        int n5 = charSequence.length();
        int n6 = CharSequences.skipLeadingWhitespaces(charSequence, parsePosition.getIndex(), n5);
        Object object = DefinitionURI.codeOf("uom", "EPSG", charSequence);
        if (object != null) {
            NumberFormatException numberFormatException = null;
            try {
                Unit<?> unit = Units.valueOfEPSG(Integer.parseInt((String)object));
                if (unit != null) {
                    parsePosition.setIndex(n5);
                    UnitFormat.finish(parsePosition);
                    return unit;
                }
            }
            catch (NumberFormatException numberFormatException2) {
                numberFormatException = numberFormatException2;
            }
            throw (ParserException)new ParserException(Errors.format((short)150, "EPSG:" + (String)object), charSequence, n6 + Math.max(0, charSequence.toString().lastIndexOf((String)object))).initCause(numberFormatException);
        }
        object = new Operation(charSequence);
        Unit<?> unit = null;
        boolean bl = false;
        block11: for (n3 = n6; n3 < n5; n3 += n4) {
            int n7 = Character.codePointAt(charSequence, n3);
            n4 = Character.charCount(n7);
            switch (n7) {
                case 45: {
                    if (n3 + n4 < n5 && Character.isDigit(Character.codePointAt(charSequence, n3 + n4))) continue block11;
                }
                default: {
                    if (AbstractUnit.isSymbolChar(n7)) {
                        if (((Operation)object).code != 1) continue block11;
                        ((Operation)object).code = 2;
                        continue block11;
                    }
                    if (Character.isDigit(n7) || Characters.isSuperScript(n7)) continue block11;
                    if (!Character.isSpaceChar(n7)) break block11;
                    bl = true;
                    continue block11;
                }
                case 42: {
                    n2 = UnitFormat.exponentOperator(charSequence, n3, n5);
                    if (n2 < 0) {
                        n = 2;
                        break;
                    }
                    n3 += n2;
                }
                case 94: {
                    if (((Operation)object).code != 1) continue block11;
                    n = 4;
                    break;
                }
                case 46: {
                    if (UnitFormat.isDecimalSeparator(charSequence, n3, n5)) continue block11;
                }
                case 215: 
                case 8901: {
                    n = 2;
                    break;
                }
                case 47: 
                case 247: 
                case 8260: 
                case 8725: {
                    n = 3;
                    break;
                }
                case 40: {
                    n2 = n3 + Character.charCount(n7);
                    ParsePosition parsePosition2 = new ParsePosition(n2);
                    Unit<?> unit2 = this.parse(charSequence, parsePosition2);
                    n3 = CharSequences.skipLeadingWhitespaces(charSequence, parsePosition2.getIndex(), n5);
                    if (n3 >= n5 || Character.codePointAt(charSequence, n3) != 41) {
                        throw new ParserException(Errors.format((short)101, charSequence.subSequence(n6, n3), Character.valueOf(')')), charSequence, n6);
                    }
                    unit = ((Operation)object).apply(unit, unit2, n2);
                    ((Operation)object).code = 1;
                    n4 = 1;
                    n6 = n3 + 1;
                    continue block11;
                }
            }
            if (n3 > n6 && n3 + n4 < n5 && Character.isDigit(Character.codePointBefore(charSequence, n3)) && Character.isDigit(Character.codePointAt(charSequence, n3 + n4))) continue;
            if (((Operation)object).code != 1) {
                unit = ((Operation)object).apply(unit, this.parseTerm(charSequence, n6, n3, (Operation)object), n6);
            }
            bl = false;
            ((Operation)object).code = n;
            n6 = n3 + n4;
        }
        Unit<?> unit3 = null;
        if (bl) {
            String string;
            n5 = n3;
            n6 = CharSequences.skipLeadingWhitespaces(charSequence, n6, n3);
            block12: while ((n3 = CharSequences.skipTrailingWhitespaces(charSequence, n6, n3)) > n6 && (unit3 = this.labelToUnit.get(string = charSequence.subSequence(n6, n3).toString())) == null && (unit3 = this.fromName(string)) == null) {
                n = n3;
                while ((n -= Character.charCount(n2 = Character.codePointBefore(charSequence, n))) > n6) {
                    if (!Character.isWhitespace(n2)) continue;
                    n3 = n;
                    continue block12;
                }
                break block12;
            }
            if (UnitFormat.hasDigit(charSequence, n6, n3)) {
                n3 = n5;
            }
        }
        if (!(((Operation)object).finished = unit3 != null)) {
            unit3 = this.parseTerm(charSequence, n6, n3, (Operation)object);
        }
        if (((Operation)object).finished) {
            UnitFormat.finish(parsePosition);
        }
        unit = ((Operation)object).apply(unit, unit3, n6);
        parsePosition.setIndex(n3);
        return unit;
    }

    private Unit<?> parseTerm(CharSequence charSequence, int n, int n2, Operation operation) throws ParserException {
        String string = CharSequences.trimWhitespaces(charSequence, n, n2).toString();
        Unit<?> unit = this.labelToUnit.get(string);
        boolean bl = operation.finished = unit != null;
        if (unit == null && (unit = Prefixes.getUnit(string)) == null) {
            int n3 = string.length();
            if (n3 == 0) {
                return Units.UNITY;
            }
            char c = string.charAt(0);
            if (UnitFormat.isDigit(c) || UnitFormat.isSign(c)) {
                double d;
                try {
                    int n4;
                    int n5 = string.indexOf(32);
                    if (n5 >= 0 && (n4 = CharSequences.skipLeadingWhitespaces(string, n5, n3)) < n3 && AbstractUnit.isSymbolChar(string.codePointAt(n4))) {
                        operation.finished = true;
                        double d2 = Double.parseDouble(string.substring(0, n5));
                        return this.parseTerm(string, n5, n3, new Operation(string)).multiply(d2);
                    }
                    d = UnitFormat.parseMultiplicationFactor(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw (ParserException)new ParserException(Errors.format((short)150, string), charSequence, n).initCause(numberFormatException);
                }
                if (operation.code == 1) {
                    operation.code = 4;
                }
                return Units.UNITY.multiply(d);
            }
            if (n3 >= 2) {
                Fraction fraction = null;
                int n6 = n3;
                int n7 = string.codePointBefore(n6);
                n6 -= Character.charCount(n7);
                if (Characters.isSuperScript(n7)) {
                    if (UnitFormat.isDigit(n7 = Characters.toNormalScript(n7))) {
                        fraction = new Fraction(n7 - 48, 1);
                    }
                } else if (UnitFormat.isDigit(n7)) {
                    while (n6 != 0) {
                        boolean bl2;
                        n7 = string.codePointBefore(n6);
                        boolean bl3 = bl2 = UnitFormat.isDigit(n7) || UnitFormat.isDivisor(n7);
                        if (bl2 || UnitFormat.isSign(n7)) {
                            n6 -= Character.charCount(n7);
                        }
                        if (bl2) continue;
                        try {
                            fraction = new Fraction(string.substring(n6));
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw (ParserException)new ParserException(Errors.format((short)150, string), charSequence, n + n6).initCause(numberFormatException);
                        }
                    }
                }
                if (fraction != null) {
                    String string2;
                    if ((n6 = CharSequences.skipTrailingWhitespaces(string, 0, n6)) != 0) {
                        switch (string.charAt(n6 - 1)) {
                            case '*': {
                                if (n6 != 1 && string.charAt(n6 - 2) == '*') {
                                    --n6;
                                }
                            }
                            case '^': {
                                n6 = CharSequences.skipTrailingWhitespaces(string, 0, n6 - 1);
                            }
                        }
                    }
                    boolean bl4 = operation.finished = (unit = this.labelToUnit.get(string2 = string.substring(CharSequences.skipLeadingWhitespaces(string, 0, n6), n6))) != null;
                    if (unit == null) {
                        unit = Prefixes.getUnit(string2);
                    }
                    if (unit != null) {
                        int n8 = fraction.numerator;
                        int n9 = fraction.denominator;
                        if (n8 < 0 && operation.invert()) {
                            n8 = -n8;
                        }
                        if (n8 != 1) {
                            unit = unit.pow(n8);
                        }
                        if (n9 != 1) {
                            unit = unit.root(n9);
                        }
                        return unit;
                    }
                }
            }
            operation.finished = true;
            unit = this.fromName(string);
            if (unit == null) {
                if (CharSequences.regionMatches(charSequence, n, UNITY, true)) {
                    return Units.UNITY;
                }
                throw new ParserException(Errors.format((short)150, string), charSequence, n);
            }
        }
        return unit;
    }

    private static double parseMultiplicationFactor(String string) throws NumberFormatException {
        int n;
        String string2;
        int n2 = string.lastIndexOf(42);
        if (n2 >= 0 || (n2 = string.lastIndexOf(94)) >= 0) {
            string2 = string.substring(n2 + 1);
        } else {
            n2 = string.length();
            n = string.codePointBefore(n2);
            if (!Characters.isSuperScript(n)) {
                return Double.parseDouble(string);
            }
            StringBuilder stringBuilder = new StringBuilder(n2);
            do {
                stringBuilder.appendCodePoint(Characters.toNormalScript(n));
            } while ((n2 -= Character.charCount(n)) > 0 && Characters.isSuperScript(n = string.codePointBefore(n2)));
            string2 = stringBuilder.reverse().toString();
        }
        n = Integer.parseInt(string.substring(0, n2));
        int n3 = Integer.parseInt(string2);
        return n == 10 ? MathFunctions.pow10(n3) : Math.pow(n, n3);
    }

    @Override
    public Object parseObject(String string) throws ParseException {
        try {
            return this.parse(string);
        }
        catch (ParserException parserException) {
            throw (ParseException)new ParseException(parserException.getLocalizedMessage(), parserException.getPosition()).initCause(parserException);
        }
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        try {
            return this.parse(string, parsePosition);
        }
        catch (ParserException parserException) {
            parsePosition.setErrorIndex(parserException.getPosition());
            return null;
        }
    }

    @Override
    public UnitFormat clone() {
        UnitFormat unitFormat = (UnitFormat)super.clone();
        try {
            FinalFieldSetter.set(UnitFormat.class, "unitToLabel", "labelToUnit", unitFormat, UnitFormat.clone(this.unitToLabel), UnitFormat.clone(this.labelToUnit));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw FinalFieldSetter.cloneFailure(reflectiveOperationException);
        }
        return unitFormat;
    }

    private static Object clone(Map<?, ?> map) {
        if (map instanceof HashMap) {
            return ((HashMap)map).clone();
        }
        return new HashMap();
    }

    public static enum Style {
        SYMBOL('\u22c5', '\u2215'),
        UCUM('.', '/'){

            @Override
            Appendable appendSymbol(Appendable appendable, String string) throws IOException {
                if (string.startsWith("\u00b0")) {
                    int n = string.length();
                    if (n == 2) {
                        switch (string.charAt(1)) {
                            case 'C': {
                                return appendable.append("Cel");
                            }
                            case 'K': 
                            case '\u212a': {
                                return appendable.append('K');
                            }
                        }
                    }
                    return appendable.append("deg").append(string, 1, n);
                }
                CharSequence charSequence = CharSequences.toASCII(string);
                int n = charSequence.length();
                for (int i = 0; i < n; ++i) {
                    appendable.append(Characters.toNormalScript(charSequence.charAt(i)));
                }
                return appendable;
            }

            @Override
            void appendPower(Appendable appendable, int n) throws IOException {
                appendable.append(String.valueOf(n));
            }

            @Override
            void appendPower(Appendable appendable, Fraction fraction) throws IOException {
                appendable.append('^').append('(').append(String.valueOf(fraction.numerator)).append('/').append(String.valueOf(fraction.denominator)).append(')');
            }
        }
        ,
        NAME('\u22c5', '\u2215');

        static final char EXPONENT_OR_MULTIPLY = '*';
        static final char EXPONENT = '^';
        static final char OPEN = '(';
        static final char CLOSE = ')';
        final char multiply;
        final char divide;

        private Style(char c, char c2) {
            this.multiply = c;
            this.divide = c2;
        }

        Appendable appendSymbol(Appendable appendable, String string) throws IOException {
            return appendable.append(string);
        }

        void appendPower(Appendable appendable, int n) throws IOException {
            if (n >= 0 && n <= 9) {
                appendable.append(Characters.toSuperScript((char)(n + 48)));
            } else {
                appendable.append(String.valueOf(n));
            }
        }

        void appendPower(Appendable appendable, Fraction fraction) throws IOException {
            appendable.append('^');
            String string = fraction.toString();
            if (string.length() == 1) {
                appendable.append(string);
            } else {
                appendable.append('(').append(string).append(')');
            }
        }
    }

    private static final class Position
    extends ParsePosition {
        boolean finished;

        Position() {
            super(0);
        }
    }

    private static final class Operation {
        static final int NOOP = 0;
        static final int IMPLICIT = 1;
        static final int MULTIPLY = 2;
        static final int DIVIDE = 3;
        static final int EXPONENT = 4;
        int code;
        private final CharSequence symbols;
        boolean finished;

        Operation(CharSequence charSequence) {
            this.symbols = charSequence;
        }

        Unit<?> apply(Unit<?> unit, Unit<?> unit2, int n) {
            switch (this.code) {
                case 0: {
                    return unit2;
                }
                case 1: 
                case 2: {
                    return unit.multiply(unit2);
                }
                case 3: {
                    return unit.divide(unit2);
                }
                case 4: {
                    double d;
                    int n2;
                    String string;
                    if (UnitDimension.isDimensionless(unit2.getDimension()) && ((string = unit2.getSymbol()) == null || string.isEmpty()) && (double)(n2 = (int)(d = Units.toStandardUnit(unit2))) == d) {
                        return unit.pow(n2);
                    }
                    throw new ParserException(Errors.format((short)171, unit2), this.symbols, n);
                }
            }
            throw new AssertionError(this.code);
        }

        boolean invert() {
            switch (this.code) {
                case 1: 
                case 2: {
                    this.code = 3;
                    return true;
                }
            }
            return false;
        }
    }
}

