/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.Locale;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.internal.coverage.CoverageCombiner;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.storage.io.ChannelDataOutput;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.IncompatibleResourceException;
import org.apache.sis.storage.ReadOnlyStorageException;
import org.apache.sis.storage.ResourceAlreadyExistsException;
import org.apache.sis.storage.WritableGridCoverageResource;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class WritableResourceSupport
implements Localized {
    private final GridCoverageResource resource;
    private boolean replace;
    private boolean update;

    public WritableResourceSupport(GridCoverageResource gridCoverageResource, WritableGridCoverageResource.Option[] optionArray) {
        this.resource = gridCoverageResource;
        ArgumentChecks.ensureNonNull("options", optionArray);
        for (WritableGridCoverageResource.Option option : optionArray) {
            this.replace |= WritableGridCoverageResource.CommonOption.REPLACE.equals(option);
            this.update |= WritableGridCoverageResource.CommonOption.UPDATE.equals(option);
        }
        if (this.replace & this.update) {
            throw new IllegalArgumentException(Errors.format((short)91, WritableGridCoverageResource.CommonOption.REPLACE, WritableGridCoverageResource.CommonOption.UPDATE));
        }
    }

    @Override
    public final Locale getLocale() {
        return this.resource instanceof Localized ? ((Localized)((Object)this.resource)).getLocale() : null;
    }

    public final ChannelDataOutput channel(ChannelDataInput channelDataInput) throws IOException, DataStoreException {
        if (channelDataInput.channel instanceof WritableByteChannel && channelDataInput.rewind()) {
            return new ChannelDataOutput(channelDataInput.filename, (WritableByteChannel)((Object)channelDataInput.channel), channelDataInput.buffer);
        }
        throw new ReadOnlyStorageException(this.canNotWrite());
    }

    public final boolean replace(ChannelDataInput channelDataInput) throws IOException, DataStoreException {
        if (this.update) {
            return WritableResourceSupport.isEmpty(channelDataInput);
        }
        if (this.replace || WritableResourceSupport.isEmpty(channelDataInput)) {
            return true;
        }
        String string = this.resource.getIdentifier().orElse(null);
        if (string == null && channelDataInput != null) {
            string = channelDataInput.filename;
        }
        throw new ResourceAlreadyExistsException(Resources.forLocale(this.getLocale()).getString((short)48, string));
    }

    private static boolean isEmpty(ChannelDataInput channelDataInput) throws IOException {
        return channelDataInput != null && channelDataInput.length() == 0L;
    }

    public final GridCoverage update(GridCoverage gridCoverage) throws DataStoreException {
        GridCoverage gridCoverage2 = this.resource.read(null, null);
        CoverageCombiner coverageCombiner = new CoverageCombiner(gridCoverage2, 0, 1);
        try {
            if (!coverageCombiner.apply(gridCoverage)) {
                throw new ReadOnlyStorageException(this.canNotWrite());
            }
        }
        catch (TransformException transformException) {
            throw new DataStoreReferencingException(this.canNotWrite(), transformException);
        }
        return gridCoverage2;
    }

    public final AffineTransform getAffineTransform2D(GridExtent gridExtent, MathTransform mathTransform) throws DataStoreException {
        TransformSeparator transformSeparator = new TransformSeparator(mathTransform);
        try {
            transformSeparator.addSourceDimensions(gridExtent.getSubspaceDimensions(2));
            return AffineTransforms2D.castOrCopy(transformSeparator.separate());
        }
        catch (CannotEvaluateException | FactoryException exception) {
            throw new DataStoreReferencingException(this.canNotWrite(), exception);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IncompatibleResourceException(this.canNotWrite(), illegalArgumentException);
        }
    }

    public final String canNotWrite() throws DataStoreException {
        String string = this.resource.getIdentifier().orElse(null);
        if (string == null) {
            string = Classes.getShortClassName(this.resource);
        }
        return Resources.forLocale(this.getLocale()).getString((short)69, string);
    }

    public final String rotationNotSupported(String string) {
        return Resources.forLocale(this.getLocale()).getString((short)70, string);
    }
}

