/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.processing.isoline;

import java.awt.geom.Path2D;
import java.util.Arrays;
import java.util.Map;
import org.apache.sis.internal.feature.j2d.PathBuilder;
import org.apache.sis.internal.processing.isoline.PolylineStage;
import org.apache.sis.util.ArraysExt;

final class PolylineBuffer {
    static final int DIMENSION = 2;
    double[] coordinates;
    int size;
    PolylineBuffer opposite;

    PolylineBuffer() {
        this.coordinates = ArraysExt.EMPTY_DOUBLE;
    }

    PolylineBuffer(double[] dArray) {
        this.coordinates = dArray;
        this.size = dArray.length;
    }

    final void clear() {
        this.opposite = null;
        this.size = 0;
    }

    final boolean isEmpty() {
        return this.size == 0 & this.opposite == null;
    }

    final PolylineBuffer attach(PolylineBuffer polylineBuffer) {
        assert (this.opposite == null & polylineBuffer.opposite == null);
        polylineBuffer.opposite = this;
        this.opposite = polylineBuffer;
        return this;
    }

    final PolylineBuffer transferFrom(PolylineBuffer polylineBuffer) {
        assert (this.isEmpty());
        double[] dArray = this.coordinates;
        this.coordinates = polylineBuffer.coordinates;
        this.size = polylineBuffer.size;
        this.opposite = polylineBuffer.opposite;
        if (this.opposite != null) {
            this.opposite.opposite = this;
        }
        polylineBuffer.clear();
        polylineBuffer.coordinates = dArray;
        return this;
    }

    final boolean transferToOpposite() {
        if (this.opposite == null) {
            return false;
        }
        int n = this.size + this.opposite.size;
        double[] dArray = this.opposite.coordinates;
        if (n > dArray.length) {
            dArray = new double[n];
        }
        System.arraycopy(this.opposite.coordinates, 0, dArray, this.size, this.opposite.size);
        int n2 = 0;
        int n3 = this.size;
        while ((n3 -= 2) >= 0) {
            dArray[n3] = this.coordinates[n2++];
            dArray[n3 + 1] = this.coordinates[n2++];
        }
        this.opposite.size = n;
        this.opposite.coordinates = dArray;
        this.opposite.opposite = null;
        this.clear();
        return true;
    }

    final void append(double d, double d2) {
        if (this.size >= this.coordinates.length) {
            this.coordinates = Arrays.copyOf(this.coordinates, Math.max(Math.multiplyExact(this.size, 2), 32));
        }
        this.coordinates[this.size++] = d;
        this.coordinates[this.size++] = d2;
    }

    public String toString() {
        return PathBuilder.toString(this.coordinates, this.size);
    }

    final void toRawPath(Map<PolylineStage, Path2D> map) {
        PolylineStage.BUFFER.add(map, this.coordinates, this.size);
    }
}

