/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.coverage.BandedCoverage;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.ConvertedGridCoverage;
import org.apache.sis.coverage.grid.DefaultEvaluator;
import org.apache.sis.coverage.grid.FractionalGridCoordinates;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.DataType;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.internal.coverage.j2d.Colorizer;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public abstract class GridCoverage
extends BandedCoverage {
    protected final GridGeometry gridGeometry;
    private final SampleDimension[] sampleDimensions;
    private transient GridCoverage packedView;
    private transient GridCoverage convertedView;

    protected GridCoverage(GridGeometry gridGeometry, List<? extends SampleDimension> list) {
        ArgumentChecks.ensureNonNull("domain", gridGeometry);
        ArgumentChecks.ensureNonEmpty("ranges", list);
        this.gridGeometry = gridGeometry;
        this.sampleDimensions = list.toArray(new SampleDimension[list.size()]);
        ArgumentChecks.ensureNonEmpty("range", this.sampleDimensions);
        for (int i = 0; i < this.sampleDimensions.length; ++i) {
            ArgumentChecks.ensureNonNullElement("range", i, this.sampleDimensions[i]);
        }
    }

    GridCoverage(GridCoverage gridCoverage, GridGeometry gridGeometry) {
        this.gridGeometry = gridGeometry;
        this.sampleDimensions = gridCoverage.sampleDimensions;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.gridGeometry.getCoordinateReferenceSystem();
    }

    @Override
    public Optional<Envelope> getEnvelope() {
        if (this.gridGeometry.isDefined(2)) {
            return Optional.of(this.gridGeometry.getEnvelope());
        }
        return Optional.empty();
    }

    public GridGeometry getGridGeometry() {
        return this.gridGeometry;
    }

    @Override
    public List<SampleDimension> getSampleDimensions() {
        return UnmodifiableArrayList.wrap(this.sampleDimensions);
    }

    private NumberRange<?>[] getRanges() {
        NumberRange[] numberRangeArray = null;
        for (int i = 0; i < this.sampleDimensions.length; ++i) {
            Optional<NumberRange<?>> optional = this.sampleDimensions[i].getSampleRange();
            if (!optional.isPresent()) continue;
            if (numberRangeArray == null) {
                numberRangeArray = new NumberRange[this.sampleDimensions.length];
            }
            numberRangeArray[i] = optional.get();
        }
        return numberRangeArray;
    }

    DataType getBandType() {
        return DataType.DOUBLE;
    }

    public synchronized GridCoverage forConvertedValues(boolean bl) {
        GridCoverage gridCoverage;
        GridCoverage gridCoverage2 = gridCoverage = bl ? this.convertedView : this.packedView;
        if (gridCoverage == null) {
            gridCoverage = this.createConvertedValues(bl);
            if (bl) {
                this.convertedView = gridCoverage;
                if (gridCoverage != this) {
                    gridCoverage.packedView = this;
                }
            } else {
                this.packedView = gridCoverage;
                if (gridCoverage != this) {
                    gridCoverage.convertedView = this;
                }
            }
        }
        return gridCoverage;
    }

    protected GridCoverage createConvertedValues(boolean bl) {
        try {
            return ConvertedGridCoverage.create(this, bl);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new CannotEvaluateException(noninvertibleTransformException.getMessage(), noninvertibleTransformException);
        }
    }

    final RenderedImage convert(RenderedImage renderedImage, DataType dataType, MathTransform1D[] mathTransform1DArray, ImageProcessor imageProcessor) {
        int n = Math.max(0, ImageUtilities.getVisibleBand(renderedImage));
        Colorizer colorizer = new Colorizer(Colorizer.GRAYSCALE);
        ColorModel colorModel = colorizer.initialize(renderedImage.getSampleModel(), this.sampleDimensions[n]) || colorizer.initialize(renderedImage.getColorModel()) ? colorizer.createColorModel(dataType.toDataBufferType(), this.sampleDimensions.length, n) : Colorizer.NULL_COLOR_MODEL;
        return imageProcessor.convert(renderedImage, this.getRanges(), mathTransform1DArray, dataType, colorModel);
    }

    @Override
    public Evaluator evaluator() {
        return new DefaultEvaluator(this);
    }

    public abstract RenderedImage render(GridExtent var1);

    public String toString() {
        return this.toTree(Locale.getDefault(), this.gridGeometry.defaultFlags()).toString();
    }

    public TreeTable toTree(Locale locale, int n) {
        ArgumentChecks.ensureNonNull("locale", locale);
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        TableColumn<CharSequence> tableColumn = TableColumn.VALUE_AS_TEXT;
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(tableColumn);
        TreeTable.Node node = defaultTreeTable.getRoot();
        node.setValue(tableColumn, Classes.getShortClassName(this));
        TreeTable.Node node2 = node.newChild();
        node2.setValue(tableColumn, vocabulary.getString((short)39));
        this.gridGeometry.formatTo(locale, vocabulary, n, node2);
        this.appendDataLayout(node, vocabulary, tableColumn);
        node2 = node.newChild();
        node2.setValue(tableColumn, vocabulary.getString((short)178));
        node2.newChild().setValue(tableColumn, SampleDimension.toString(locale, this.sampleDimensions));
        return defaultTreeTable;
    }

    void appendDataLayout(TreeTable.Node node, Vocabulary vocabulary, TableColumn<CharSequence> tableColumn) {
    }

    public static interface Evaluator
    extends BandedCoverage.Evaluator {
        @Override
        public GridCoverage getCoverage();

        public Map<Integer, Long> getDefaultSlice();

        public void setDefaultSlice(Map<Integer, Long> var1);

        public FractionalGridCoordinates toGridCoordinates(DirectPosition var1) throws TransformException;
    }

    static final class Lazy {
        static final ImageProcessor PROCESSOR = new ImageProcessor();

        private Lazy() {
        }
    }
}

