/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.xml;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSource {
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private InputStream stream;
    private Document doc;

    public XMLSource(InputStream is) {
        this.stream = is;
    }

    public void setBuffering() {
        try {
            this.doc = StaxUtils.read(this.stream);
            this.stream = null;
        }
        catch (XMLStreamException e) {
            throw new Fault(e);
        }
    }

    public <T> T getNode(String expression, Class<T> cls) {
        return this.getNode(expression, CastUtils.cast(Collections.emptyMap(), String.class, String.class), cls);
    }

    public <T> T getNode(String expression, Map<String, String> namespaces, Class<T> cls) {
        Object obj = this.evaluate(expression, namespaces, XPathConstants.NODE);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Node) {
            Node node = (Node)obj;
            if (cls.isPrimitive() || cls == String.class) {
                return (T)this.readPrimitiveValue(node, cls);
            }
            return this.readNode(node, cls);
        }
        return cls.cast(this.evaluate(expression, namespaces, XPathConstants.STRING));
    }

    public <T> T[] getNodes(String expression, Class<T> cls) {
        return this.getNodes(expression, CastUtils.cast(Collections.emptyMap(), String.class, String.class), cls);
    }

    public <T> T[] getNodes(String expression, Map<String, String> namespaces, Class<T> cls) {
        NodeList nodes = (NodeList)this.evaluate(expression, namespaces, XPathConstants.NODESET);
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        Object[] values = (Object[])Array.newInstance(cls, nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            values[i] = InjectionUtils.isPrimitive(cls) ? this.readPrimitiveValue(node, cls) : this.readNode(node, cls);
        }
        return values;
    }

    public URI getLink(String expression) {
        return this.getLink(expression, CastUtils.cast(Collections.emptyMap(), String.class, String.class));
    }

    public URI getLink(String expression, Map<String, String> namespaces) {
        String value = this.getValue(expression, namespaces);
        return value == null ? null : URI.create(value);
    }

    public URI[] getLinks(String expression, Map<String, String> namespaces) {
        String[] values = this.getValues(expression, namespaces);
        if (values == null) {
            return null;
        }
        URI[] uris = new URI[values.length];
        for (int i = 0; i < values.length; ++i) {
            uris[i] = URI.create(values[i]);
        }
        return uris;
    }

    public URI getBaseURI() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("xml", XML_NAMESPACE);
        return this.getLink("/*/@xml:base", map);
    }

    public String getValue(String expression) {
        return this.getValue(expression, CastUtils.cast(Collections.emptyMap(), String.class, String.class));
    }

    public String getValue(String expression, Map<String, String> namespaces) {
        return this.getValue(expression, namespaces, String.class);
    }

    public String[] getValues(String expression) {
        return this.getValues(expression, CastUtils.cast(Collections.emptyMap(), String.class, String.class));
    }

    public String[] getValues(String expression, Map<String, String> namespaces) {
        return this.getNodes(expression, namespaces, String.class);
    }

    public <T> T getValue(String expression, Map<String, String> namespaces, Class<T> cls) {
        Object result = this.evaluate(expression, namespaces, XPathConstants.STRING);
        return (T)(result == null ? null : InjectionUtils.convertStringToPrimitive(result.toString(), cls));
    }

    private Object evaluate(String expression, Map<String, String> namespaces, QName type) {
        XPathFactory factory = XPathFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (XPathFactoryConfigurationException e) {
            throw new RuntimeException(e);
        }
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(new NamespaceContextImpl(namespaces));
        boolean releaseDoc = false;
        try {
            if (this.stream != null) {
                this.setBuffering();
                releaseDoc = true;
            }
            Object object = xpath.compile(expression).evaluate(this.doc, type);
            return object;
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException("Illegal XPath expression '" + expression + "'", ex);
        }
        finally {
            if (releaseDoc) {
                this.doc = null;
            }
        }
    }

    private <T> Object readPrimitiveValue(Node node, Class<T> cls) {
        if (String.class == cls) {
            if (node.getNodeType() == 1) {
                return StaxUtils.toString((Element)node);
            }
            return cls.cast(node.getNodeValue());
        }
        return InjectionUtils.convertStringToPrimitive(node.getNodeValue(), cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T readNode(Node node, Class<T> cls) {
        if (Node.class.isAssignableFrom(cls)) {
            return cls.cast(node);
        }
        DOMSource s = new DOMSource(node);
        if (Source.class == cls) return cls.cast(s);
        if (DOMSource.class == cls) {
            return cls.cast(s);
        }
        try {
            JAXBElementProvider provider = new JAXBElementProvider();
            JAXBContext c = provider.getPackageContext(cls);
            if (c == null) {
                c = provider.getClassContext(cls);
            }
            Unmarshaller u = c.createUnmarshaller();
            try {
                if (cls.getAnnotation(XmlRootElement.class) != null) {
                    T t = cls.cast(u.unmarshal(s));
                    return t;
                }
                T t = u.unmarshal(s, cls).getValue();
                return t;
            }
            finally {
                JAXBUtils.closeUnmarshaller(u);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static class NamespaceContextImpl
    implements NamespaceContext {
        private Map<String, String> namespaces;

        NamespaceContextImpl(Map<String, String> namespaces) {
            this.namespaces = namespaces;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.namespaces.get(prefix);
        }

        @Override
        public String getPrefix(String namespace) {
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                if (!entry.getValue().equals(namespace)) continue;
                return entry.getKey();
            }
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(String namespace) {
            String prefix = this.namespaces.get(namespace);
            if (prefix == null) {
                return null;
            }
            return Collections.singletonList(prefix).iterator();
        }
    }
}

