/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.util;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TezRuntimeShutdownHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TezRuntimeShutdownHandler.class);
    private static final List<Runnable> shutdownTasks = new ArrayList<Runnable>();

    private TezRuntimeShutdownHandler() {
    }

    public static void addShutdownTask(Runnable r) {
        shutdownTasks.add(r);
    }

    public static synchronized void shutdown() {
        LOG.info("Handling {} shutdown tasks", (Object)shutdownTasks.size());
        for (Runnable shutdownTask : shutdownTasks) {
            shutdownTask.run();
        }
    }
}

