/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.util;

import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldFocusPriority;
import org.apache.tapestry5.ValidationDecorator;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.internal.util.ValidationDecoratorWrapper;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public class AutofocusValidationDecorator
extends ValidationDecoratorWrapper {
    private final ValidationTracker tracker;
    private final JavaScriptSupport jsSupport;

    public AutofocusValidationDecorator(ValidationDecorator delegate, ValidationTracker tracker, JavaScriptSupport javascriptSupport) {
        super(delegate);
        this.tracker = tracker;
        this.jsSupport = javascriptSupport;
    }

    @Override
    public void insideField(Field field) {
        super.insideField(field);
        if (!field.isDisabled()) {
            this.jsSupport.autofocus(this.getPriority(field), field.getClientId());
        }
    }

    private FieldFocusPriority getPriority(Field field) {
        if (this.tracker.inError(field)) {
            return FieldFocusPriority.IN_ERROR;
        }
        if (field.isRequired()) {
            return FieldFocusPriority.REQUIRED;
        }
        return FieldFocusPriority.OPTIONAL;
    }
}

