/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixWriter;
import org.apache.sysds.runtime.matrix.data.IJV;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.HDFSTool;

public class WriterMatrixMarket
extends MatrixWriter {
    @Override
    public final void writeMatrixToHDFS(MatrixBlock src, String fname, long rlen, long clen, int blen, long nnz, boolean diag) throws IOException, DMLRuntimeException {
        if ((long)src.getNumRows() != rlen || (long)src.getNumColumns() != clen) {
            throw new IOException("Matrix dimensions mismatch with metadata: " + src.getNumRows() + "x" + src.getNumColumns() + " vs " + rlen + "x" + clen + ".");
        }
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        HDFSTool.deleteFileIfExistOnHDFS(fname);
        this.writeMatrixMarketMatrixToHDFS(path, job, fs, src);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeEmptyMatrixToHDFS(String fname, long rlen, long clen, int blen) throws IOException, DMLRuntimeException {
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        FSDataOutputStream writer = null;
        try {
            writer = fs.create(path);
            writer.writeBytes("0 0 0\n");
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    protected void writeMatrixMarketMatrixToHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock src) throws IOException {
        WriterMatrixMarket.writeMatrixMarketMatrixToFile(path, job, fs, src, 0, src.getNumRows());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeMatrixMarketMatrixToFile(Path path, JobConf job, FileSystem fs, MatrixBlock src, int rl, int ru) throws IOException {
        boolean sparse = src.isInSparseFormat();
        int rlen = src.getNumRows();
        int clen = src.getNumColumns();
        long nnz = src.getNonZeros();
        BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));
        try {
            StringBuilder sb = new StringBuilder();
            if (rl == 0) {
                sb.append("%%MatrixMarket matrix coordinate real general\n");
                sb.append(rlen + " " + clen + " " + nnz + "\n");
                br.write(sb.toString());
                sb.setLength(0);
            }
            if (sparse) {
                Iterator<IJV> iter = src.getSparseBlockIterator(rl, ru);
                while (iter.hasNext()) {
                    IJV cell = iter.next();
                    sb.append(cell.getI() + 1);
                    sb.append(' ');
                    sb.append(cell.getJ() + 1);
                    sb.append(' ');
                    sb.append(cell.getV());
                    sb.append('\n');
                    br.write(sb.toString());
                    sb.setLength(0);
                }
            } else if (!src.isEmpty()) {
                DenseBlock d = src.getDenseBlock();
                for (int i = rl; i < ru; ++i) {
                    String rowIndex = Integer.toString(i + 1);
                    for (int j = 0; j < clen; ++j) {
                        double lvalue = d.get(i, j);
                        if (lvalue == 0.0) continue;
                        sb.append(rowIndex);
                        sb.append(' ');
                        sb.append(j + 1);
                        sb.append(' ');
                        sb.append(lvalue);
                        sb.append('\n');
                        br.write(sb.toString());
                        sb.setLength(0);
                    }
                }
            }
            if (src.isEmptyBlock(false) && rl == 0) {
                br.write("0 0 0\n");
            }
        }
        finally {
            IOUtilFunctions.closeSilently(br);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeTextcellToMatrixMarket(String srcFileName, String fileName, long rlen, long clen, long nnz) throws IOException {
        Configuration conf = new Configuration((Configuration)ConfigurationManager.getCachedJobConf());
        Path src = new Path(srcFileName);
        Path merge = new Path(fileName);
        FileSystem fs = IOUtilFunctions.getFileSystem(src, conf);
        if (fs.exists(merge)) {
            fs.delete(merge, true);
        }
        FSDataOutputStream out = fs.create(merge, true);
        StringBuilder sb = new StringBuilder();
        sb.append("%%MatrixMarket matrix coordinate real general\n");
        sb.append(rlen + " " + clen + " " + nnz + "\n");
        out.write(sb.toString().getBytes());
        if (fs.getFileStatus(src).isDirectory()) {
            try {
                FileStatus[] contents = fs.listStatus(src);
                for (int i = 0; i < contents.length; ++i) {
                    if (contents[i].isDirectory()) continue;
                    FSDataInputStream in = fs.open(contents[i].getPath());
                    try {
                        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)conf, (boolean)false);
                        continue;
                    }
                    finally {
                        IOUtilFunctions.closeSilently((Closeable)in);
                    }
                }
            }
            finally {
                IOUtilFunctions.closeSilently((Closeable)out);
            }
        } else if (fs.getFileStatus(src).isDirectory()) {
            FSDataInputStream in = null;
            try {
                in = fs.open(src);
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)conf, (boolean)true);
            }
            finally {
                IOUtilFunctions.closeSilently((Closeable)in);
                IOUtilFunctions.closeSilently((Closeable)out);
            }
        } else {
            throw new IOException(src.toString() + ": No such file or directory");
        }
    }
}

