/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.matrix.data.LibCommonsMath;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class MultiReturnBuiltinCPInstruction
extends ComputationCPInstruction {
    protected ArrayList<CPOperand> _outputs;
    protected int _numThreads;

    private MultiReturnBuiltinCPInstruction(Operator op, CPOperand input1, ArrayList<CPOperand> outputs, String opcode, String istr, int threads) {
        super(CPInstruction.CPType.MultiReturnBuiltin, op, input1, null, outputs.get(0), opcode, istr);
        this._outputs = outputs;
        this._numThreads = threads;
    }

    private MultiReturnBuiltinCPInstruction(Operator op, CPOperand input1, CPOperand input2, ArrayList<CPOperand> outputs, String opcode, String istr, int threads) {
        super(CPInstruction.CPType.MultiReturnBuiltin, op, input1, input2, outputs.get(0), opcode, istr);
        this._outputs = outputs;
        this._numThreads = threads;
    }

    public CPOperand getOutput(int i) {
        return this._outputs.get(i);
    }

    public List<CPOperand> getOutputs() {
        return this._outputs;
    }

    public String[] getOutputNames() {
        return (String[])this._outputs.parallelStream().map(output -> output.getName()).toArray(String[]::new);
    }

    public static MultiReturnBuiltinCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        ArrayList<CPOperand> outputs = new ArrayList<CPOperand>();
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase(Opcodes.QR.toString())) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            int threads = Integer.parseInt(parts[4]);
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str, threads);
        }
        if (opcode.equalsIgnoreCase(Opcodes.LU.toString())) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[4], Types.ValueType.FP64, Types.DataType.MATRIX));
            int threads = Integer.parseInt(parts[5]);
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str, threads);
        }
        if (opcode.equalsIgnoreCase(Opcodes.EIGEN.toString())) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            int threads = Integer.parseInt(parts[4]);
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str, threads);
        }
        if (opcode.equalsIgnoreCase(Opcodes.FFT.toString())) {
            if (parts.length == 5) {
                CPOperand in1 = new CPOperand(parts[1]);
                outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
                outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
                int threads = Integer.parseInt(parts[4]);
                return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str, threads);
            }
            if (parts.length == 4) {
                outputs.add(new CPOperand(parts[1], Types.ValueType.FP64, Types.DataType.MATRIX));
                outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
                int threads = Integer.parseInt(parts[3]);
                return new MultiReturnBuiltinCPInstruction(null, null, outputs, opcode, str, threads);
            }
            throw new NotImplementedException("Invalid number of arguments for FFT.");
        }
        if (parts.length == 5 && opcode.equalsIgnoreCase(Opcodes.FFT_LINEARIZED.toString())) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            int threads = Integer.parseInt(parts[4]);
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str, threads);
        }
        if (parts.length == 3 && opcode.equalsIgnoreCase(Opcodes.FFT_LINEARIZED.toString())) {
            outputs.add(new CPOperand(parts[1], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
            int threads = Integer.parseInt(parts[3]);
            return new MultiReturnBuiltinCPInstruction(null, null, outputs, opcode, str, threads);
        }
        if (opcode.equalsIgnoreCase(Opcodes.STFT.toString())) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            int threads = Integer.parseInt(parts[4]);
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str, threads);
        }
        if (opcode.equalsIgnoreCase(Opcodes.SVD.toString())) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[4], Types.ValueType.FP64, Types.DataType.MATRIX));
            int threads = Integer.parseInt(parts[5]);
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str, threads);
        }
        throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + opcode);
    }

    public int getNumOutputs() {
        return this._outputs.size();
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        if (!LibCommonsMath.isSupportedMultiReturnOperation(this.getOpcode())) {
            throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + this.getOpcode());
        }
        MatrixBlock in = ec.getMatrixInput(this.input1.getName());
        MatrixBlock[] out = LibCommonsMath.multiReturnOperations(in, this.getOpcode(), this._numThreads);
        ec.releaseMatrixInput(this.input1.getName());
        for (int i = 0; i < this._outputs.size(); ++i) {
            ec.setMatrixOutput(this._outputs.get(i).getName(), out[i]);
        }
    }

    @Override
    public boolean hasSingleLineage() {
        return false;
    }

    @Override
    public Pair<String, LineageItem>[] getLineageItems(ExecutionContext ec) {
        LineageItem[] inputLineage = LineageItemUtils.getLineage(ec, this.input1, this.input2, this.input3);
        Pair[] ret = new Pair[this._outputs.size()];
        for (int i = 0; i < this._outputs.size(); ++i) {
            CPOperand out = this._outputs.get(i);
            ret[i] = Pair.of((Object)out.getName(), (Object)new LineageItem(this.getOpcode(), inputLineage));
        }
        return ret;
    }
}

